/*
 * Decompiled with CFR 0.152.
 */
package org.databene.profile;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.databene.stat.LatencyCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile {
    private String name;
    private Profile parent;
    private Map<String, Profile> subProfiles;
    private LatencyCounter counter;
    private DecimalFormat nf = new DecimalFormat("0");
    private DecimalFormat df = new DecimalFormat("0.0");

    public Profile(String name, Profile parent) {
        this.parent = parent;
        this.name = name;
        this.counter = new LatencyCounter(name);
        this.subProfiles = new HashMap<String, Profile>();
    }

    public String getName() {
        return this.name;
    }

    public Profile getParent() {
        return this.parent;
    }

    public Collection<Profile> getSubProfiles() {
        return this.subProfiles.values();
    }

    public Profile getOrCreateSubProfile(String name) {
        Profile result = this.subProfiles.get(name);
        if (result == null) {
            result = this.createSubProfile(name);
        }
        return result;
    }

    private Profile createSubProfile(String name) {
        Profile result = new Profile(name, this);
        this.subProfiles.put(name, result);
        return result;
    }

    public void addSample(int duration) {
        this.counter.addSample(duration);
    }

    public long getInvocationCount() {
        return this.counter.sampleCount();
    }

    public long getTotalLatency() {
        return this.counter.totalLatency();
    }

    public double getAverageLatency() {
        return this.counter.averageLatency();
    }

    public String toString() {
        return "[" + this.nf.format(this.getInvocationCount()) + " inv., " + "avg: " + this.df.format(this.getAverageLatency()) + ", " + "total: " + this.nf.format(this.getTotalLatency()) + "]: " + this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Profile that = (Profile)obj;
        return this.name.equals(that.name);
    }
}

