/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import org.apache.commons.lang.math.NumberUtils;
import org.sonar.graph.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedbackEdge
implements Comparable<FeedbackEdge> {
    private Edge edge;
    private double relativeWeight;
    private int occurences;
    private final int hashcode;

    public FeedbackEdge(Edge edge, int occurences) {
        this.edge = edge;
        this.hashcode = edge.hashCode();
        this.occurences = occurences;
        this.relativeWeight = (double)edge.getWeight() / (double)occurences;
    }

    protected Edge getEdge() {
        return this.edge;
    }

    protected int getWeight() {
        return this.edge.getWeight();
    }

    protected double getRelativeWeight() {
        return this.relativeWeight;
    }

    protected int getOccurences() {
        return this.occurences;
    }

    @Override
    public int compareTo(FeedbackEdge feedbackEdge) {
        if (this.getRelativeWeight() < feedbackEdge.getRelativeWeight()) {
            return -1;
        }
        if (NumberUtils.compare((double)this.getRelativeWeight(), (double)feedbackEdge.getRelativeWeight()) == 0) {
            return this.getEdge().getFrom().toString().compareTo(feedbackEdge.getEdge().getFrom().toString());
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeedbackEdge) || this.hashCode() != obj.hashCode()) {
            return false;
        }
        FeedbackEdge otherEdge = (FeedbackEdge)obj;
        return this.edge.equals(otherEdge.edge);
    }

    public int hashCode() {
        return this.hashcode;
    }
}

