/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.rpm.LogStreamConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

final class RPMSigner {
    private final File gpgPath;
    private final String gpgName;
    private final char[] passphrase;
    private final Log log;

    public RPMSigner(File gpgPath, String gpgName, char[] passphrase, Log log) {
        this.gpgPath = gpgPath;
        this.gpgName = gpgName;
        this.passphrase = passphrase;
        this.log = log;
    }

    public void sign(File rpm) throws IOException {
        block11: {
            if (!rpm.exists() || !rpm.canRead()) {
                throw new IllegalStateException(rpm.getAbsolutePath() + " is not a valid rpm file or cannot be read");
            }
            if (this.passphrase != null) {
                Commandline cl = new Commandline();
                cl.setExecutable("expect");
                cl.setWorkingDirectory(rpm.getParentFile());
                cl.createArg().setValue("-c");
                cl.createArg().setValue("sleep 1");
                cl.createArg().setValue("-");
                LogStreamConsumer stdout = new LogStreamConsumer(1, this.log);
                LogStreamConsumer stderr = new LogStreamConsumer(2, this.log);
                try {
                    ByteArrayInputStream is;
                    int result;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)("About to execute '" + cl.toString() + "'"));
                    }
                    if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (InputStream)(is = new ByteArrayInputStream(this.writeExpectScriptFile(rpm))), (StreamConsumer)stdout, (StreamConsumer)stderr)) != 0) {
                        throw new IllegalStateException("RPM sign execution returned: '" + result + "' executing '" + cl.toString() + "'");
                    }
                    break block11;
                }
                catch (CommandLineException e) {
                    IllegalStateException ise = new IllegalStateException("Unable to sign the RPM");
                    ise.initCause(e);
                    throw ise;
                }
            }
            Commandline cl = new Commandline();
            cl.setExecutable("rpmsign");
            cl.setWorkingDirectory(rpm.getParentFile());
            cl.createArg().setValue("--define");
            cl.createArg().setValue("_gpg_name " + this.gpgName);
            if (this.gpgPath != null) {
                cl.createArg().setValue("--define");
                cl.createArg().setValue("_gpg_path " + this.gpgPath);
            }
            cl.createArg().setValue("--addsign");
            cl.createArg().setValue(rpm.getName());
            LogStreamConsumer stdout = new LogStreamConsumer(1, this.log);
            LogStreamConsumer stderr = new LogStreamConsumer(2, this.log);
            try {
                int result;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("About to execute '" + cl.toString() + "'"));
                }
                if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr)) != 0) {
                    throw new IllegalStateException("RPM sign execution returned: '" + result + "' executing '" + cl.toString() + "'");
                }
            }
            catch (CommandLineException e) {
                IllegalStateException ise = new IllegalStateException("Unable to sign the RPM");
                ise.initCause(e);
                throw ise;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeExpectScriptFile(File rpm) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(baos));
        try {
            writer.println("set timeout -1");
            writer.print("spawn rpm --define \"_gpg_name ");
            writer.print(this.gpgName);
            writer.print("\"");
            if (this.gpgPath != null) {
                writer.print(" --define \"_gpg_path ");
                writer.print(this.gpgPath + "\"");
            }
            writer.print(" --addsign ");
            writer.println(rpm.getName());
            writer.println("expect {");
            writer.println(" \"Enter pass phrase: \" {");
            writer.println("send -- \"" + new String(this.passphrase) + "\r\"");
            writer.println("expect {");
            writer.println(" \"Pass phrase is good.\" {");
            writer.println("      expect eof");
            writer.println("      exit 0");
            writer.println("  }");
            writer.println(" \"signing failed\" {");
            writer.println("      expect eof");
            writer.println("      exit 1");
            writer.println("  }");
            writer.println("}");
            writer.println("}");
            writer.println(" \"" + this.gpgName + ": \" {");
            writer.println("             expect eof");
            writer.println("             exit 0");
            writer.println("             }");
            writer.println("}");
            writer.println();
            writer.flush();
        }
        finally {
            writer.close();
        }
        return baos.toByteArray();
    }
}

