/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.spring_app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.codehaus.enunciate.modules.spring_app.EnunciateServiceAdvice;
import org.codehaus.enunciate.modules.spring_app.EnunciateServiceAdvisor;
import org.codehaus.enunciate.modules.spring_app.SpringComponentPostProcessor;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.Ordered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpointFactoryBean
extends ApplicationObjectSupport
implements FactoryBean {
    private boolean initialized = false;
    private final List<Object> interceptors = new ArrayList<Object>();
    private final Class serviceInterface;
    private Object serviceImplementationBean;
    private String defaultImplementationBeanName;
    private Class defaultImplementationClass;

    public ServiceEndpointFactoryBean(Class serviceInterface) {
        if (serviceInterface == null) {
            throw new ApplicationContextException("A service interface must be provided to create a service endpoint.");
        }
        this.serviceInterface = serviceInterface;
    }

    protected void initApplicationContext(ApplicationContext context) throws BeansException {
        Map adviceBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, EnunciateServiceAdvice.class);
        for (Object advice : adviceBeans.values()) {
            this.addInterceptor(advice);
        }
        Map advisorBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, EnunciateServiceAdvisor.class);
        for (Object advisor : advisorBeans.values()) {
            this.addInterceptor(advisor);
        }
        if (this.serviceImplementationBean == null && this.defaultImplementationBeanName != null) {
            try {
                this.serviceImplementationBean = context.getBean(this.defaultImplementationBeanName, this.serviceInterface);
            }
            catch (BeansException e) {
                // empty catch block
            }
        }
        if (this.serviceImplementationBean == null) {
            ArrayList<String> beanNames = new ArrayList<String>(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context, (Class)this.serviceInterface, (boolean)false, (boolean)false)));
            Iterator beanNamesIt = beanNames.iterator();
            while (beanNamesIt.hasNext()) {
                String factoryName = "&" + (String)beanNamesIt.next();
                if (!context.containsBean(factoryName) || !ServiceEndpointFactoryBean.class.isAssignableFrom(context.getType(factoryName))) continue;
                beanNamesIt.remove();
            }
            if (beanNames.size() > 1) {
                StringBuilder builder = new StringBuilder("There are more than one beans of type ");
                builder.append(this.serviceInterface.getName());
                builder.append(" in the application context (");
                Iterator beanNameIt = beanNames.iterator();
                while (beanNameIt.hasNext()) {
                    Object beanName = beanNameIt.next();
                    builder.append(beanName);
                    if (!beanNameIt.hasNext()) continue;
                    builder.append(", ");
                }
                builder.append("). Cannot determine which one to use to handle the service requests.");
                if (this.defaultImplementationBeanName != null) {
                    builder.append("Either reduce the number of beans of this type to one, or specify which one to use by naming it \"");
                    builder.append(this.defaultImplementationBeanName);
                    builder.append("\".");
                } else {
                    builder.append("Please reduce the number of beans of this type to one.");
                }
                throw new ApplicationContextException(builder.toString());
            }
            if (beanNames.size() == 1) {
                this.serviceImplementationBean = context.getBean((String)beanNames.get(0));
            }
        }
        if (this.serviceImplementationBean == null) {
            if (this.defaultImplementationClass == null) {
                throw new ApplicationContextException("Unable to create a service implementation bean for interface " + this.serviceInterface + ". Please provide a default implementation class.");
            }
            try {
                this.serviceImplementationBean = this.defaultImplementationClass.newInstance();
                SpringComponentPostProcessor.autowire(this.serviceImplementationBean, this.getApplicationContext());
            }
            catch (Exception e) {
                throw new ApplicationContextException("Unable to instantiate " + this.defaultImplementationClass.getName(), (Throwable)e);
            }
        }
        this.initialized = true;
    }

    public void setInterceptors(List<Object> interceptors) {
        this.interceptors.clear();
        for (Object globalServiceInterceptor : interceptors) {
            this.addInterceptor(globalServiceInterceptor);
        }
    }

    protected void addInterceptor(Object interceptor) {
        int index;
        if (!(interceptor instanceof Advice) && !(interceptor instanceof Advisor)) {
            throw new ApplicationContextException("Attempt to inject an interceptor that is neither advice nor an advisor (class: " + interceptor.getClass() + ").");
        }
        int order = 0;
        if (interceptor instanceof Ordered) {
            order = ((Ordered)interceptor).getOrder();
        }
        for (index = this.interceptors.size() - 1; index >= 0; --index) {
            Object item = this.interceptors.get(index);
            int itemOrder = 0;
            if (item instanceof Ordered) {
                itemOrder = ((Ordered)item).getOrder();
            }
            if (order >= itemOrder) break;
        }
        this.interceptors.add(index + 1, interceptor);
    }

    public Object getObject() throws Exception {
        if (!this.initialized) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.wrapEndpoint(this.serviceInterface, this.serviceImplementationBean);
    }

    public Class getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object wrapEndpoint(final Class iface, Object endpointImpl) throws Exception {
        Object endpoint = endpointImpl;
        if (this.interceptors.size() > 0) {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource(endpointImpl){

                public Class getTargetClass() {
                    return iface;
                }
            });
            for (Object interceptor : this.interceptors) {
                if (interceptor instanceof Advice) {
                    proxyFactory.addAdvice((Advice)interceptor);
                    continue;
                }
                if (interceptor instanceof Advisor) {
                    proxyFactory.addAdvisor((Advisor)interceptor);
                    continue;
                }
                throw new ApplicationContextException("Attempt to inject an interceptor that is neither advice nor an advisor (class: " + interceptor.getClass() + ").");
            }
            endpoint = proxyFactory.getProxy();
        }
        return endpoint;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public Object getServiceImplementationBean() {
        return this.serviceImplementationBean;
    }

    public void setServiceImplementationBean(Object serviceImplementationBean) {
        this.serviceImplementationBean = serviceImplementationBean;
    }

    public String getDefaultImplementationBeanName() {
        return this.defaultImplementationBeanName;
    }

    public void setDefaultImplementationBeanName(String defaultImplementationBeanName) {
        this.defaultImplementationBeanName = defaultImplementationBeanName;
    }

    public Class getDefaultImplementationClass() {
        return this.defaultImplementationClass;
    }

    public void setDefaultImplementationClass(Class defaultImplementationClass) {
        this.defaultImplementationClass = defaultImplementationClass;
    }
}

