/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class InstagramImpl
extends AbstractProvider {
    private static final long serialVersionUID = 6073346132625871229L;
    public static final String CLASSID = "instagram";
    private static final String PROFILE_URL = "https://api.instagram.com/v1/users/self";
    private static final String CONTACTS_URL = "https://api.instagram.com/v1/users/self/follows";
    private static final String VIEW_PROFILE_URL = "http://instagram.com/";
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(InstagramImpl.class);
    private OAuthConfig config;
    private AccessGrant accessGrant;
    private Profile userProfile;
    private OAuthStrategyBase authenticationStrategy;
    private static final String[] AllPerms;
    private static final String[] AuthPerms;

    public InstagramImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        if (this.config.getCustomPermissions() != null) {
            this.authenticationStrategy.setPermission(Permission.CUSTOM);
            this.authenticationStrategy.setScope(this.getScope(Permission.CUSTOM));
        }
        this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
    }

    private String getScope(Permission scope) {
        StringBuffer result = new StringBuffer();
        String[] arr = Permission.AUTHENTICATE_ONLY.equals(scope) ? AuthPerms : (Permission.CUSTOM.equals(scope) && this.config.getCustomPermissions() != null ? this.config.getCustomPermissions().split(",") : AllPerms);
        result.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            result.append(",").append(arr[i]);
        }
        String pluginScopes = this.getPluginsScope(this.config);
        if (pluginScopes != null) {
            result.append(",").append(pluginScopes);
        }
        return result.toString();
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.debug((Object)("Calling URL : " + url));
        try {
            return this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error : " + e.getMessage() + "- while making request to URL : " + url, e);
        }
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        Response serviceResponse;
        this.LOG.info((Object)"Fetching contacts from https://api.instagram.com/v1/users/self/follows");
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(CONTACTS_URL);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error : " + e.getMessage() + " - while getting contacts from " + CONTACTS_URL, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Error while getting contacts from https://api.instagram.com/v1/users/self/followsStatus : " + serviceResponse.getStatus());
        }
        String respStr = serviceResponse.getResponseBodyAsString("UTF-8");
        this.LOG.debug((Object)("Contacts JSON string :: " + respStr));
        ArrayList<Contact> plist = new ArrayList<Contact>();
        JSONObject resp = new JSONObject(respStr);
        JSONArray data = resp.optJSONArray("data");
        if (data != null) {
            for (int i = 0; i < data.length(); ++i) {
                JSONObject obj = data.getJSONObject(i);
                Contact p = new Contact();
                String id = obj.optString("id", null);
                p.setId(id);
                String full_name = obj.optString("full_name", null);
                p.setDisplayName(full_name);
                if (full_name != null) {
                    String[] names = full_name.split(" ");
                    if (names.length > 1) {
                        p.setFirstName(names[0]);
                        p.setLastName(names[1]);
                    } else {
                        p.setFirstName(full_name);
                    }
                }
                String username = obj.optString("username", null);
                p.setProfileUrl(VIEW_PROFILE_URL + username);
                p.setProfileImageURL(obj.optString("profile_picture"));
                if (this.config.isSaveRawResponse()) {
                    p.setRawResponse(obj.toString());
                }
                plist.add(p);
            }
        }
        return plist;
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessGrant != null) {
            this.userProfile = this.getProfile();
        }
        return this.userProfile;
    }

    private Profile getProfile() throws Exception {
        Response response;
        this.LOG.debug((Object)"Obtaining user profile");
        try {
            response = this.authenticationStrategy.executeFeed(PROFILE_URL);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from https://api.instagram.com/v1/users/self", e);
        }
        if (response.getStatus() == 200) {
            String respStr = response.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("Profile JSON string :: " + respStr));
            JSONObject obj = new JSONObject(respStr);
            JSONObject data = obj.getJSONObject("data");
            Profile p = new Profile();
            p.setValidatedId(data.optString("id", null));
            String full_name = data.optString("full_name", null);
            p.setDisplayName(full_name);
            if (full_name != null) {
                String[] names = full_name.split(" ");
                if (names.length > 1) {
                    p.setFirstName(names[0]);
                    p.setLastName(names[1]);
                } else {
                    p.setFirstName(full_name);
                }
            }
            p.setProfileImageURL(data.optString("profile_picture", null));
            p.setProviderId(this.getProviderId());
            if (this.config.isSaveRawResponse()) {
                p.setRawResponse(respStr);
            }
            return p;
        }
        throw new SocialAuthException("Failed to retrieve the user profile from https://api.instagram.com/v1/users/self. Server response " + response.getStatus());
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested: " + p.toString()));
        this.authenticationStrategy.setPermission(p);
        this.authenticationStrategy.setScope(this.getScope(p));
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Instagram");
        throw new SocialAuthException("Update Status is not implemented for Instagram");
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Instagram");
        throw new SocialAuthException("Upload Image is not implemented for Instagram");
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (requestParams.get("error") != null && "access_denied".equals(requestParams.get("error"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams, MethodType.POST.toString());
        if (this.accessGrant != null) {
            this.LOG.debug((Object)"Obtaining user profile");
            this.getProfile();
            return this.userProfile;
        }
        throw new SocialAuthException("Access token not found");
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.brickred.socialauth.plugin.instagram.FeedPluginImpl");
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    static {
        AllPerms = new String[]{"basic", "comments", "relationships", "likes"};
        AuthPerms = new String[]{"basic"};
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("authorizationURL", "https://api.instagram.com/oauth/authorize");
        ENDPOINTS.put("accessTokenURL", "https://api.instagram.com/oauth/access_token");
    }
}

