/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;

public class GenericOAuth2Provider
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Log LOG = LogFactory.getLog(GenericOAuth2Provider.class);
    private Permission scope;
    private OAuthConfig config;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;
    private final Map<String, String> ENDPOINTS;

    public GenericOAuth2Provider(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        this.ENDPOINTS = new HashMap<String, String>();
        this.ENDPOINTS.put("authorizationURL", providerConfig.getAuthenticationUrl());
        this.ENDPOINTS.put("accessTokenURL", providerConfig.getAccessTokenUrl());
        this.authenticationStrategy = new OAuth2(this.config, this.ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("error_reason") != null && "user_denied".equals(requestParams.get("error_reason"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams);
        if (this.accessGrant != null) {
            this.LOG.debug((Object)"Access grant available");
            return null;
        }
        throw new SocialAuthException("Access token not found");
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GenericOauth2Provider");
        throw new SocialAuthException("Update Status is not implemented for GenericOauth2Provider");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GenericOauth2Provider");
        throw new SocialAuthException("Get Contacts is not implemented for GenericOauth2Provider");
    }

    @Override
    public Profile getUserProfile() throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GenericOauth2Provider");
        throw new SocialAuthException("Get Profile is not implemented for GenericOauth2Provider");
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.info((Object)("Calling api function for url\t:\t" + url));
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GenericOauth2Provider");
        throw new SocialAuthException("Upload Image is not implemented for GenericOauth2Provider");
    }

    private String getScope() {
        if (Permission.CUSTOM.equals(this.scope) && this.config.getCustomPermissions() != null) {
            return this.config.getCustomPermissions();
        }
        return null;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }
}

