/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.twitter;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Feed;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.plugin.FeedPlugin;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class FeedPluginImpl
implements FeedPlugin,
Serializable {
    private static final long serialVersionUID = 5091122799864049766L;
    private static final String FEED_URL = "https://api.twitter.com/1.1/statuses/home_timeline.json";
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ProviderSupport providerSupport;

    public FeedPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Feed> getFeeds() throws Exception {
        Response response = null;
        ArrayList<Feed> list = new ArrayList<Feed>();
        this.LOG.info((Object)"Getting feeds from URL : https://api.twitter.com/1.1/statuses/home_timeline.json");
        try {
            response = this.providerSupport.api(FEED_URL);
            String respStr = response.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("Feeds json string :: " + respStr));
            JSONArray jarr = new JSONArray(respStr);
            this.LOG.debug((Object)("Feeds count :: " + jarr.length()));
            for (int i = 0; i < jarr.length(); ++i) {
                JSONObject jobj = jarr.getJSONObject(i);
                Feed feed = new Feed();
                String dateStr = jobj.optString("created_at", null);
                if (dateStr != null) {
                    feed.setCreatedAt(dateFormat.parse(dateStr));
                }
                feed.setMessage(jobj.optString("text", null));
                if (jobj.has("user")) {
                    JSONObject userObj = jobj.getJSONObject("user");
                    feed.setId(userObj.optString("id_str", null));
                    feed.setFrom(userObj.optString("name", null));
                    feed.setScreenName(userObj.optString("screen_name", null));
                }
                list.add(feed);
            }
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting feeds from https://api.twitter.com/1.1/statuses/home_timeline.json", e);
        }
        return list;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

