/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.linkedin;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Career;
import org.brickred.socialauth.Education;
import org.brickred.socialauth.Position;
import org.brickred.socialauth.Recommendation;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.plugin.CareerPlugin;
import org.brickred.socialauth.util.DateComponents;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CareerPluginImpl
implements CareerPlugin,
Serializable {
    private static final long serialVersionUID = -1733773634998485298L;
    private ProviderSupport providerSupport;
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final String PROFILE_URL = "http://api.linkedin.com/v1/people/~:(id,phone-numbers,headline,educations,positions,recommendations-received)";

    public CareerPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public Career getCareerDetails() throws Exception {
        Element root;
        this.LOG.info((Object)"Fetching career details from http://api.linkedin.com/v1/people/~:(id,phone-numbers,headline,educations,positions,recommendations-received)");
        Response serviceResponse = null;
        try {
            serviceResponse = this.providerSupport.api(PROFILE_URL);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the career details from http://api.linkedin.com/v1/people/~:(id,phone-numbers,headline,educations,positions,recommendations-received)", ie);
        }
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the career details from response.http://api.linkedin.com/v1/people/~:(id,phone-numbers,headline,educations,positions,recommendations-received)", e);
        }
        Career career = null;
        if (root != null) {
            NodeList recommendations;
            NodeList positions;
            DateComponents comp;
            String year;
            career = new Career();
            Education[] educationsArr = null;
            Position[] positionsArr = null;
            Recommendation[] recommendationsArr = null;
            String headline = XMLParseUtil.getElementData(root, "headline");
            career.setHeadline(headline);
            String id = XMLParseUtil.getElementData(root, "id");
            career.setId(id);
            NodeList educations = root.getElementsByTagName("education");
            if (educations != null && educations.getLength() > 0) {
                this.LOG.debug((Object)("Educations count " + educations.getLength()));
                educationsArr = new Education[educations.getLength()];
                for (int i = 0; i < educations.getLength(); ++i) {
                    NodeList ed;
                    String year2;
                    NodeList sd;
                    String fieldOfStudy;
                    String degree;
                    Education educationObj = new Education();
                    Element educationEl = (Element)educations.item(i);
                    String schoolName = XMLParseUtil.getElementData(educationEl, "school-name");
                    if (schoolName != null) {
                        educationObj.setSchoolName(schoolName);
                    }
                    if ((degree = XMLParseUtil.getElementData(educationEl, "degree")) != null) {
                        educationObj.setDegree(degree);
                    }
                    if ((fieldOfStudy = XMLParseUtil.getElementData(educationEl, "field-of-study")) != null) {
                        educationObj.setFieldOfStudy(fieldOfStudy);
                    }
                    if ((sd = educationEl.getElementsByTagName("start-date")) != null && sd.getLength() > 0 && (year2 = XMLParseUtil.getElementData((Element)sd.item(0), "year")) != null) {
                        DateComponents comp2 = new DateComponents();
                        comp2.setYear(Integer.parseInt(year2));
                        educationObj.setStartDate(comp2);
                    }
                    if ((ed = educationEl.getElementsByTagName("end-date")) != null && ed.getLength() > 0 && (year = XMLParseUtil.getElementData((Element)ed.item(0), "year")) != null) {
                        comp = new DateComponents();
                        comp.setYear(Integer.parseInt(year));
                        educationObj.setEndDate(comp);
                    }
                    educationsArr[i] = educationObj;
                }
            }
            if ((positions = root.getElementsByTagName("position")) != null && positions.getLength() > 0) {
                this.LOG.debug((Object)("Positions count " + positions.getLength()));
                positionsArr = new Position[positions.getLength()];
                for (int i = 0; i < positions.getLength(); ++i) {
                    NodeList companyNodes;
                    String year3;
                    NodeList ed;
                    NodeList sd;
                    String isCurrent;
                    String title;
                    Position positionnObj = new Position();
                    Element positionEl = (Element)positions.item(i);
                    String pid = XMLParseUtil.getElementData(positionEl, "id");
                    if (pid != null) {
                        positionnObj.setPositionId(pid);
                    }
                    if ((title = XMLParseUtil.getElementData(positionEl, "title")) != null) {
                        positionnObj.setTitle(title);
                    }
                    if ((isCurrent = XMLParseUtil.getElementData(positionEl, "is-current")) != null) {
                        positionnObj.setCurrentCompany(Boolean.valueOf(isCurrent));
                    }
                    if ((sd = positionEl.getElementsByTagName("start-date")) != null && sd.getLength() > 0 && (year = XMLParseUtil.getElementData((Element)sd.item(0), "year")) != null) {
                        comp = new DateComponents();
                        comp.setYear(Integer.parseInt(year));
                        positionnObj.setStartDate(comp);
                    }
                    if ((ed = positionEl.getElementsByTagName("end-date")) != null && ed.getLength() > 0 && (year3 = XMLParseUtil.getElementData((Element)ed.item(0), "year")) != null) {
                        DateComponents comp3 = new DateComponents();
                        comp3.setYear(Integer.parseInt(year3));
                        positionnObj.setEndDate(comp3);
                    }
                    if ((companyNodes = positionEl.getElementsByTagName("company")) != null && companyNodes.getLength() > 0) {
                        String type;
                        String industry;
                        String compName;
                        Element company = (Element)companyNodes.item(0);
                        String compid = XMLParseUtil.getElementData(company, "id");
                        if (compid != null) {
                            positionnObj.setCompanyId(compid);
                        }
                        if ((compName = XMLParseUtil.getElementData(company, "name")) != null) {
                            positionnObj.setCompanyName(compName);
                        }
                        if ((industry = XMLParseUtil.getElementData(company, "industry")) != null) {
                            positionnObj.setIndustry(industry);
                        }
                        if ((type = XMLParseUtil.getElementData(company, "type")) != null) {
                            positionnObj.setCompanyType(type);
                        }
                    }
                    positionsArr[i] = positionnObj;
                }
            }
            if ((recommendations = root.getElementsByTagName("recommendation")) != null && recommendations.getLength() > 0) {
                this.LOG.debug((Object)("Recommendations count " + recommendations.getLength()));
                recommendationsArr = new Recommendation[recommendations.getLength()];
                for (int i = 0; i < recommendations.getLength(); ++i) {
                    NodeList recommenderNodes;
                    String code;
                    String text;
                    Recommendation recommendationObj = new Recommendation();
                    Element recommendationEl = (Element)recommendations.item(i);
                    String rid = XMLParseUtil.getElementData(recommendationEl, "id");
                    if (rid != null) {
                        recommendationObj.setRecommendationId(rid);
                    }
                    if ((text = XMLParseUtil.getElementData(recommendationEl, "recommendation-text")) != null) {
                        recommendationObj.setRecommendationText(text);
                    }
                    if ((code = XMLParseUtil.getElementData(recommendationEl, "code")) != null) {
                        recommendationObj.setRecommendationType(code);
                    }
                    if ((recommenderNodes = recommendationEl.getElementsByTagName("recommender")) != null && recommenderNodes.getLength() > 0) {
                        String lname;
                        String fname;
                        Element recommenderEl = (Element)recommenderNodes.item(0);
                        String recommenderId = XMLParseUtil.getElementData(recommenderEl, "id");
                        if (recommenderId != null) {
                            recommendationObj.setRecommenderId(recommenderId);
                        }
                        if ((fname = XMLParseUtil.getElementData(recommenderEl, "first-name")) != null) {
                            recommendationObj.setRecommenderFirstName(fname);
                        }
                        if ((lname = XMLParseUtil.getElementData(recommenderEl, "last-name")) != null) {
                            recommendationObj.setRecommenderLastName(lname);
                        }
                    }
                    recommendationsArr[i] = recommendationObj;
                }
            }
            if (educationsArr != null) {
                career.setEducations(educationsArr);
            }
            if (positionsArr != null) {
                career.setPositions(positionsArr);
            }
            if (recommendationsArr != null) {
                career.setRecommendations(recommendationsArr);
            }
        }
        return career;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

