/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.collections.ListBuffer;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ArrayType;
import com.strobel.reflection.Binder;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.BottomType;
import com.strobel.reflection.CallingConvention;
import com.strobel.reflection.CompoundType;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.ConstructorList;
import com.strobel.reflection.DefaultBinder;
import com.strobel.reflection.ErasedType;
import com.strobel.reflection.Error;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.Helper;
import com.strobel.reflection.ICapturedType;
import com.strobel.reflection.MemberFilter;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberList;
import com.strobel.reflection.MemberListType;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.Missing;
import com.strobel.reflection.NullType;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.PrimitiveType;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Resolver;
import com.strobel.reflection.RuntimeConstructorInfo;
import com.strobel.reflection.RuntimeFieldInfo;
import com.strobel.reflection.RuntimeMethodInfo;
import com.strobel.reflection.RuntimeType;
import com.strobel.reflection.RuntimeTypeCache;
import com.strobel.reflection.TypeBinder;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeCache;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeParser;
import com.strobel.reflection.TypeVisitor;
import com.strobel.reflection.Types;
import com.strobel.reflection.WildcardType;
import com.strobel.reflection.emit.TypeBuilder;
import com.strobel.util.ContractUtils;
import com.strobel.util.EmptyArrayCache;
import com.strobel.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeKind;

public abstract class Type<T>
extends MemberInfo
implements java.lang.reflect.Type {
    public static final Binder DefaultBinder = new DefaultBinder();
    public static final char Delimiter = '.';
    public static final Missing Value = new Missing();
    public static final Type<?>[] EmptyTypes = new Type[0];
    public static final Type Bottom = new BottomType();
    public static final Type NullType = new NullType();
    protected static final Object[] EmptyObjects = EmptyArrayCache.fromElementType(Object.class);
    protected static final String[] EmptyStrings = (String[])EmptyArrayCache.fromElementType(String.class);
    protected static final MethodInfo[] EmptyMethods = (MethodInfo[])EmptyArrayCache.fromElementType(MethodInfo.class);
    protected static final ConstructorInfo[] EmptyConstructors = (ConstructorInfo[])EmptyArrayCache.fromElementType(ConstructorInfo.class);
    protected static final FieldInfo[] EmptyFields = (FieldInfo[])EmptyArrayCache.fromElementType(FieldInfo.class);
    protected static final MemberInfo[] EmptyMembers = (MemberInfo[])EmptyArrayCache.fromElementType(MemberInfo.class);
    protected static final Set<BindingFlags> DefaultLookup = BindingFlags.PublicAll;
    protected static final WildcardType<Object> UnboundedWildcard;
    private TypeList _interfaces;
    private ErasedType<T> _erasedType;
    static final Object CACHE_LOCK;
    static final TypeCache CACHE;
    static final Resolver RESOLVER;
    static final Type<?>[] PRIMITIVE_TYPES;
    static final TypeBinder TYPE_BINDER;
    private RuntimeTypeCache<T> _cache;
    public static final MemberFilter FilterNameIgnoreCase;
    public static final MemberFilter FilterName;
    public static final MemberFilter FilterRawMember;
    public static final MemberFilter FilterMethodOverride;

    protected Type() {
    }

    @Override
    public MemberType getMemberType() {
        if (this.getDeclaringType() == null) {
            return MemberType.TypeInfo;
        }
        return MemberType.NestedType;
    }

    public boolean isNested() {
        return this.getDeclaringType() != null || this.getDeclaringMethod() != null;
    }

    public boolean isLocalClass() {
        return this.getDeclaringMethod() != null;
    }

    public boolean isVisible() {
        throw ContractUtils.unreachable();
    }

    public final boolean isClass() {
        return (this.getModifiers() & 0x4200) == 0;
    }

    public final boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public final boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isArray() {
        return false;
    }

    public boolean isGenericType() {
        return !this.getTypeBindings().isEmpty();
    }

    public boolean isGenericTypeDefinition() {
        if (!this.isGenericType()) {
            return false;
        }
        TypeBindings typeArguments = this.getTypeBindings();
        return !typeArguments.isEmpty() && !typeArguments.hasBoundParameters();
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isGenericParameter() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean hasElementType() {
        return false;
    }

    public TypeKind getKind() {
        return TypeKind.DECLARED;
    }

    public Type<? super T> getBaseType() {
        return Type.of(Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeList getInterfaces() {
        if (this._interfaces == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._interfaces == null) {
                    ArrayList<Type<?>> interfaces = this.getCache().getInterfaceList(MemberListType.All, null);
                    this._interfaces = interfaces.isEmpty() ? TypeList.empty() : Type.list(interfaces);
                }
            }
        }
        return this._interfaces;
    }

    public TypeList getExplicitInterfaces() {
        return TypeList.empty();
    }

    public Class<T> getErasedClass() {
        return this.getCache().getErasedClass();
    }

    public T newInstance(Object ... arguments) {
        if (Helper.isReifiable(this)) {
            try {
                Type[] argumentTypes = ArrayUtilities.isNullOrEmpty((Object[])arguments) ? (Type[])EmptyArrayCache.fromElementType(Type.class) : new Type[arguments.length];
                int n = arguments.length;
                for (int i = 0; i < n; ++i) {
                    Object argument = arguments[i];
                    argumentTypes[i] = argument != null ? Type.getType(argument) : NullType;
                }
                ConstructorInfo constructor = this.getConstructor(argumentTypes);
                if (constructor != null) {
                    return (T)constructor.invoke(arguments);
                }
                throw Error.couldNotResolveMatchingConstructor();
            }
            catch (Throwable t) {
                throw Error.typeInstantiationFailed(this, t);
            }
        }
        throw Error.typeCannotBeInstantiated(this);
    }

    public MethodBase getDeclaringMethod() {
        return null;
    }

    @NotNull
    public final Type<?> getUnderlyingType() {
        Type t = this;
        Type u = t.getUnderlyingTypeCore();
        while (u != t) {
            t = u;
            u = t.getUnderlyingTypeCore();
        }
        return u;
    }

    @NotNull
    protected Type getUnderlyingTypeCore() {
        if (this.hasElementType()) {
            return this.getElementType();
        }
        if (this.isGenericType()) {
            return this.getGenericTypeDefinition();
        }
        if (this.hasExtendsBound()) {
            return this.getExtendsBound();
        }
        return this;
    }

    public Type<?> getElementType() {
        throw Error.noElementType(this);
    }

    public int getGenericParameterPosition() {
        throw Error.notGenericParameter(this);
    }

    protected TypeBindings getTypeBindings() {
        return TypeBindings.empty();
    }

    public TypeList getTypeArguments() {
        if (this.isGenericType()) {
            return this.getTypeBindings().getBoundTypes();
        }
        return TypeList.empty();
    }

    public TypeList getGenericTypeParameters() {
        if (this.isGenericType()) {
            return this.getTypeBindings().getGenericParameters();
        }
        throw Error.notGenericType(this);
    }

    public Type getGenericTypeDefinition() {
        if (this.isGenericType()) {
            throw ContractUtils.unreachable();
        }
        throw Error.notGenericType(this);
    }

    public boolean containsGenericParameters() {
        if (this.hasElementType()) {
            return this.getRootElementType().containsGenericParameters();
        }
        if (this.isGenericParameter()) {
            return true;
        }
        if (!this.isGenericType()) {
            return false;
        }
        TypeBindings typeArguments = this.getTypeBindings();
        int n = typeArguments.size();
        for (int i = 0; i < n; ++i) {
            if (!typeArguments.getBoundType(i).containsGenericParameters()) continue;
            return true;
        }
        return false;
    }

    public boolean containsGenericParameter(Type<?> genericParameter) {
        if (!((Type)VerifyArgument.notNull(genericParameter, (String)"genericParameter")).isGenericParameter()) {
            throw Error.notGenericParameter(genericParameter);
        }
        if (this.hasElementType()) {
            return this.getRootElementType().containsGenericParameter(genericParameter);
        }
        if (this.isGenericParameter()) {
            return this.isEquivalentTo(genericParameter);
        }
        if (this.isGenericTypeDefinition()) {
            TypeBindings typeArguments = this.getTypeBindings();
            int n = typeArguments.size();
            for (int i = 0; i < n; ++i) {
                if (!typeArguments.getBoundType(i).containsGenericParameter(genericParameter)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBoundedType() {
        return this.isGenericParameter() || this.isWildcardType() || this instanceof ICapturedType;
    }

    public boolean isUnbounded() {
        return this.isWildcardType() && this.getSuperBound() == Bottom && Types.Object.equals(this.getExtendsBound());
    }

    public boolean hasExtendsBound() {
        return this.isGenericParameter() || this.isWildcardType() && this.getSuperBound() == Bottom;
    }

    public boolean hasSuperBound() {
        return this.isWildcardType() && this.getSuperBound() != Bottom;
    }

    public Type<?> getExtendsBound() {
        throw Error.notBoundedType(this);
    }

    public Type<?> getSuperBound() {
        throw Error.notWildcard(this);
    }

    @Override
    public final boolean isEquivalentTo(MemberInfo m) {
        return m instanceof Type && this.isEquivalentTo((Type)m);
    }

    public boolean isEquivalentTo(Type<?> other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof TypeBuilder) {
            TypeBuilder typeBuilder = (TypeBuilder)other;
            return typeBuilder.isCreated() && this.isEquivalentTo(typeBuilder.createType());
        }
        if (other instanceof RuntimeType) {
            return other.isEquivalentTo(this);
        }
        boolean isArray = this.isArray();
        if (isArray != other.isArray()) {
            return false;
        }
        if (isArray) {
            return this.getElementType().isEquivalentTo(other.getElementType());
        }
        boolean isWildcard = this.isWildcardType();
        if (isWildcard != other.isWildcardType()) {
            return false;
        }
        if (isWildcard) {
            return TypeUtils.areEquivalent(this.getExtendsBound(), other.getExtendsBound()) && TypeUtils.areEquivalent(this.getSuperBound(), other.getSuperBound());
        }
        boolean isCompound = this.isCompoundType();
        if (isCompound != other.isCompoundType()) {
            return false;
        }
        if (isCompound) {
            return TypeUtils.areEquivalent(this.getBaseType(), other.getBaseType()) && TypeUtils.areEquivalentWithOrdering(this.getExplicitInterfaces(), other.getExplicitInterfaces());
        }
        boolean isGenericParameter = this.isGenericParameter();
        if (isGenericParameter != other.isGenericParameter()) {
            return false;
        }
        if (isGenericParameter) {
            if (!this.getExtendsBound().isEquivalentTo(other.getExtendsBound())) {
                return false;
            }
            Type declaringType = this.getDeclaringType();
            Type otherDeclaringType = other.getDeclaringType();
            if (declaringType != null ? !declaringType.isEquivalentTo(otherDeclaringType) : otherDeclaringType != null) {
                return false;
            }
            MethodInfo declaringMethod = (MethodInfo)this.getDeclaringMethod();
            MethodInfo otherDeclaringMethod = (MethodInfo)other.getDeclaringMethod();
            boolean hasDeclaringMethod = declaringMethod != null;
            boolean otherHasDeclaringMethod = otherDeclaringMethod != null;
            return hasDeclaringMethod == otherHasDeclaringMethod && (declaringMethod == null || declaringMethod.getDeclaringType().isEquivalentTo(otherDeclaringMethod.getDeclaringType()) && declaringMethod.getRawMethod() == otherDeclaringMethod.getRawMethod());
        }
        if (Comparer.equals(this.getErasedClass(), other.getErasedClass())) {
            if (this.isGenericType()) {
                return other.isGenericType() && other.getTypeArguments().isEquivalentTo(this.getTypeArguments());
            }
            return !other.isGenericType();
        }
        return false;
    }

    public boolean isSubTypeOf(Type type) {
        return type == this || type != null && Helper.isSubtype(this, type);
    }

    public boolean isInstance(Object o) {
        return o != null && this.getErasedClass().isInstance(o);
    }

    public boolean implementsInterface(Type interfaceType) {
        for (Type<T> t = this; t != null && t != NullType; t = t.getBaseType()) {
            TypeList interfaces = t.getExplicitInterfaces();
            int n = interfaces.size();
            for (int i = 0; i < n; ++i) {
                Type type = (Type)interfaces.get(i);
                if (!type.isEquivalentTo(interfaceType) && !type.implementsInterface(interfaceType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAssignableFrom(Type type) {
        return Helper.isAssignable(type, this);
    }

    public Package getPackage() {
        return this.getCache().getPackage();
    }

    public boolean isCompoundType() {
        return false;
    }

    public boolean isWildcardType() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public <P, R> R accept(TypeVisitor<P, R> visitor, P parameter) {
        return visitor.visitType(this, parameter);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getErasedClass().getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this.getErasedClass().getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this.getErasedClass().getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getErasedClass().isAnnotationPresent(annotationClass);
    }

    public final MemberList getMember(String name) {
        return this.getMember(name, DefaultLookup, EnumSet.allOf(MemberType.class));
    }

    public final MemberList getMember(String name, MemberType memberType, MemberType ... memberTypes) {
        return this.getMember(name, DefaultLookup, EnumSet.of(memberType, memberTypes));
    }

    public MemberList getMember(String name, Set<BindingFlags> bindingFlags, Set<MemberType> memberTypes) {
        VerifyArgument.notNull((Object)name, (String)"name");
        if (memberTypes == null || memberTypes.isEmpty()) {
            return MemberList.empty();
        }
        MethodInfo[] methods = EmptyMethods;
        ConstructorInfo[] constructors = EmptyConstructors;
        FieldInfo[] fields = EmptyFields;
        Type[] nestedTypes = EmptyTypes;
        if (memberTypes.contains((Object)MemberType.Field)) {
            fields = this.getFieldCandidates(name, bindingFlags, true);
        }
        if (memberTypes.contains((Object)MemberType.Method)) {
            methods = (MethodInfo[])this.getMethodBaseCandidates(MemberType.Method, name, bindingFlags, CallingConvention.Any, null, true);
        }
        if (memberTypes.contains((Object)MemberType.Constructor)) {
            constructors = (ConstructorInfo[])this.getMethodBaseCandidates(MemberType.Constructor, name, bindingFlags, CallingConvention.Any, null, true);
        }
        if (memberTypes.contains((Object)MemberType.NestedType)) {
            nestedTypes = this.getNestedTypeCandidates(name, bindingFlags, true);
        }
        if (memberTypes.size() == 1) {
            MemberType memberType = memberTypes.iterator().next();
            switch (memberType) {
                case Constructor: {
                    if (constructors.length == 0) {
                        return ConstructorList.empty();
                    }
                    return new ConstructorList(constructors);
                }
                case Field: {
                    if (fields.length == 0) {
                        return FieldList.empty();
                    }
                    return new FieldList(fields);
                }
                case Method: {
                    if (methods.length == 0) {
                        return MethodList.empty();
                    }
                    return new MethodList(methods);
                }
                case NestedType: {
                    if (nestedTypes.length == 0) {
                        return TypeList.empty();
                    }
                    return new TypeList(nestedTypes);
                }
            }
        }
        ArrayList results = new ArrayList(fields.length + methods.length + constructors.length + nestedTypes.length);
        Collections.addAll(results, fields);
        Collections.addAll(results, methods);
        Collections.addAll(results, constructors);
        Collections.addAll(results, nestedTypes);
        MemberInfo[] array = new MemberInfo[results.size()];
        results.toArray(array);
        return new MemberList(MemberInfo.class, array);
    }

    public final FieldInfo getField(String name) {
        return this.getField(name, DefaultLookup);
    }

    public FieldInfo getField(String name, Set<BindingFlags> bindingFlags) {
        FieldInfo[] candidates = this.getFieldCandidates(name, bindingFlags, false);
        if (candidates.length == 0) {
            return null;
        }
        MemberInfo match = null;
        boolean multipleStaticFieldMatches = false;
        for (FieldInfo candidate : candidates) {
            Type candidateDeclaringType = candidate.getDeclaringType();
            if (match != null) {
                Type matchDeclaringType = match.getDeclaringType();
                if (candidateDeclaringType == matchDeclaringType) {
                    throw Error.ambiguousMatch();
                }
                if (matchDeclaringType.isInterface() && candidateDeclaringType.isInterface()) {
                    multipleStaticFieldMatches = true;
                }
            }
            if (match != null && !candidateDeclaringType.isSubTypeOf(match.getDeclaringType()) && !match.getDeclaringType().isInterface()) continue;
            match = candidate;
        }
        if (multipleStaticFieldMatches && match.getDeclaringType().isInterface()) {
            throw Error.ambiguousMatch();
        }
        return match;
    }

    public final MethodInfo getMethod(String name, Type ... parameterTypes) {
        return this.getMethod(name, DefaultLookup, parameterTypes);
    }

    public final MethodInfo getMethod(String name, Set<BindingFlags> bindingFlags, Type ... parameterTypes) {
        return this.getMethod(name, bindingFlags, CallingConvention.Any, parameterTypes);
    }

    public MethodInfo getMethod(String name, Set<BindingFlags> bindingFlags, CallingConvention callingConvention, Type ... parameterTypes) {
        MethodBase[] candidates = (MethodInfo[])this.getMethodBaseCandidates(MemberType.Method, name, bindingFlags, callingConvention, parameterTypes, false);
        if (candidates.length == 0) {
            return null;
        }
        if (parameterTypes == null || parameterTypes.length == 0) {
            if (candidates.length == 1) {
                return candidates[0];
            }
            if (parameterTypes == null) {
                int n = candidates.length;
                for (int i = 0; i < n; ++i) {
                    MethodBase method = candidates[i];
                    if (Binder.compareMethodSignatureAndName(method, candidates[0])) continue;
                    throw Error.ambiguousMatch();
                }
                return (MethodInfo)Binder.findMostDerivedNewSlotMethod(candidates, candidates.length);
            }
        }
        return (MethodInfo)DefaultBinder.selectMethod(bindingFlags, candidates, parameterTypes);
    }

    public final ConstructorInfo getConstructor(Type ... parameterTypes) {
        return this.getConstructor(DefaultLookup, parameterTypes);
    }

    public final ConstructorInfo getConstructor(Set<BindingFlags> bindingFlags, Type ... parameterTypes) {
        return this.getConstructor(bindingFlags, CallingConvention.Any, parameterTypes);
    }

    public ConstructorInfo getConstructor(Set<BindingFlags> bindingFlags, CallingConvention callingConvention, Type ... parameterTypes) {
        MethodBase[] candidates = (ConstructorInfo[])this.getMethodBaseCandidates(MemberType.Constructor, null, bindingFlags, callingConvention, parameterTypes, false);
        if (candidates.length == 0) {
            return null;
        }
        if (parameterTypes == null || parameterTypes.length == 0) {
            if (candidates.length == 1) {
                return candidates[0];
            }
            if (parameterTypes == null) {
                int n = candidates.length;
                for (int i = 0; i < n; ++i) {
                    MethodBase constructor = candidates[i];
                    if (Binder.compareMethodSignatureAndName(constructor, candidates[0])) continue;
                    throw Error.ambiguousMatch();
                }
                return (ConstructorInfo)Binder.findMostDerivedNewSlotMethod(candidates, candidates.length);
            }
        }
        return (ConstructorInfo)DefaultBinder.selectMethod(bindingFlags, candidates, parameterTypes);
    }

    public final MemberList getMembers() {
        return this.getMembers(DefaultLookup, EnumSet.allOf(MemberType.class));
    }

    public final MemberList getMembersOfType(Set<MemberType> memberTypes) {
        return this.getMembers(DefaultLookup, memberTypes);
    }

    public final MemberList getMembers(MemberType memberType, MemberType ... memberTypes) {
        return this.getMembers(DefaultLookup, EnumSet.of(memberType, memberTypes));
    }

    public final MemberList getMembers(Set<BindingFlags> bindingFlags) {
        return this.getMembers(bindingFlags, EnumSet.allOf(MemberType.class));
    }

    public final MemberList getMembers(Set<BindingFlags> bindingFlags, MemberType memberType, MemberType ... memberTypes) {
        return this.getMembers(bindingFlags, EnumSet.of(memberType, memberTypes));
    }

    public MemberList getMembers(Set<BindingFlags> bindingFlags, Set<MemberType> memberTypes) {
        MethodInfo[] methods = EmptyMethods;
        ConstructorInfo[] constructors = EmptyConstructors;
        FieldInfo[] fields = EmptyFields;
        Type[] nestedTypes = EmptyTypes;
        if (memberTypes.contains((Object)MemberType.Field)) {
            fields = this.getFieldCandidates(null, bindingFlags, false);
        }
        if (memberTypes.contains((Object)MemberType.Method)) {
            methods = (MethodInfo[])this.getMethodBaseCandidates(MemberType.Method, null, bindingFlags, CallingConvention.Any, null, false);
        }
        if (memberTypes.contains((Object)MemberType.Constructor)) {
            constructors = (ConstructorInfo[])this.getMethodBaseCandidates(MemberType.Constructor, null, bindingFlags, CallingConvention.Any, null, false);
        }
        if (memberTypes.contains((Object)MemberType.NestedType)) {
            nestedTypes = this.getNestedTypeCandidates(null, bindingFlags, false);
        }
        if (memberTypes.size() == 1) {
            MemberType memberType = memberTypes.iterator().next();
            switch (memberType) {
                case Constructor: {
                    if (constructors.length == 0) {
                        return ConstructorList.empty();
                    }
                    return new ConstructorList(constructors);
                }
                case Field: {
                    if (fields.length == 0) {
                        return FieldList.empty();
                    }
                    return new FieldList(fields);
                }
                case Method: {
                    if (methods.length == 0) {
                        return MethodList.empty();
                    }
                    return new MethodList(methods);
                }
                case NestedType: {
                    if (nestedTypes.length == 0) {
                        return TypeList.empty();
                    }
                    return new TypeList(nestedTypes);
                }
            }
        }
        ArrayList results = new ArrayList(fields.length + methods.length + constructors.length + nestedTypes.length);
        Collections.addAll(results, fields);
        Collections.addAll(results, methods);
        Collections.addAll(results, constructors);
        Collections.addAll(results, nestedTypes);
        MemberInfo[] array = new MemberInfo[results.size()];
        results.toArray(array);
        return new MemberList(MemberInfo.class, array);
    }

    public MemberList<? extends MemberInfo> findMembers(Set<MemberType> memberTypes, Set<BindingFlags> bindingAttr, MemberFilter filter, Object filterCriteria) {
        int i;
        int n;
        ArrayList<MemberInfo> matches = new ArrayList<MemberInfo>();
        if ((MemberType.mask(memberTypes) & MemberType.Method.mask) != 0) {
            MethodList m = this.getMethods(bindingAttr);
            n = m.size();
            for (i = 0; i < n; ++i) {
                MethodInfo method = (MethodInfo)m.get(i);
                if (filter != null && !filter.apply(method, filterCriteria)) continue;
                matches.add(method);
            }
        }
        if ((MemberType.mask(memberTypes) & MemberType.Constructor.mask) != 0) {
            ConstructorList c = this.getConstructors(bindingAttr);
            n = c.size();
            for (i = 0; i < n; ++i) {
                ConstructorInfo constructor = (ConstructorInfo)c.get(i);
                if (filter != null && !filter.apply(constructor, filterCriteria)) continue;
                matches.add(constructor);
            }
        }
        if ((MemberType.mask(memberTypes) & MemberType.Field.mask) != 0) {
            FieldList f = this.getFields(bindingAttr);
            n = f.size();
            for (i = 0; i < n; ++i) {
                FieldInfo field = (FieldInfo)f.get(i);
                if (filter != null && !filter.apply(field, filterCriteria)) continue;
                matches.add(field);
            }
        }
        if ((MemberType.mask(memberTypes) & MemberType.NestedType.mask) != 0) {
            TypeList t = this.getNestedTypes(bindingAttr);
            n = t.size();
            for (i = 0; i < n; ++i) {
                Type type = (Type)t.get(i);
                if (filter != null && !filter.apply(type, filterCriteria)) continue;
                matches.add(type);
            }
        }
        return new MemberList<MemberInfo>(MemberInfo.class, (List<MemberInfo>)matches);
    }

    public final FieldList getFields() {
        return this.getFields(DefaultLookup);
    }

    public FieldList getFields(Set<BindingFlags> bindingFlags) {
        FieldInfo[] candidates = this.getFieldCandidates(null, bindingFlags, false);
        if (candidates == null || candidates.length == 0) {
            return FieldList.empty();
        }
        return new FieldList(candidates);
    }

    public final MethodList getMethods() {
        return this.getMethods(DefaultLookup, CallingConvention.Any);
    }

    public final MethodList getMethods(Set<BindingFlags> bindingFlags) {
        return this.getMethods(bindingFlags, CallingConvention.Any);
    }

    public MethodList getMethods(Set<BindingFlags> bindingFlags, CallingConvention callingConvention) {
        MethodInfo[] candidates = (MethodInfo[])this.getMethodBaseCandidates(MemberType.Method, null, bindingFlags, callingConvention, null, false);
        if (candidates == null || candidates.length == 0) {
            return MethodList.empty();
        }
        return new MethodList(candidates);
    }

    public final ConstructorList getConstructors() {
        return this.getConstructors(DefaultLookup);
    }

    public ConstructorList getConstructors(Set<BindingFlags> bindingFlags) {
        ConstructorInfo[] candidates = (ConstructorInfo[])this.getMethodBaseCandidates(MemberType.Constructor, null, bindingFlags, CallingConvention.Any, null, false);
        if (candidates == null || candidates.length == 0) {
            return ConstructorList.empty();
        }
        return new ConstructorList(candidates);
    }

    public final TypeList getNestedTypes() {
        return this.getNestedTypes(DefaultLookup);
    }

    public TypeList getNestedTypes(Set<BindingFlags> bindingFlags) {
        Object[] candidates = this.getNestedTypeCandidates(null, bindingFlags, false);
        if (ArrayUtilities.isNullOrEmpty((Object[])candidates)) {
            return TypeList.empty();
        }
        return Type.list((Type[])candidates);
    }

    public final Type<?> getNestedType(String fullName) {
        return this.getNestedType(fullName, DefaultLookup);
    }

    public Type<?> getNestedType(String fullName, Set<BindingFlags> bindingFlags) {
        String name;
        VerifyArgument.notNull((Object)fullName, (String)"fullName");
        if (fullName != null) {
            boolean isLongName;
            String ownerName = this.getFullName();
            boolean bl = isLongName = bindingFlags.contains((Object)BindingFlags.IgnoreCase) ? StringUtilities.startsWithIgnoreCase((CharSequence)fullName, (String)ownerName) : fullName.startsWith(ownerName);
            if (isLongName) {
                if (fullName.length() == ownerName.length()) {
                    return null;
                }
                name = fullName.substring(ownerName.length() + 1);
            } else {
                name = fullName;
            }
        } else {
            name = null;
        }
        FilterOptions filterOptions = Type.getFilterOptions(name, bindingFlags, false);
        ArrayList<Type<?>> nestedTypes = this.getCache().getNestedTypeList(filterOptions.listOptions, name);
        EnumSet<BindingFlags> flags = EnumSet.copyOf(bindingFlags);
        if (!flags.remove((Object)BindingFlags.Static)) {
            flags.add(BindingFlags.Static);
        }
        Type<?> match = null;
        int n = nestedTypes.size();
        for (int i = 0; i < n; ++i) {
            Type<?> nestedType = nestedTypes.get(i);
            if (!this.filterApplyType(nestedType, flags, name, filterOptions.prefixLookup)) continue;
            if (match != null) {
                throw Error.ambiguousMatch();
            }
            match = nestedType;
        }
        return match;
    }

    public Object[] getEnumConstants() {
        throw Error.notEnumType(this);
    }

    public String[] getEnumNames() {
        throw Error.notEnumType(this);
    }

    @Override
    public int hashCode() {
        return Helper.hashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Type<T[]> makeArrayType() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            return CACHE.getArrayType(this);
        }
    }

    protected Type<T[]> createArrayType() {
        return new ArrayType<T[]>(this);
    }

    public final <U extends T> Type<U> makeGenericType(TypeList typeArguments) {
        VerifyArgument.noNullElements((Iterable)((Object)typeArguments), (String)"typeArguments");
        return this.makeGenericTypeCore(typeArguments);
    }

    public final <U extends T> Type<U> makeGenericType(Type<?> ... typeArguments) {
        return this.makeGenericTypeCore(Type.list((Type[])VerifyArgument.noNullElements((Object[])typeArguments, (String)"typeArguments")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Type<?> getErasedType() {
        if (this.isArray()) {
            return this.getElementType().getErasedType().makeArrayType();
        }
        if (this.isGenericParameter()) {
            return this.getExtendsBound().getErasedType();
        }
        if (!this.isGenericType()) {
            return this;
        }
        if (!this.isGenericTypeDefinition()) {
            return this.getGenericTypeDefinition().getErasedType();
        }
        if (this._erasedType == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._erasedType == null) {
                    this._erasedType = new ErasedType(this);
                }
            }
        }
        return this._erasedType;
    }

    protected Type makeGenericTypeCore(TypeList typeArguments) {
        throw Error.notGenericType(this);
    }

    protected static Type<?> substitute(Type<?> type, TypeBindings typeBindings) {
        return Helper.substitute(type, typeBindings);
    }

    public Type<?> asSuperTypeOf(@NotNull Type<?> type) {
        return Helper.asSuper((Type)VerifyArgument.notNull(type, (String)"type"), this);
    }

    Type getRootElementType() {
        Type<?> rootElementType = this;
        while (rootElementType.hasElementType()) {
            rootElementType = rootElementType.getElementType();
        }
        return rootElementType;
    }

    Type getMostSpecificType(Type t1, Type t2) {
        if (t1.isSubTypeOf(t2)) {
            return t1;
        }
        if (t2.isSubTypeOf(t1)) {
            return t2;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getBriefDescription();
    }

    @Override
    public String getName() {
        return this.getCache().getName();
    }

    protected String getClassFullName() {
        return this.getErasedClass().getName();
    }

    protected String getClassSimpleName() {
        return this.getErasedClass().getSimpleName();
    }

    public String getShortName() {
        return this.getClassSimpleName();
    }

    public String getFullName() {
        return this.getCache().getFullName();
    }

    public String getInternalName() {
        return this.getCache().getInternalName();
    }

    public String getGenericSignature() {
        return this.getCache().getGenericSignature();
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        TypeList typeArguments;
        int count;
        StringBuilder s = this._appendClassName(sb, true, true);
        if (this.isGenericType() && (count = (typeArguments = this.getTypeBindings().getBoundTypes()).size()) > 0) {
            s.append('<');
            for (int i = 0; i < count; ++i) {
                if (i != 0) {
                    s.append(", ");
                }
                s = ((Type)typeArguments.get(i)).appendBriefDescription(s);
            }
            s.append('>');
        }
        return s;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        TypeList typeArguments;
        int count;
        StringBuilder s = this._appendClassName(sb, false, false);
        if (this.isGenericType() && (count = (typeArguments = this.getTypeBindings().getBoundTypes()).size()) > 0) {
            s.append('<');
            for (int i = 0; i < count; ++i) {
                if (i != 0) {
                    s.append(", ");
                }
                s = ((Type)typeArguments.get(i)).appendSimpleDescription(s);
            }
            s.append('>');
        }
        return s;
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        return sb.append(this.getClassFullName());
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        TypeList interfaces;
        int interfaceCount;
        Type<T> baseType;
        TypeList typeArguments;
        int count;
        StringBuilder s = this._appendClassName(sb, false, false);
        if (this.isGenericType() && (count = (typeArguments = this.getTypeBindings().getBoundTypes()).size()) > 0) {
            s.append('<');
            for (int i = 0; i < count; ++i) {
                if (i != 0) {
                    s.append(", ");
                }
                s = ((Type)typeArguments.get(i)).appendBriefDescription(s);
            }
            s.append('>');
        }
        if ((baseType = this.getBaseType()) != null && baseType != Types.Object) {
            s.append(" extends ");
            s = baseType.appendBriefDescription(s);
        }
        if ((interfaceCount = (interfaces = this.getExplicitInterfaces()).size()) > 0) {
            s.append(" implements ");
            for (int i = 0; i < interfaceCount; ++i) {
                if (i != 0) {
                    s.append(",");
                }
                s = ((Type)interfaces.get(i)).appendBriefDescription(s);
            }
        }
        return s;
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        if (this.isGenericParameter()) {
            sb.append('T');
            sb.append(this.getName());
            sb.append(';');
            return sb;
        }
        return this._appendClassSignature(sb);
    }

    @Override
    public StringBuilder appendGenericSignature(StringBuilder sb) {
        TypeList genericParameters;
        int count;
        StringBuilder s = sb;
        if (this.isGenericParameter()) {
            Type<?> extendsBound = this.getExtendsBound();
            s.append(this.getName());
            if (extendsBound.isInterface()) {
                s.append(':');
            }
            s.append(':');
            s = extendsBound.appendSignature(s);
            return s;
        }
        if (this.isGenericType() && (count = (genericParameters = this.getTypeBindings().getBoundTypes()).size()) > 0) {
            s.append('<');
            for (int i = 0; i < count; ++i) {
                s = ((Type)genericParameters.get(i)).appendGenericSignature(s);
            }
            s.append('>');
        }
        Type<T> baseType = this.getBaseType();
        TypeList interfaces = this.getExplicitInterfaces();
        if (baseType == null) {
            if (interfaces.isEmpty()) {
                s = Types.Object.appendSignature(s);
            }
        } else {
            s = baseType.appendSignature(s);
        }
        Iterator i$ = interfaces.iterator();
        while (i$.hasNext()) {
            Type interfaceType = (Type)i$.next();
            s = interfaceType.appendSignature(s);
        }
        return s;
    }

    @Override
    protected void invalidateCaches() {
        super.invalidateCaches();
        this._cache = null;
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        if (this.isGenericType() && !this.isGenericTypeDefinition()) {
            return this.getGenericTypeDefinition().appendErasedSignature(sb);
        }
        return this._appendErasedClassSignature(sb);
    }

    protected StringBuilder _appendClassSignature(StringBuilder sb) {
        TypeList typeArguments;
        int count;
        StringBuilder s = sb;
        s.append('L');
        s = this._appendClassName(s, true, false);
        if (this.isGenericType() && (count = (typeArguments = this.getTypeBindings().getBoundTypes()).size()) > 0) {
            s.append('<');
            for (int i = 0; i < count; ++i) {
                Type type = (Type)typeArguments.get(i);
                s = type.isGenericTypeDefinition() ? type.appendErasedSignature(s) : type.appendSignature(s);
            }
            s.append('>');
        }
        s.append(';');
        return s;
    }

    protected StringBuilder _appendErasedClassSignature(StringBuilder sb) {
        sb.append('L');
        sb = this._appendClassName(sb, true, false);
        sb.append(';');
        return sb;
    }

    protected StringBuilder _appendClassDescription(StringBuilder sb) {
        TypeList typeArguments;
        int count;
        StringBuilder s = sb;
        s.append(this.getClassFullName());
        if (this.isGenericType() && (count = (typeArguments = this.getTypeBindings().getBoundTypes()).size()) > 0) {
            s.append('<');
            for (int i = 0; i < count; ++i) {
                s = ((Type)typeArguments.get(i))._appendErasedClassSignature(s);
            }
            s.append('>');
        }
        return s;
    }

    protected StringBuilder _appendClassName(StringBuilder sb, boolean fullName, boolean dottedName) {
        int start;
        if (!fullName) {
            return sb.append(this.getClassSimpleName());
        }
        String name = this.getClassFullName();
        if (dottedName) {
            return sb.append(name);
        }
        int packageEnd = name.lastIndexOf(46);
        if (packageEnd >= 0) {
            for (int i = 0; i < packageEnd; ++i) {
                char c = name.charAt(i);
                if (c == '.') {
                    c = '/';
                }
                sb.append(c);
            }
            sb.append('/');
            start = packageEnd + 1;
        } else {
            start = 0;
        }
        return sb.append(name, start, name.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Type<T> of(Class<T> clazz) {
        Object object = CACHE_LOCK;
        synchronized (object) {
            Type<T> reflectedType = CACHE.find(clazz);
            if (reflectedType != null) {
                return reflectedType;
            }
            int arrayDepth = 0;
            Class<Object> actualClass = clazz;
            while (actualClass.isArray()) {
                actualClass = actualClass.getComponentType();
                ++arrayDepth;
            }
            Type<Object> resolvedType = Type.resolveClassType(actualClass);
            if (resolvedType == null) {
                throw Error.couldNotResolveType(clazz);
            }
            while (arrayDepth > 0) {
                resolvedType = resolvedType.makeArrayType();
                --arrayDepth;
            }
            return resolvedType;
        }
    }

    public static Type<?> forName(String name) {
        return Type.forName(name, true);
    }

    public static Type<?> forName(String name, boolean throwOnError) {
        try {
            return TypeParser.parse(name);
        }
        catch (Throwable t) {
            if (throwOnError) {
                throw t;
            }
            return null;
        }
    }

    private static Type<?> resolveClassType(Class<?> actualClass) {
        Type<?> declaringType;
        if (actualClass.isAnonymousClass()) {
            Object[] interfaces = actualClass.getInterfaces();
            if (!ArrayUtilities.isNullOrEmpty((Object[])interfaces)) {
                return Type.of(interfaces[0]);
            }
            return Type.of(actualClass.getSuperclass());
        }
        Class<?> declaringClass = actualClass.getEnclosingClass();
        if (declaringClass != null && (declaringType = Type.of(declaringClass)) != null && actualClass.getEnclosingMethod() == null && actualClass.getEnclosingConstructor() == null) {
            return declaringType.getNestedType(actualClass.getSimpleName(), BindingFlags.All);
        }
        return RESOLVER.resolve(actualClass);
    }

    public static <T> Type<T> getType(T object) {
        if (object == null) {
            return NullType;
        }
        return Type.of(object.getClass());
    }

    static <T> Type<T> of(java.lang.reflect.Type type) {
        if (type instanceof GenericArrayType) {
            return Type.of(((GenericArrayType)type).getGenericComponentType()).makeArrayType();
        }
        if (type instanceof Class) {
            return Type.of((Class)type);
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            Type<?> resultType = Type.tryFind(type);
            if (resultType != null) {
                return resultType;
            }
            resultType = RESOLVER.resolve(type);
            if (resultType != null) {
                return resultType;
            }
            throw Error.couldNotResolveType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Type<?> tryFind(java.lang.reflect.Type type) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (classType.isPrimitive() || classType == Void.class) {
                return Type.of(classType);
            }
            Object object = CACHE_LOCK;
            synchronized (object) {
                return CACHE.find(classType);
            }
        }
        return null;
    }

    public static <T> Type<? extends T> makeExtendsWildcard(Type<T> bound) {
        return new WildcardType((Type)VerifyArgument.notNull(bound, (String)"bound"), Bottom);
    }

    public static <T> Type<? super T> makeSuperWildcard(Type<T> bound) {
        return new WildcardType<Object>(Types.Object, bound);
    }

    public static WildcardType<?> makeWildcard() {
        return UnboundedWildcard;
    }

    public static <T> Type<T[]> makeArrayType(Type<T> elementType) {
        return new ArrayType<T[]>(elementType);
    }

    public static Type<?> makeCompoundType(TypeList bounds) {
        TypeList interfaces;
        Type baseType;
        VerifyArgument.notEmpty((Iterable)((Object)bounds), (String)"bounds");
        VerifyArgument.noNullElements((Iterable)((Object)bounds), (String)"bounds");
        if (!((Type)bounds.get(0)).isInterface()) {
            baseType = (Type)bounds.get(0);
            interfaces = bounds.subList(1, bounds.size());
        } else {
            baseType = Types.Object;
            interfaces = bounds;
        }
        return Type.makeCompoundType(baseType, interfaces);
    }

    public static Type<?> makeCompoundType(Type<?> baseType, TypeList interfaces) {
        VerifyArgument.notNull(baseType, (String)"baseType");
        VerifyArgument.noNullElements((Iterable)((Object)interfaces), (String)"interfaces");
        return Type.makeCompoundTypeCore(baseType, interfaces);
    }

    private static <T> Type<T> makeCompoundTypeCore(Type<T> baseType, TypeList interfaces) {
        if (baseType.isGenericParameter()) {
            throw Error.compoundTypeMayNotHaveGenericParameterBound();
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            Type type = (Type)interfaces.get(i);
            if (type.isGenericParameter()) {
                throw Error.compoundTypeMayNotHaveGenericParameterBound();
            }
            if (type.isInterface()) continue;
            throw Error.compoundTypeMayOnlyHaveOneClassBound();
        }
        return new CompoundType<T>(interfaces, baseType);
    }

    public static TypeList list(Class<?> ... classes) {
        if (ArrayUtilities.isNullOrEmpty((Object[])classes)) {
            return TypeList.empty();
        }
        Type[] types = new Type[classes.length];
        int n = classes.length;
        for (int i = 0; i < n; ++i) {
            types[i] = Type.of(classes[i]);
        }
        return new TypeList(types);
    }

    public static TypeList list(Type ... types) {
        return new TypeList(types);
    }

    public static TypeList list(List<? extends Type<?>> types) {
        return new TypeList(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final RuntimeTypeCache<T> getCache() {
        if (this._cache == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._cache == null) {
                    this._cache = new RuntimeTypeCache(this);
                }
            }
        }
        return this._cache;
    }

    protected ConstructorList getDeclaredConstructors() {
        return ConstructorList.empty();
    }

    protected MethodList getDeclaredMethods() {
        return MethodList.empty();
    }

    protected FieldList getDeclaredFields() {
        return FieldList.empty();
    }

    protected TypeList getDeclaredTypes() {
        return TypeList.empty();
    }

    private <T extends MethodBase> T[] getMethodBaseCandidates(MemberType type, String name, Set<BindingFlags> bindingFlags, CallingConvention callingConvention, Type[] parameterTypes, boolean allowPrefixLookup) {
        FilterOptions filterOptions = Type.getFilterOptions(name, bindingFlags, allowPrefixLookup);
        ArrayList<MethodBase> source = type == MemberType.Constructor ? this.getCache().getConstructorList(filterOptions.listOptions, name) : this.getCache().getMethodList(filterOptions.listOptions, name);
        EnumSet<BindingFlags> flags = EnumSet.copyOf(bindingFlags);
        if (!flags.remove((Object)BindingFlags.DeclaredOnly)) {
            flags.add(BindingFlags.DeclaredOnly);
        }
        ArrayList<MethodBase> candidates = null;
        int n = source.size();
        for (int i = 0; i < n; ++i) {
            Set<BindingFlags> methodFlags;
            MethodBase method = source.get(i);
            boolean passesFilter = this.filterMethodBase(method, methodFlags = type == MemberType.Constructor ? ((RuntimeConstructorInfo)method).getBindingFlags() : ((RuntimeMethodInfo)method).getBindingFlags(), flags, callingConvention, parameterTypes);
            if (!passesFilter) continue;
            if (filterOptions.prefixLookup) {
                if (!this.filterApplyPrefixLookup(method, filterOptions.name, filterOptions.ignoreCase)) {
                    continue;
                }
            } else if (name != null) {
                String methodName = method.getName();
                if (!filterOptions.ignoreCase ? !name.equals(methodName) : !name.equalsIgnoreCase(methodName)) continue;
            }
            if (candidates == null) {
                candidates = new ArrayList<MethodBase>(n);
            }
            candidates.add(method);
        }
        if (candidates == null) {
            if (type == MemberType.Constructor) {
                return EmptyConstructors;
            }
            return EmptyMethods;
        }
        MethodBase[] results = (MethodBase[])Array.newInstance(type == MemberType.Constructor ? ConstructorInfo.class : MethodInfo.class, candidates.size());
        candidates.toArray((Object[])results);
        return results;
    }

    private FieldInfo[] getFieldCandidates(String name, Set<BindingFlags> bindingFlags, boolean allowPrefixLookup) {
        EnumSet<BindingFlags> flags = EnumSet.copyOf(bindingFlags);
        if (!flags.remove((Object)BindingFlags.DeclaredOnly)) {
            flags.add(BindingFlags.DeclaredOnly);
        }
        FilterOptions filterOptions = Type.getFilterOptions(name, flags, allowPrefixLookup);
        ArrayList<RuntimeFieldInfo> fields = this.getCache().getFieldList(filterOptions.listOptions, name);
        ArrayList<FieldInfo> candidates = null;
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            FieldInfo field = fields.get(i);
            Set<BindingFlags> fieldFlags = BindingFlags.fromMember(field);
            if (!flags.containsAll(fieldFlags)) continue;
            if (filterOptions.prefixLookup) {
                if (!this.filterApplyPrefixLookup(field, filterOptions.name, filterOptions.ignoreCase)) {
                    continue;
                }
            } else if (name != null) {
                String methodName = field.getName();
                if (!filterOptions.ignoreCase ? !name.equals(methodName) : !name.equalsIgnoreCase(methodName)) continue;
            }
            if (candidates == null) {
                candidates = new ArrayList<FieldInfo>(n);
            }
            candidates.add(field);
        }
        if (candidates == null) {
            return EmptyFields;
        }
        FieldInfo[] results = new FieldInfo[candidates.size()];
        return candidates.toArray(results);
    }

    private Type[] getNestedTypeCandidates(String fullName, Set<BindingFlags> bindingFlags, boolean allowPrefixLookup) {
        String name;
        if (fullName != null) {
            boolean isLongName;
            String ownerName = this.getName();
            boolean bl = isLongName = bindingFlags.contains((Object)BindingFlags.IgnoreCase) ? StringUtilities.startsWithIgnoreCase((CharSequence)fullName, (String)ownerName) : fullName.startsWith(ownerName);
            if (isLongName) {
                if (fullName.length() == ownerName.length()) {
                    return EmptyTypes;
                }
                name = fullName.substring(ownerName.length() + 1);
            } else {
                name = fullName;
            }
        } else {
            name = null;
        }
        FilterOptions filterOptions = Type.getFilterOptions(name, bindingFlags, allowPrefixLookup);
        ArrayList<Type<?>> nestedTypes = this.getCache().getNestedTypeList(filterOptions.listOptions, name);
        ListBuffer candidates = new ListBuffer();
        int n = nestedTypes.size();
        for (int i = 0; i < n; ++i) {
            Type<?> nestedType = nestedTypes.get(i);
            if (!this.filterApplyType(nestedType, bindingFlags, name, filterOptions.prefixLookup)) continue;
            candidates.add(nestedType);
        }
        if (candidates.isEmpty()) {
            return EmptyTypes;
        }
        return (Type[])candidates.toArray((Object[])new Type[candidates.size()]);
    }

    boolean filterMethodBase(MethodBase method, Set<BindingFlags> methodFlags, Set<BindingFlags> bindingFlags, CallingConvention callingConventions, Type ... argumentTypes) {
        if (!bindingFlags.containsAll(methodFlags)) {
            return false;
        }
        if (callingConventions != null && callingConventions != CallingConvention.Any && callingConventions != method.getCallingConvention()) {
            return false;
        }
        if (argumentTypes != null) {
            int suppliedArgumentCount = argumentTypes.length;
            ParameterList parameters = method.getParameters();
            int definedParameterCount = parameters.size();
            if (suppliedArgumentCount != definedParameterCount) {
                if (bindingFlags.contains((Object)BindingFlags.InvokeMethod) || bindingFlags.contains((Object)BindingFlags.CreateInstance)) {
                    return false;
                }
                if (method.getCallingConvention() == CallingConvention.VarArgs) {
                    if (definedParameterCount == 0) {
                        return false;
                    }
                    if (suppliedArgumentCount < definedParameterCount - 1) {
                        return false;
                    }
                    ParameterInfo lastParameter = (ParameterInfo)parameters.get(definedParameterCount - 1);
                    Type<?> lastParameterType = lastParameter.getParameterType();
                    if (!lastParameterType.isArray()) {
                        return false;
                    }
                } else if (suppliedArgumentCount != 0) {
                    return false;
                }
            } else if (bindingFlags.contains((Object)BindingFlags.ExactBinding) && !bindingFlags.contains((Object)BindingFlags.InvokeMethod)) {
                for (int i = 0; i < definedParameterCount; ++i) {
                    if (TypeUtils.areEquivalent(((ParameterInfo)parameters.get(i)).getParameterType(), argumentTypes[i])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean filterApplyType(Type<?> type, Set<BindingFlags> bindingFlags, String name, boolean prefixLookup) {
        VerifyArgument.notNull(type, (String)"type");
        boolean isPublic = type.isPublic();
        boolean isStatic = type.isStatic();
        return this.filterApplyCore(type, bindingFlags, isPublic, type.isNested() && type.isPackagePrivate(), isStatic, name, prefixLookup);
    }

    private boolean filterApplyCore(MemberInfo member, Set<BindingFlags> bindingFlags, boolean isPublic, boolean isPackagePrivate, boolean isStatic, String name, boolean prefixLookup) {
        boolean isInherited;
        if (isPublic ? !bindingFlags.contains((Object)BindingFlags.Public) : !bindingFlags.contains((Object)BindingFlags.NonPublic)) {
            return false;
        }
        Type thisType = this.isGenericType() ? this.getGenericTypeDefinition() : this;
        boolean bl = isInherited = member.getDeclaringType() != thisType;
        if (isInherited && bindingFlags.contains((Object)BindingFlags.DeclaredOnly)) {
            return false;
        }
        if (member.getMemberType() != MemberType.TypeInfo && member.getMemberType() != MemberType.NestedType) {
            if (isStatic) {
                if (!bindingFlags.contains((Object)BindingFlags.FlattenHierarchy) && isInherited) {
                    return false;
                }
                if (!bindingFlags.contains((Object)BindingFlags.Static)) {
                    return false;
                }
            } else if (!bindingFlags.contains((Object)BindingFlags.Instance)) {
                return false;
            }
        }
        if (prefixLookup && !this.filterApplyPrefixLookup(member, name, bindingFlags.contains((Object)BindingFlags.IgnoreCase))) {
            return false;
        }
        if (!bindingFlags.contains((Object)BindingFlags.DeclaredOnly) && isInherited && isPackagePrivate && bindingFlags.contains((Object)BindingFlags.NonPublic) && !isStatic && bindingFlags.contains((Object)BindingFlags.Instance)) {
            return member instanceof MethodInfo && !member.isFinal();
        }
        return true;
    }

    private boolean filterApplyPrefixLookup(MemberInfo method, String name, boolean ignoreCase) {
        String methodName = method.getName();
        return !(ignoreCase ? !StringUtilities.startsWithIgnoreCase((CharSequence)methodName.toLowerCase(), (String)name) : !methodName.toLowerCase().startsWith(name));
    }

    private static FilterOptions getFilterOptions(String name, Set<BindingFlags> bindingFlags, boolean allowPrefixLookup) {
        String filterName = name;
        boolean prefixLookup = false;
        boolean ignoreCase = false;
        MemberListType listOptions = MemberListType.All;
        if (name != null) {
            if (bindingFlags.contains((Object)BindingFlags.IgnoreCase)) {
                filterName = name.toLowerCase();
                ignoreCase = true;
                listOptions = MemberListType.CaseInsensitive;
            } else {
                listOptions = MemberListType.CaseSensitive;
            }
            if (allowPrefixLookup && name.endsWith("*")) {
                filterName = name.substring(0, name.length() - 1);
                prefixLookup = true;
                listOptions = MemberListType.All;
            }
        }
        return new FilterOptions(filterName, prefixLookup, ignoreCase, listOptions);
    }

    static Set<BindingFlags> filterPreCalculate(boolean isPublic, boolean isInherited, boolean isStatic) {
        int mask;
        int n = mask = isPublic ? BindingFlags.Public.getMask() : BindingFlags.NonPublic.getMask();
        if (isInherited) {
            mask |= BindingFlags.DeclaredOnly.getMask();
            mask = isStatic ? (mask |= BindingFlags.Static.getMask() | BindingFlags.FlattenHierarchy.getMask()) : (mask |= BindingFlags.Instance.getMask());
        } else {
            mask = isStatic ? (mask |= BindingFlags.Static.getMask()) : (mask |= BindingFlags.Instance.getMask());
        }
        return BindingFlags.fromMask(mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = CACHE_LOCK = new Object();
        synchronized (object) {
            CACHE = new TypeCache();
            RESOLVER = new Resolver();
            PRIMITIVE_TYPES = new PrimitiveType[TypeKind.values().length];
            PrimitiveTypes.ensureRegistered();
            Type.PRIMITIVE_TYPES[TypeKind.VOID.ordinal()] = PrimitiveTypes.Void;
            Type.PRIMITIVE_TYPES[TypeKind.BOOLEAN.ordinal()] = PrimitiveTypes.Boolean;
            Type.PRIMITIVE_TYPES[TypeKind.BYTE.ordinal()] = PrimitiveTypes.Byte;
            Type.PRIMITIVE_TYPES[TypeKind.CHAR.ordinal()] = PrimitiveTypes.Character;
            Type.PRIMITIVE_TYPES[TypeKind.SHORT.ordinal()] = PrimitiveTypes.Short;
            Type.PRIMITIVE_TYPES[TypeKind.INT.ordinal()] = PrimitiveTypes.Integer;
            Type.PRIMITIVE_TYPES[TypeKind.LONG.ordinal()] = PrimitiveTypes.Long;
            Type.PRIMITIVE_TYPES[TypeKind.FLOAT.ordinal()] = PrimitiveTypes.Float;
            Type.PRIMITIVE_TYPES[TypeKind.DOUBLE.ordinal()] = PrimitiveTypes.Double;
            Types.ensureRegistered();
            TYPE_BINDER = new TypeBinder();
            UnboundedWildcard = new WildcardType<Object>(Type.of(Object.class), Bottom);
        }
        FilterNameIgnoreCase = new MemberFilter(){

            @Override
            public boolean apply(MemberInfo m, Object filterCriteria) {
                String name = (String)filterCriteria;
                return name == null || name.equalsIgnoreCase(m.getName());
            }
        };
        FilterName = new MemberFilter(){

            @Override
            public boolean apply(MemberInfo m, Object filterCriteria) {
                String name = (String)filterCriteria;
                return name == null || name.equals(m.getName());
            }
        };
        FilterRawMember = new MemberFilter(){

            @Override
            public boolean apply(MemberInfo m, Object filterCriteria) {
                if (m instanceof Type) {
                    return Comparer.equals(((Type)m).getErasedClass(), (Object)filterCriteria);
                }
                if (m instanceof MethodInfo) {
                    return Comparer.equals((Object)((MethodInfo)m).getRawMethod(), (Object)filterCriteria);
                }
                if (m instanceof ConstructorInfo) {
                    return Comparer.equals(((ConstructorInfo)m).getRawConstructor(), (Object)filterCriteria);
                }
                return m instanceof FieldInfo && Comparer.equals((Object)((FieldInfo)m).getRawField(), (Object)filterCriteria);
            }
        };
        FilterMethodOverride = new MemberFilter(){

            @Override
            public boolean apply(MemberInfo m, Object filterCriteria) {
                if (!(m instanceof MethodInfo) || !(filterCriteria instanceof MethodInfo)) {
                    return false;
                }
                MethodInfo base = (MethodInfo)filterCriteria;
                MethodInfo candidate = (MethodInfo)m;
                return Helper.overrides(candidate, base);
            }
        };
    }

    private static final class FilterOptions {
        final String name;
        final boolean prefixLookup;
        final boolean ignoreCase;
        final MemberListType listOptions;

        FilterOptions(String name, boolean prefixLookup, boolean ignoreCase, MemberListType listOptions) {
            this.name = name;
            this.prefixLookup = prefixLookup;
            this.ignoreCase = ignoreCase;
            this.listOptions = listOptions;
        }
    }
}

