/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.RuntimeTypeCache;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import java.lang.reflect.Constructor;
import java.util.Set;

final class RuntimeConstructorInfo
extends ConstructorInfo {
    private final Constructor<?> _rawConstructor;
    private final RuntimeTypeCache<?> _reflectedTypeCache;
    private final Set<BindingFlags> _bindingFlags;
    private final int _modifiers;
    private final ParameterList _parameters;
    private final SignatureType _signatureType;

    RuntimeConstructorInfo(Constructor<?> rawConstructor, RuntimeTypeCache<?> reflectedTypeCache, int modifiers, Set<BindingFlags> bindingFlags, ParameterList parameters) {
        this._rawConstructor = (Constructor)VerifyArgument.notNull(rawConstructor, (String)"rawConstructor");
        this._reflectedTypeCache = (RuntimeTypeCache)VerifyArgument.notNull(reflectedTypeCache, (String)"reflectedTypeCache");
        this._bindingFlags = (Set)VerifyArgument.notNull(bindingFlags, (String)"bindingFlags");
        this._modifiers = modifiers;
        this._parameters = (ParameterList)((Object)VerifyArgument.notNull((Object)((Object)parameters), (String)"parameters"));
        this._signatureType = new SignatureType(PrimitiveTypes.Void, this._parameters.getParameterTypes());
    }

    Set<BindingFlags> getBindingFlags() {
        return this._bindingFlags;
    }

    @Override
    public SignatureType getSignatureType() {
        return this._signatureType;
    }

    @Override
    public ParameterList getParameters() {
        return this._parameters;
    }

    @Override
    public Constructor<?> getRawConstructor() {
        return this._rawConstructor;
    }

    @Override
    public Type getDeclaringType() {
        return this._reflectedTypeCache.getRuntimeType();
    }

    @Override
    public Type getReflectedType() {
        return this._reflectedTypeCache.getRuntimeType();
    }

    @Override
    public int getModifiers() {
        return this._modifiers;
    }

    @Override
    public boolean isEquivalentTo(MemberInfo m) {
        if (m == this) {
            return true;
        }
        if (m instanceof RuntimeConstructorInfo) {
            RuntimeConstructorInfo other = (RuntimeConstructorInfo)m;
            if (other._reflectedTypeCache == this._reflectedTypeCache && other._rawConstructor == this._rawConstructor) {
                return true;
            }
        }
        return super.isEquivalentTo(m);
    }
}

