/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.BinaryExpression;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import com.strobel.util.TypeUtils;

final class EqualsMethodBasedLogicalBinaryExpression
extends BinaryExpression {
    private final ExpressionType _operator;
    private final MethodInfo _method;

    public EqualsMethodBasedLogicalBinaryExpression(ExpressionType operator, Expression left, Expression right, MethodInfo method) {
        super(left, right);
        this._operator = operator;
        if (method != null) {
            this._method = method;
        } else {
            MethodInfo equalsMethod = Types.Comparer.getMethod(operator == ExpressionType.Equal ? "equals" : "notEqual", BindingFlags.PublicStatic, new Type[]{Types.Object, Types.Object});
            this._method = TypeUtils.areEquivalent(left.getType(), right.getType()) ? equalsMethod.makeGenericMethod(new Type[]{left.getType()}) : equalsMethod.makeGenericMethod(new Type[]{Types.Object});
        }
    }

    @Override
    public final Type<?> getType() {
        return PrimitiveTypes.Boolean;
    }

    @Override
    public final ExpressionType getNodeType() {
        return this._operator;
    }

    @Override
    public MethodInfo getMethod() {
        return this._method;
    }
}

