/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apereo.inspektr.audit.AspectJAuditPointRuntimeInfo;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditPointRuntimeInfo;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.annotation.Audit;
import org.apereo.inspektr.audit.annotation.Audits;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.common.spi.ClientInfoResolver;
import org.apereo.inspektr.common.spi.DefaultClientInfoResolver;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.apereo.inspektr.common.web.ClientInfo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AuditTrailManagementAspect {
    private static final Logger LOG = LoggerFactory.getLogger(AuditTrailManagementAspect.class);
    private final PrincipalResolver auditPrincipalResolver;
    private final Map<String, AuditActionResolver> auditActionResolvers;
    private final Map<String, AuditResourceResolver> auditResourceResolvers;
    private final List<AuditTrailManager> auditTrailManagers;
    private final String applicationCode;
    private ClientInfoResolver clientInfoResolver = new DefaultClientInfoResolver();
    private boolean failOnAuditFailures = true;

    public AuditTrailManagementAspect(String applicationCode, PrincipalResolver auditablePrincipalResolver, List<AuditTrailManager> auditTrailManagers, Map<String, AuditActionResolver> auditActionResolverMap, Map<String, AuditResourceResolver> auditResourceResolverMap) {
        this.auditPrincipalResolver = auditablePrincipalResolver;
        this.auditTrailManagers = auditTrailManagers;
        this.applicationCode = applicationCode;
        this.auditActionResolvers = auditActionResolverMap;
        this.auditResourceResolvers = auditResourceResolverMap;
    }

    @Around(value="@annotation(audits)", argNames="audits")
    public Object handleAuditTrail(ProceedingJoinPoint joinPoint, Audits audits) throws Throwable {
        Object retVal = null;
        String currentPrincipal = null;
        String[] actions = new String[audits.value().length];
        String[][] auditableResources = new String[audits.value().length][];
        try {
            retVal = joinPoint.proceed();
            currentPrincipal = this.auditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, retVal);
            if (currentPrincipal != null) {
                for (int i = 0; i < audits.value().length; ++i) {
                    AuditActionResolver auditActionResolver = this.auditActionResolvers.get(audits.value()[i].actionResolverName());
                    AuditResourceResolver auditResourceResolver = this.auditResourceResolvers.get(audits.value()[i].resourceResolverName());
                    auditableResources[i] = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, retVal);
                    actions[i] = auditActionResolver.resolveFrom((JoinPoint)joinPoint, retVal, audits.value()[i]);
                }
            }
            Object i = retVal;
            return i;
        }
        catch (Throwable e) {
            currentPrincipal = this.auditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, (Object)e);
            if (currentPrincipal != null) {
                for (int i = 0; i < audits.value().length; ++i) {
                    auditableResources[i] = this.auditResourceResolvers.get(audits.value()[i].resourceResolverName()).resolveFrom((JoinPoint)joinPoint, e);
                    actions[i] = this.auditActionResolvers.get(audits.value()[i].actionResolverName()).resolveFrom((JoinPoint)joinPoint, e, audits.value()[i]);
                }
            }
            throw e;
        }
        finally {
            for (int i = 0; i < audits.value().length; ++i) {
                this.executeAuditCode(currentPrincipal, auditableResources[i], joinPoint, retVal, actions[i], audits.value()[i]);
            }
        }
    }

    @Around(value="@annotation(audit)", argNames="audit")
    public Object handleAuditTrail(ProceedingJoinPoint joinPoint, Audit audit) throws Throwable {
        AuditActionResolver auditActionResolver = this.auditActionResolvers.get(audit.actionResolverName());
        AuditResourceResolver auditResourceResolver = this.auditResourceResolvers.get(audit.resourceResolverName());
        String currentPrincipal = null;
        String[] auditResource = new String[]{null};
        String action = null;
        Object retVal = null;
        try {
            retVal = joinPoint.proceed();
            currentPrincipal = this.auditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, retVal);
            auditResource = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, retVal);
            action = auditActionResolver.resolveFrom((JoinPoint)joinPoint, retVal, audit);
            Object object = retVal;
            this.executeAuditCode(currentPrincipal, auditResource, joinPoint, retVal, action, audit);
            return object;
        }
        catch (Throwable e) {
            try {
                currentPrincipal = this.auditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, (Object)e);
                auditResource = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, e);
                action = auditActionResolver.resolveFrom((JoinPoint)joinPoint, e, audit);
                throw e;
            }
            catch (Throwable throwable) {
                this.executeAuditCode(currentPrincipal, auditResource, joinPoint, retVal, action, audit);
                throw throwable;
            }
        }
    }

    private void executeAuditCode(String currentPrincipal, String[] auditableResources, ProceedingJoinPoint joinPoint, Object retVal, String action, Audit audit) {
        String applicationCode = audit.applicationCode() != null && audit.applicationCode().length() > 0 ? audit.applicationCode() : this.applicationCode;
        ClientInfo clientInfo = this.clientInfoResolver.resolveFrom((JoinPoint)joinPoint, retVal);
        Date actionDate = new Date();
        AspectJAuditPointRuntimeInfo runtimeInfo = new AspectJAuditPointRuntimeInfo((JoinPoint)joinPoint);
        this.assertNotNull(currentPrincipal, "'principal' cannot be null.\n" + this.getDiagnosticInfo(runtimeInfo));
        this.assertNotNull(action, "'actionPerformed' cannot be null.\n" + this.getDiagnosticInfo(runtimeInfo));
        this.assertNotNull(applicationCode, "'applicationCode' cannot be null.\n" + this.getDiagnosticInfo(runtimeInfo));
        this.assertNotNull(actionDate, "'whenActionPerformed' cannot be null.\n" + this.getDiagnosticInfo(runtimeInfo));
        this.assertNotNull(clientInfo.getClientIpAddress(), "'clientIpAddress' cannot be null.\n" + this.getDiagnosticInfo(runtimeInfo));
        this.assertNotNull(clientInfo.getServerIpAddress(), "'serverIpAddress' cannot be null.\n" + this.getDiagnosticInfo(runtimeInfo));
        for (String auditableResource : auditableResources) {
            this.assertNotNull(auditableResource, "'resourceOperatedUpon' cannot be null.\n" + this.getDiagnosticInfo(runtimeInfo));
            AuditActionContext auditContext = new AuditActionContext(currentPrincipal, auditableResource, action, applicationCode, actionDate, clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress());
            try {
                for (AuditTrailManager manager : this.auditTrailManagers) {
                    manager.record(auditContext);
                }
            }
            catch (Throwable e) {
                if (this.failOnAuditFailures) {
                    throw e;
                }
                LOG.error("Failed to record audit context for " + auditContext.getActionPerformed() + " and principal " + auditContext.getPrincipal(), e);
            }
        }
    }

    public void setFailOnAuditFailures(boolean failOnAuditFailures) {
        this.failOnAuditFailures = failOnAuditFailures;
    }

    public void setClientInfoResolver(ClientInfoResolver factory) {
        this.clientInfoResolver = factory;
    }

    private String getDiagnosticInfo(AuditPointRuntimeInfo runtimeInfo) {
        return "Check the correctness of @Audit annotation at the following audit point: " + runtimeInfo.asString();
    }

    private void assertNotNull(Object o, String message) {
        if (o == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

