/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecSignatureConfirmation;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class SignatureConfirmationAction
implements Action {
    protected static Log log = LogFactory.getLog(SignatureConfirmationAction.class);

    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        List results;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Perform Signature confirmation");
        }
        if ((results = (List)handler.getProperty(reqData.getMsgContext(), "RECV_RESULTS")) == null) {
            return;
        }
        ArrayList<WSSecurityEngineResult> signatureActions = new ArrayList<WSSecurityEngineResult>();
        for (WSHandlerResult wshResult : results) {
            List<WSSecurityEngineResult> resultList = wshResult.getResults();
            WSSecurityUtil.fetchAllActionResults(resultList, 2, signatureActions);
            WSSecurityUtil.fetchAllActionResults(resultList, 16, signatureActions);
            WSSecurityUtil.fetchAllActionResults(resultList, 64, signatureActions);
        }
        WSSecSignatureConfirmation wsc = new WSSecSignatureConfirmation(reqData.getWssConfig());
        List<WSEncryptionPart> signatureParts = reqData.getSignatureParts();
        if (signatureActions.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signature Confirmation: number of Signature results: " + signatureActions.size()));
            }
            for (int i = 0; i < signatureActions.size(); ++i) {
                WSSecurityEngineResult wsr = (WSSecurityEngineResult)signatureActions.get(i);
                byte[] sigVal = (byte[])wsr.get("signature-value");
                wsc.build(doc, sigVal, reqData.getSecHeader());
                signatureParts.add(new WSEncryptionPart(wsc.getId()));
            }
        } else {
            wsc.build(doc, null, reqData.getSecHeader());
            signatureParts.add(new WSEncryptionPart(wsc.getId()));
        }
        handler.setProperty(reqData.getMsgContext(), "_sigConfDone_", "");
    }
}

