/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.CustomTokenPrincipal;
import org.apache.ws.security.PublicKeyCallback;
import org.apache.ws.security.PublicKeyPrincipal;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.processor.BinarySecurityTokenProcessor;
import org.apache.ws.security.processor.DerivedKeyTokenProcessor;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.ReferenceListProcessor;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.processor.SecurityContextTokenProcessor;
import org.apache.ws.security.processor.UsernameTokenProcessor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.transform.STRTransformUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.Transforms;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$processor$SignatureProcessor == null ? (class$org$apache$ws$security$processor$SignatureProcessor = SignatureProcessor.class$("org.apache.ws.security.processor.SignatureProcessor")) : class$org$apache$ws$security$processor$SignatureProcessor).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    private String signatureId;
    private X509Certificate[] certificates;
    private byte[] secretKey;
    private int secretKeyLength = 16;
    private String signatureMethod;
    private String c14nMethod;
    static /* synthetic */ Class class$org$apache$ws$security$processor$SignatureProcessor;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found signature element");
        }
        boolean remove = WSDocInfoStore.store(wsDocInfo);
        X509Certificate[] returnCert = new X509Certificate[1];
        HashSet returnElements = new HashSet();
        ArrayList protectedElements = new ArrayList();
        byte[][] signatureValue = new byte[1][];
        Principal lastPrincipalFound = null;
        this.secretKeyLength = wsc.getSecretKeyLength();
        this.c14nMethod = null;
        this.signatureMethod = null;
        this.certificates = null;
        try {
            lastPrincipalFound = this.verifyXMLSignature(elem, crypto, returnCert, returnElements, protectedElements, signatureValue, cb, wsDocInfo);
        }
        catch (WSSecurityException ex) {
            throw ex;
        }
        finally {
            if (remove) {
                WSDocInfoStore.delete(wsDocInfo);
            }
        }
        byte[] storedKey = null;
        if (this.secretKey != null && this.secretKey.length > 0) {
            storedKey = new byte[this.secretKey.length];
            for (int i = 0; i < this.secretKey.length; ++i) {
                storedKey[i] = this.secretKey[i];
            }
        }
        if (lastPrincipalFound instanceof WSUsernameTokenPrincipal) {
            WSSecurityEngineResult result = new WSSecurityEngineResult(64, lastPrincipalFound, null, returnElements, protectedElements, signatureValue[0]);
            result.put(WSSecurityEngineResult.TAG_SIGNATURE_METHOD, this.signatureMethod);
            result.put(WSSecurityEngineResult.TAG_CANONICALIZATION_METHOD, this.c14nMethod);
            result.put("decrypted-key", storedKey);
            returnResults.add(0, result);
        } else {
            WSSecurityEngineResult result = new WSSecurityEngineResult(2, lastPrincipalFound, returnCert[0], returnElements, protectedElements, signatureValue[0]);
            result.put(WSSecurityEngineResult.TAG_SIGNATURE_METHOD, this.signatureMethod);
            result.put(WSSecurityEngineResult.TAG_CANONICALIZATION_METHOD, this.c14nMethod);
            result.put("x509-certificates", this.certificates);
            result.put("decrypted-key", storedKey);
            returnResults.add(0, result);
        }
        this.signatureId = elem.getAttributeNS(null, "Id");
        this.secretKey = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Principal verifyXMLSignature(Element elem, Crypto crypto, X509Certificate[] returnCert, Set returnElements, List protectedElements, byte[][] signatureValue, CallbackHandler cb, WSDocInfo wsDocInfo) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Verify XML Signature");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(elem, null);
        }
        catch (XMLSecurityException e2) {
            throw new WSSecurityException(6, "noXMLSig", null, e2);
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        KeyInfo info = sig.getKeyInfo();
        UsernameToken ut = null;
        DerivedKeyToken dkt = null;
        SAMLKeyInfo samlKi = null;
        String customTokenId = null;
        PublicKey publicKey = null;
        X509Certificate[] certs = null;
        boolean validateCertificateChain = false;
        if (info != null && info.containsKeyValue()) {
            try {
                publicKey = info.getPublicKey();
            }
            catch (Exception ex) {
                throw new WSSecurityException(ex.getMessage(), ex);
            }
        }
        if (info != null) {
            Node node = WSSecurityUtil.getDirectChild(info.getElement(), "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            if (node == null) {
                throw new WSSecurityException(3, "unsupportedKeyInfo");
            }
            SecurityTokenReference secRef = new SecurityTokenReference((Element)node);
            if (secRef.containsReference()) {
                Processor processor;
                org.apache.ws.security.message.token.Reference ref = secRef.getReference();
                String uri = ref.getURI();
                if (uri.charAt(0) == '#') {
                    uri = uri.substring(1);
                }
                if ((processor = wsDocInfo.getProcessor(uri)) == null) {
                    Element token = secRef.getTokenElement(elem.getOwnerDocument(), wsDocInfo, cb);
                    QName el = new QName(token.getNamespaceURI(), token.getLocalName());
                    if (el.equals(WSSecurityEngine.binaryToken)) {
                        certs = this.getCertificatesTokenReference(token, crypto);
                        if (certs != null && certs.length > 1) {
                            validateCertificateChain = true;
                        }
                    } else if (el.equals(WSSecurityEngine.SAML_TOKEN)) {
                        if (crypto == null) {
                            throw new WSSecurityException(0, "noSigCryptoFile");
                        }
                        samlKi = SAMLUtil.getSAMLKeyInfo(token, crypto, cb);
                        certs = samlKi.getCerts();
                        this.secretKey = samlKi.getSecret();
                    } else if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
                        if (crypto == null) {
                            throw new WSSecurityException(0, "noSigCryptoFile");
                        }
                        EncryptedKeyProcessor encryptKeyProcessor = new EncryptedKeyProcessor();
                        encryptKeyProcessor.handleEncryptedKey(token, cb, crypto);
                        this.secretKey = encryptKeyProcessor.getDecryptedBytes();
                    } else {
                        String id = secRef.getReference().getURI();
                        if (id.charAt(0) == '#') {
                            id = id.substring(1);
                        }
                        WSPasswordCallback pwcb = new WSPasswordCallback(id, 7);
                        try {
                            Callback[] callbacks = new Callback[]{pwcb};
                            cb.handle(callbacks);
                        }
                        catch (Exception e) {
                            throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
                        }
                        this.secretKey = pwcb.getKey();
                        customTokenId = id;
                        if (this.secretKey == null) {
                            throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{el.toString()});
                        }
                    }
                } else if (processor instanceof UsernameTokenProcessor) {
                    ut = ((UsernameTokenProcessor)processor).getUt();
                    this.secretKey = ut.isDerivedKey() ? ut.getDerivedKey() : ut.getSecretKey(this.secretKeyLength);
                } else if (processor instanceof BinarySecurityTokenProcessor) {
                    certs = ((BinarySecurityTokenProcessor)processor).getCertificates();
                    if (certs != null && certs.length > 1) {
                        validateCertificateChain = true;
                    }
                } else if (processor instanceof EncryptedKeyProcessor) {
                    EncryptedKeyProcessor ekProcessor = (EncryptedKeyProcessor)processor;
                    this.secretKey = ekProcessor.getDecryptedBytes();
                    customTokenId = ekProcessor.getId();
                } else if (processor instanceof SecurityContextTokenProcessor) {
                    SecurityContextTokenProcessor sctProcessor = (SecurityContextTokenProcessor)processor;
                    this.secretKey = sctProcessor.getSecret();
                    customTokenId = sctProcessor.getIdentifier();
                } else if (processor instanceof DerivedKeyTokenProcessor) {
                    DerivedKeyTokenProcessor dktProcessor = (DerivedKeyTokenProcessor)processor;
                    String signatureMethodURI = sig.getSignedInfo().getSignatureMethodURI();
                    dkt = dktProcessor.getDerivedKeyToken();
                    int keyLength = dkt.getLength() > 0 ? dkt.getLength() : WSSecurityUtil.getKeyLength(signatureMethodURI);
                    this.secretKey = dktProcessor.getKeyBytes(keyLength);
                } else if (processor instanceof SAMLTokenProcessor) {
                    if (crypto == null) {
                        throw new WSSecurityException(0, "noSigCryptoFile");
                    }
                    SAMLTokenProcessor samlp = (SAMLTokenProcessor)processor;
                    samlKi = SAMLUtil.getSAMLKeyInfo(samlp.getSamlTokenElement(), crypto, cb);
                    certs = samlKi.getCerts();
                    this.secretKey = samlKi.getSecret();
                    publicKey = samlKi.getPublicKey();
                }
            } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
                certs = secRef.getX509IssuerSerial(crypto);
            } else {
                if (!secRef.containsKeyIdentifier()) throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{node.toString()});
                if (secRef.getKeyIdentifierValueType().equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1")) {
                    String id = secRef.getKeyIdentifierValue();
                    WSPasswordCallback pwcb = new WSPasswordCallback(id, null, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1", 8);
                    try {
                        Callback[] callbacks = new Callback[]{pwcb};
                        cb.handle(callbacks);
                    }
                    catch (Exception e) {
                        throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
                    }
                    this.secretKey = pwcb.getKey();
                } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType())) {
                    Element token = secRef.getKeyIdentifierTokenElement(elem.getOwnerDocument(), wsDocInfo, cb);
                    if (crypto == null) {
                        throw new WSSecurityException(0, "noSigCryptoFile");
                    }
                    samlKi = SAMLUtil.getSAMLKeyInfo(token, crypto, cb);
                    certs = samlKi.getCerts();
                    this.secretKey = samlKi.getSecret();
                    publicKey = samlKi.getPublicKey();
                } else {
                    certs = secRef.getKeyIdentifier(crypto);
                }
            }
        } else {
            if (crypto == null) {
                throw new WSSecurityException(0, "noSigCryptoFile");
            }
            if (crypto.getDefaultX509Alias() == null) throw new WSSecurityException(3, "unsupportedKeyInfo");
            certs = crypto.getCertificates(crypto.getDefaultX509Alias());
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        if ((certs == null || certs.length == 0 || certs[0] == null) && this.secretKey == null && publicKey == null) {
            throw new WSSecurityException(6);
        }
        if (certs != null) {
            try {
                for (int i = 0; i < certs.length; ++i) {
                    certs[i].checkValidity();
                }
            }
            catch (CertificateExpiredException e) {
                throw new WSSecurityException(6, "invalidCert", null, e);
            }
            catch (CertificateNotYetValidException e) {
                throw new WSSecurityException(6, "invalidCert", null, e);
            }
        }
        if (publicKey != null) {
            PublicKeyCallback pwcb = new PublicKeyCallback(publicKey);
            try {
                Callback[] callbacks = new Callback[]{pwcb};
                cb.handle(callbacks);
                if (!pwcb.isVerified()) {
                    throw new WSSecurityException(5, null, null, null);
                }
            }
            catch (Exception e) {
                throw new WSSecurityException(5, null, null, e);
            }
        }
        try {
            boolean signatureOk = false;
            signatureOk = certs != null ? sig.checkSignatureValue(certs[0]) : (publicKey != null ? sig.checkSignatureValue((Key)publicKey) : sig.checkSignatureValue((Key)sig.createSecretKey(this.secretKey)));
            if (!signatureOk) throw new WSSecurityException(6);
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
                tlog.debug((Object)("Verify: total= " + (t2 - t0) + ", prepare-cert= " + (t1 - t0) + ", verify= " + (t2 - t1)));
            }
            signatureValue[0] = sig.getSignatureValue();
            SignedInfo si = sig.getSignedInfo();
            int numReferences = si.getLength();
            for (int i = 0; i < numReferences; ++i) {
                Reference siRef;
                try {
                    siRef = si.item(i);
                }
                catch (XMLSecurityException e3) {
                    throw new WSSecurityException(6, null, null, e3);
                }
                String uri = siRef.getURI();
                if (uri != null && !"".equals(uri)) {
                    Element se = null;
                    try {
                        Transforms transforms = siRef.getTransforms();
                        for (int j = 0; j < transforms.getLength(); ++j) {
                            Transform transform = transforms.item(j);
                            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(transform.getURI())) continue;
                            XMLSignatureInput signatureInput = siRef.getContentsBeforeTransformation();
                            if (!signatureInput.isElement()) throw new WSSecurityException(0);
                            SecurityTokenReference secTokenRef = new SecurityTokenReference((Element)signatureInput.getSubNode());
                            se = STRTransformUtil.dereferenceSTR(transform.getDocument(), secTokenRef, wsDocInfo);
                        }
                    }
                    catch (XMLSecurityException e) {
                        log.warn((Object)"Error processing signature coverage elements.", (Throwable)e);
                        throw new WSSecurityException(0);
                    }
                    if (se == null) {
                        se = WSSecurityUtil.getElementByWsuId(elem.getOwnerDocument(), uri);
                    }
                    if (se == null) {
                        se = WSSecurityUtil.getElementByGenId(elem.getOwnerDocument(), uri);
                    }
                    if (se == null) {
                        throw new WSSecurityException(6);
                    }
                    WSDataRef ref = new WSDataRef(uri);
                    ref.setWsuId(uri);
                    ref.setName(new QName(se.getNamespaceURI(), se.getLocalName()));
                    ref.setProtectedElement(se);
                    ref.setXpath(ReferenceListProcessor.getXPath(se));
                    ref.setAlgorithm(si.getSignatureMethodURI());
                    ref.setDigestAlgorithm(siRef.getMessageDigestAlgorithm().getAlgorithmURI());
                    protectedElements.add(ref);
                    returnElements.add(WSSecurityUtil.getIDFromReference(uri));
                    continue;
                }
                returnElements.add(siRef);
            }
            this.signatureMethod = si.getSignatureMethodURI();
            this.c14nMethod = si.getCanonicalizationMethodURI();
            if (certs != null) {
                returnCert[0] = certs[0];
                if (!validateCertificateChain) return certs[0].getSubjectX500Principal();
                this.certificates = certs;
                return certs[0].getSubjectX500Principal();
            }
            if (publicKey != null) {
                return new PublicKeyPrincipal(publicKey);
            }
            if (ut != null) {
                WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(ut.getName(), ut.isHashed());
                principal.setNonce(ut.getNonce());
                principal.setPassword(ut.getPassword());
                principal.setCreatedTime(ut.getCreated());
                return principal;
            }
            if (dkt != null) {
                WSDerivedKeyTokenPrincipal principal = new WSDerivedKeyTokenPrincipal(dkt.getID());
                principal.setNonce(dkt.getNonce());
                principal.setLabel(dkt.getLabel());
                principal.setLength(dkt.getLength());
                principal.setOffset(dkt.getOffset());
                String basetokenId = null;
                SecurityTokenReference securityTokenReference = dkt.getSecurityTokenReference();
                if (securityTokenReference.containsReference()) {
                    basetokenId = securityTokenReference.getReference().getURI();
                    if (basetokenId.charAt(0) == '#') {
                        basetokenId = basetokenId.substring(1);
                    }
                } else {
                    basetokenId = securityTokenReference.getKeyIdentifierValue();
                }
                principal.setBasetokenId(basetokenId);
                return principal;
            }
            if (samlKi != null) {
                SAMLAssertion assertion = samlKi.getAssertion();
                CustomTokenPrincipal principal = new CustomTokenPrincipal(assertion.getId());
                principal.setTokenObject(assertion);
                return principal;
            }
            if (this.secretKey == null) throw new WSSecurityException("Cannot determine principal");
            return new CustomTokenPrincipal(customTokenId);
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(6, null, null, e1);
        }
    }

    public X509Certificate[] getCertificatesTokenReference(Element elem, Crypto crypto) throws WSSecurityException {
        if (crypto == null) {
            throw new WSSecurityException(0, "noSigCryptoFile");
        }
        BinarySecurity token = this.createSecurityToken(elem);
        if (token instanceof PKIPathSecurity) {
            return ((PKIPathSecurity)token).getX509Certificates(false, crypto);
        }
        if (token instanceof X509Security) {
            X509Certificate cert = ((X509Security)token).getX509Certificate(crypto);
            return new X509Certificate[]{cert};
        }
        return null;
    }

    private BinarySecurity createSecurityToken(Element element) throws WSSecurityException {
        String type = element.getAttribute("ValueType");
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(type)) {
            X509Security x509 = new X509Security(element);
            return x509;
        }
        if (PKIPathSecurity.getType().equals(type)) {
            PKIPathSecurity pkiPath = new PKIPathSecurity(element);
            return pkiPath;
        }
        throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{type});
    }

    public String getId() {
        return this.signatureId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

