/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.injection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.collections.ClassMetaCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Injector {
    private static final Field[] EMPTY_FIELDS = new Field[0];
    private static Injector instance = new Injector();
    private final ClassMetaCache<Field[]> cache = new ClassMetaCache();

    public static Injector getInstance() {
        return instance;
    }

    protected boolean isBoundaryClass(Class<?> clazz) {
        return clazz.equals(WebPage.class) || clazz.equals(Page.class) || clazz.equals(Panel.class) || clazz.equals(MarkupContainer.class) || clazz.equals(Component.class);
    }

    public Object inject(Object object, IFieldValueFactory factory) {
        Class<?> clazz = object.getClass();
        Field[] fields = this.getFields(clazz, factory);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                Object value;
                if (field.get(object) != null || (value = factory.getFieldValue(field, object)) == null) continue;
                field.set(object, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("error while injecting object [" + object.toString() + "] of type [" + object.getClass().getName() + "]", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("error while injecting object [" + object.toString() + "] of type [" + object.getClass().getName() + "]", e);
            }
        }
        return object;
    }

    private Field[] getFields(Class<?> clazz, IFieldValueFactory factory) {
        Field[] fields = (Field[])this.cache.get(clazz);
        if (fields == null) {
            fields = this.findFields(clazz, factory);
            this.cache.put(clazz, (Object)fields);
        }
        return fields;
    }

    private Field[] findFields(Class<?> clazz, IFieldValueFactory factory) {
        ArrayList<Field> matched = new ArrayList<Field>();
        while (clazz != null && !this.isBoundaryClass(clazz)) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!factory.supportsField(field)) continue;
                matched.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return matched.size() == 0 ? EMPTY_FIELDS : matched.toArray(new Field[matched.size()]);
    }
}

