/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.pathtracking;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.reporting.web.plugin.api.MapBuilder;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.report.format.HTMLFormat;
import org.apache.sirona.store.tracking.PathTrackingDataStore;
import org.apache.sirona.tracking.PathCallInformation;
import org.apache.sirona.util.Environment;

public class PathTrackingEndpoints {
    private static final PathTrackingDataStore PATH_TRACKING_DATA_STORE = (PathTrackingDataStore)IoCs.findOrCreateInstance(PathTrackingDataStore.class);

    @Regex
    public Template home() {
        HashMap<String, Collection> params = new HashMap<String, Collection>();
        if (!Environment.isCollector()) {
            // empty if block
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Collection pathCallInformations = PATH_TRACKING_DATA_STORE.retrieveTrackingIds(cal.getTime(), new Date());
        params.put("pathCallInformations", pathCallInformations);
        return new Template("pathtracking/home.vm", params);
    }

    @Regex(value="/startend/([0-9]*)/([0-9]*)")
    public String startend(long start, long end) {
        Collection entries = PATH_TRACKING_DATA_STORE.retrieveTrackingIds(new Date(start), new Date(end));
        MapBuilder mapBuilder = new MapBuilder();
        for (PathCallInformation entry : entries) {
            mapBuilder = mapBuilder.set(new MapBuilder().set((Object)"trackingId", (Object)entry.getTrackingId()).set((Object)"startTime", (Object)Long.toString(entry.getStartTime().getTime())).build());
        }
        return PathTrackingEndpoints.toJson(mapBuilder.build());
    }

    @Regex(value="/pathtrackingdetail/(.*)")
    public Template displayPathTrackingDetail(String pathTrackingId) {
        Collection entries = PATH_TRACKING_DATA_STORE.retrieve(pathTrackingId);
        return new Template("pathtracking/pathtrackingdetail.vm", new MapBuilder().set((Object)"headers", (Object)HTMLFormat.ATTRIBUTES_ORDERED_LIST).set((Object)"entries", (Object)entries).build());
    }

    static String toJson(Map<String, String> data) {
        StringBuilder builder = new StringBuilder().append("[");
        Iterator<Map.Entry<String, String>> iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            builder.append("[").append(entry.getKey().toString()).append(", ").append(entry.getValue().toString()).append("]");
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append("]").toString();
    }
}

