/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.commons.codec.binary.Base64;
import org.apache.sirona.SironaException;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.reporting.web.handler.TemplateHelper;
import org.apache.sirona.reporting.web.plugin.api.MapBuilder;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.jmx.JMXNode;
import org.apache.sirona.util.ClassLoaders;

public class JMXEndpoints {
    private static final boolean METHOD_INVOCATION_ALLOWED = Configuration.is((String)"org.apache.sirona.jmx.method.allowed", (boolean)true);
    private static final Map<String, Class<?>> WRAPPERS = new HashMap();
    protected final MBeanServerConnection server = ManagementFactory.getPlatformMBeanServer();

    @Regex(value="")
    public Template home() throws IOException {
        return new Template("jmx/main.vm", new MapBuilder().set((Object)"jmxTree", (Object)this.buildJmxTree()).build());
    }

    @Regex(value="/operation/([^/]*)/([^/]*)/(.*)")
    public String invokeOperation(String objectNameBase64, String method, String[] parameters) {
        if (!METHOD_INVOCATION_ALLOWED) {
            throw new SironaException("Method invocation not allowed");
        }
        try {
            ObjectName name = new ObjectName(new String(Base64.decodeBase64((String)objectNameBase64)));
            MBeanInfo info = this.server.getMBeanInfo(name);
            for (MBeanOperationInfo op : info.getOperations()) {
                if (!op.getName().equals(method)) continue;
                MBeanParameterInfo[] signature = op.getSignature();
                String[] sign = new String[signature.length];
                for (int i = 0; i < sign.length; ++i) {
                    sign[i] = signature[i].getType();
                }
                Object result = this.server.invoke(name, method, this.convertParams(signature, parameters), sign);
                return "<div>Method was invoked and returned:</div>" + JMXEndpoints.value(result);
            }
        }
        catch (Exception e) {
            return "<div class=\"alert alert-error\">\n\n" + e.getMessage() + "\n" + "</div>";
        }
        return "<div class=\"alert alert-error\">Operation" + method + " not found.</div>";
    }

    @Regex(value="/([^/]*)")
    public Template mbean(String objectNameBase64) {
        try {
            ObjectName name = new ObjectName(new String(Base64.decodeBase64((String)objectNameBase64)));
            MBeanInfo info = this.server.getMBeanInfo(name);
            return new Template("templates/jmx/mbean.vm", new MapBuilder().set((Object)"objectname", (Object)name.toString()).set((Object)"objectnameHash", (Object)Base64.encodeBase64URLSafeString((byte[])name.toString().getBytes())).set((Object)"classname", (Object)info.getClassName()).set((Object)"description", (Object)JMXEndpoints.value(info.getDescription())).set((Object)"attributes", this.attributes(name, info)).set((Object)"operations", this.operations(info)).build(), false);
        }
        catch (Exception e) {
            throw new SironaException((Throwable)e);
        }
    }

    private JMXNode buildJmxTree() throws IOException {
        JMXNode root = new JMXNode("/");
        for (ObjectInstance instance : this.server.queryMBeans(null, null)) {
            ObjectName objectName = instance.getObjectName();
            JMXNode.addNode(root, objectName.getDomain(), objectName.getKeyPropertyListString());
        }
        return root;
    }

    private Object[] convertParams(MBeanParameterInfo[] signature, String[] params) {
        if (params == null) {
            return null;
        }
        Object[] convertedParams = new Object[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            convertedParams[i] = i < params.length ? JMXEndpoints.convert(signature[i].getType(), params[i]) : null;
        }
        return convertedParams;
    }

    public static Object convert(String type, String value) {
        try {
            if (WRAPPERS.containsKey(type)) {
                if (type.equals(Character.TYPE.getName())) {
                    return Character.valueOf(value.charAt(0));
                }
                return JMXEndpoints.tryStringConstructor(WRAPPERS.get(type).getName(), value);
            }
            if (type.equals(Character.class.getName())) {
                return Character.valueOf(value.charAt(0));
            }
            if (Number.class.isAssignableFrom(ClassLoaders.current().loadClass(type))) {
                return JMXEndpoints.toNumber(value);
            }
            if (value == null || value.equals("null")) {
                return null;
            }
            return JMXEndpoints.tryStringConstructor(type, value);
        }
        catch (Exception e) {
            throw new SironaException((Throwable)e);
        }
    }

    private static Number toNumber(String value) throws NumberFormatException {
        char lastChar = Character.toLowerCase(value.charAt(value.length() - 1));
        if (lastChar == 'd') {
            return Double.valueOf(value.substring(0, value.length() - 1));
        }
        if (lastChar == 'l') {
            return Long.valueOf(value.substring(0, value.length() - 1));
        }
        if (lastChar == 'f') {
            return Float.valueOf(value.substring(0, value.length() - 1));
        }
        for (Class clazz : new Class[]{Integer.class, Long.class, Double.class}) {
            try {
                return (Number)Number.class.cast(clazz.getMethod("valueOf", new Class[0]).invoke(null, value));
            }
            catch (Exception e) {
            }
        }
        throw new SironaException(value + " is not a number");
    }

    private static Object tryStringConstructor(String type, String value) throws Exception {
        return ClassLoaders.current().loadClass(type).getConstructor(String.class).newInstance(value);
    }

    private Collection<MBeanOperation> operations(MBeanInfo info) {
        LinkedList<MBeanOperation> operations = new LinkedList<MBeanOperation>();
        for (MBeanOperationInfo operationInfo : info.getOperations()) {
            MBeanOperation mBeanOperation = new MBeanOperation(operationInfo.getName(), operationInfo.getReturnType());
            for (MBeanParameterInfo param : operationInfo.getSignature()) {
                mBeanOperation.getParameters().add(new MBeanParameter(param.getName(), param.getType()));
            }
            operations.add(mBeanOperation);
        }
        return operations;
    }

    private Collection<MBeanAttribute> attributes(ObjectName name, MBeanInfo info) {
        LinkedList<MBeanAttribute> list = new LinkedList<MBeanAttribute>();
        for (MBeanAttributeInfo attribute : info.getAttributes()) {
            Object value;
            try {
                value = this.server.getAttribute(name, attribute.getName());
            }
            catch (Exception e) {
                value = "<div class=\"alert-error\">" + e.getMessage() + "</div>";
            }
            list.add(new MBeanAttribute(attribute.getName(), TemplateHelper.nullProtection(attribute.getType()), TemplateHelper.nullProtection(attribute.getDescription()), JMXEndpoints.value(value)));
        }
        return list;
    }

    private static String value(Object value) {
        try {
            if (value == null) {
                return TemplateHelper.nullProtection(null);
            }
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                if (length == 0) {
                    return "";
                }
                StringBuilder builder = new StringBuilder().append("<ul>");
                for (int i = 0; i < length; ++i) {
                    builder.append("<li>").append(JMXEndpoints.value(Array.get(value, i))).append("</li>");
                }
                builder.append("</ul>");
                return builder.toString();
            }
            if (Collection.class.isInstance(value)) {
                StringBuilder builder = new StringBuilder().append("<ul>");
                for (Object o : (Collection)Collection.class.cast(value)) {
                    builder.append("<li>").append(JMXEndpoints.value(o)).append("</li>");
                }
                builder.append("</ul>");
                return builder.toString();
            }
            if (TabularData.class.isInstance(value)) {
                TabularData td = (TabularData)TabularData.class.cast(value);
                StringBuilder builder = new StringBuilder().append("<table class=\"table table-condensed\">");
                for (Object type : td.keySet()) {
                    List values = (List)type;
                    CompositeData data = td.get(values.toArray(new Object[values.size()]));
                    builder.append("<tr>");
                    Set<String> dataKeys = data.getCompositeType().keySet();
                    for (String k : data.getCompositeType().keySet()) {
                        builder.append("<td>").append(JMXEndpoints.value(data.get(k))).append("</td>");
                    }
                    builder.append("</tr>");
                }
                builder.append("</table>");
                return builder.toString();
            }
            if (CompositeData.class.isInstance(value)) {
                CompositeData cd = (CompositeData)CompositeData.class.cast(value);
                Set<String> keys = cd.getCompositeType().keySet();
                StringBuilder builder = new StringBuilder().append("<table class=\"table table-condensed\">");
                for (String type : keys) {
                    builder.append("<tr><td>").append(type).append("</td><td>").append(JMXEndpoints.value(cd.get(type))).append("</td></tr>");
                }
                builder.append("</table>");
                return builder.toString();
            }
            if (Map.class.isInstance(value)) {
                Map map = (Map)Map.class.cast(value);
                StringBuilder builder = new StringBuilder().append("<table class=\"table table-condensed\">");
                for (Map.Entry entry : map.entrySet()) {
                    builder.append("<tr><tr>").append(JMXEndpoints.value(entry.getKey())).append("</td><td>").append(JMXEndpoints.value(entry.getValue())).append("</td></tr>");
                }
                builder.append("</table>");
                return builder.toString();
            }
            return value.toString();
        }
        catch (Exception e) {
            throw new SironaException((Throwable)e);
        }
    }

    static {
        for (Class c : Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class)) {
            try {
                Field f = c.getField("TYPE");
                Class p = (Class)f.get(null);
                WRAPPERS.put(p.getName(), c);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static class MBeanParameter {
        private final String name;
        private final String type;

        public MBeanParameter(String name, String type) {
            this.name = name;
            this.type = type.replace("java.lang.", "");
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class MBeanOperation {
        private final String name;
        private final String returnType;
        private final Collection<MBeanParameter> parameters = new LinkedList<MBeanParameter>();

        public MBeanOperation(String name, String returnType) {
            this.name = name;
            this.returnType = returnType;
        }

        public String getName() {
            return this.name;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public Collection<MBeanParameter> getParameters() {
            return this.parameters;
        }
    }

    public static class MBeanAttribute {
        private final String name;
        private final String type;
        private final String description;
        private final String value;

        public MBeanAttribute(String name, String type, String description, String value) {
            this.name = name;
            this.type = type;
            this.value = value;
            this.description = description != null ? description : "No description";
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getValue() {
            return this.value;
        }
    }
}

