/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.merge.impl;

import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.core.rule.BaseRule;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetas;
import org.apache.shardingsphere.sql.parser.relation.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.execute.QueryResult;
import org.apache.shardingsphere.underlying.merge.MergedResult;
import org.apache.shardingsphere.underlying.merge.impl.MemoryQueryResultRow;

public abstract class MemoryMergedResult<T extends BaseRule>
implements MergedResult {
    private final Iterator<MemoryQueryResultRow> memoryResultSetRows;
    private MemoryQueryResultRow currentResultSetRow;
    private boolean wasNull;

    protected MemoryMergedResult(T rule, RelationMetas relationMetas, SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        List<MemoryQueryResultRow> memoryQueryResultRowList = this.init(rule, relationMetas, sqlStatementContext, queryResults);
        this.memoryResultSetRows = memoryQueryResultRowList.iterator();
        if (!memoryQueryResultRowList.isEmpty()) {
            this.currentResultSetRow = memoryQueryResultRowList.get(0);
        }
    }

    protected abstract List<MemoryQueryResultRow> init(T var1, RelationMetas var2, SQLStatementContext var3, List<QueryResult> var4) throws SQLException;

    @Override
    public final boolean next() {
        if (this.memoryResultSetRows.hasNext()) {
            this.currentResultSetRow = this.memoryResultSetRows.next();
            return true;
        }
        return false;
    }

    @Override
    public final Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException();
        }
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final boolean wasNull() {
        return this.wasNull;
    }

    @ConstructorProperties(value={"memoryResultSetRows"})
    public MemoryMergedResult(Iterator<MemoryQueryResultRow> memoryResultSetRows) {
        this.memoryResultSetRows = memoryResultSetRows;
    }
}

