/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.base.seata.at;

import io.seata.core.context.RootContext;
import java.util.Map;
import org.apache.shardingsphere.core.execute.ShardingExecuteDataMap;

class SeataTransactionBroadcaster {
    private static final String SEATA_TX_XID = "SEATA_TX_XID";

    SeataTransactionBroadcaster() {
    }

    static void collectGlobalTxId() {
        if (RootContext.inGlobalTransaction()) {
            ShardingExecuteDataMap.getDataMap().put(SEATA_TX_XID, RootContext.getXID());
        }
    }

    static void broadcastIfNecessary(Map<String, Object> shardingExecuteDataMap) {
        if (shardingExecuteDataMap.containsKey(SEATA_TX_XID) && !RootContext.inGlobalTransaction()) {
            RootContext.bind((String)((String)shardingExecuteDataMap.get(SEATA_TX_XID)));
        }
    }

    static void clear() {
        ShardingExecuteDataMap.getDataMap().remove(SEATA_TX_XID);
    }
}

