/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.filter;

import java.util.Collection;
import java.util.Iterator;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filter.MessageEvaluationContext;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.filter.expression.EvaluationContext;
import org.apache.rocketmq.filter.util.BitsArray;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.DispatchRequest;

public class CommitLogDispatcherCalcBitMap
implements CommitLogDispatcher {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqFilter");
    protected final BrokerConfig brokerConfig;
    protected final ConsumerFilterManager consumerFilterManager;

    public CommitLogDispatcherCalcBitMap(BrokerConfig brokerConfig, ConsumerFilterManager consumerFilterManager) {
        this.brokerConfig = brokerConfig;
        this.consumerFilterManager = consumerFilterManager;
    }

    public void dispatch(DispatchRequest request) {
        if (!this.brokerConfig.isEnableCalcFilterBitMap()) {
            return;
        }
        try {
            Collection<ConsumerFilterData> filterDatas = this.consumerFilterManager.get(request.getTopic());
            if (filterDatas == null || filterDatas.isEmpty()) {
                return;
            }
            Iterator<ConsumerFilterData> iterator = filterDatas.iterator();
            BitsArray filterBitMap = BitsArray.create((int)this.consumerFilterManager.getBloomFilter().getM());
            long startTime = System.currentTimeMillis();
            while (iterator.hasNext()) {
                ConsumerFilterData filterData = iterator.next();
                if (filterData.getCompiledExpression() == null) {
                    log.error("[BUG] Consumer in filter manager has no compiled expression! {}", (Object)filterData);
                    continue;
                }
                if (filterData.getBloomFilterData() == null) {
                    log.error("[BUG] Consumer in filter manager has no bloom data! {}", (Object)filterData);
                    continue;
                }
                Object ret = null;
                try {
                    MessageEvaluationContext context = new MessageEvaluationContext(request.getPropertiesMap());
                    ret = filterData.getCompiledExpression().evaluate((EvaluationContext)context);
                }
                catch (Throwable e) {
                    log.error("Calc filter bit map error!commitLogOffset={}, consumer={}, {}", new Object[]{request.getCommitLogOffset(), filterData, e});
                }
                log.debug("Result of Calc bit map:ret={}, data={}, props={}, offset={}", new Object[]{ret, filterData, request.getPropertiesMap(), request.getCommitLogOffset()});
                if (ret == null || !(ret instanceof Boolean) || !((Boolean)ret).booleanValue()) continue;
                this.consumerFilterManager.getBloomFilter().hashTo(filterData.getBloomFilterData(), filterBitMap);
            }
            request.setBitMap(filterBitMap.bytes());
            long eclipseTime = System.currentTimeMillis() - startTime;
            if (eclipseTime >= 1L) {
                log.warn("Spend {} ms to calc bit map, consumerNum={}, topic={}", new Object[]{eclipseTime, filterDatas.size(), request.getTopic()});
            }
        }
        catch (Throwable e) {
            log.error("Calc bit map error! topic={}, offset={}, queueId={}, {}", new Object[]{request.getTopic(), request.getCommitLogOffset(), request.getQueueId(), e});
        }
    }
}

