/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.client.ClientHousekeepingService;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ConsumerManager;
import org.apache.rocketmq.broker.client.DefaultConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ProducerManager;
import org.apache.rocketmq.broker.client.net.Broker2Client;
import org.apache.rocketmq.broker.client.rebalance.RebalanceLockManager;
import org.apache.rocketmq.broker.filter.CommitLogDispatcherCalcBitMap;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filtersrv.FilterServerManager;
import org.apache.rocketmq.broker.latency.BrokerFastFailure;
import org.apache.rocketmq.broker.latency.BrokerFixedThreadPoolExecutor;
import org.apache.rocketmq.broker.longpolling.NotifyMessageArrivingListener;
import org.apache.rocketmq.broker.longpolling.PullRequestHoldService;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageHook;
import org.apache.rocketmq.broker.mqtrace.SendMessageHook;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.broker.out.BrokerOuterAPI;
import org.apache.rocketmq.broker.plugin.MessageStoreFactory;
import org.apache.rocketmq.broker.plugin.MessageStorePluginContext;
import org.apache.rocketmq.broker.processor.AdminBrokerProcessor;
import org.apache.rocketmq.broker.processor.ClientManageProcessor;
import org.apache.rocketmq.broker.processor.ConsumerManageProcessor;
import org.apache.rocketmq.broker.processor.EndTransactionProcessor;
import org.apache.rocketmq.broker.processor.PullMessageProcessor;
import org.apache.rocketmq.broker.processor.QueryMessageProcessor;
import org.apache.rocketmq.broker.processor.SendMessageProcessor;
import org.apache.rocketmq.broker.slave.SlaveSynchronize;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.broker.topic.TopicConfigManager;
import org.apache.rocketmq.broker.transaction.AbstractTransactionalMessageCheckListener;
import org.apache.rocketmq.broker.transaction.TransactionalMessageCheckService;
import org.apache.rocketmq.broker.transaction.TransactionalMessageService;
import org.apache.rocketmq.broker.transaction.queue.DefaultTransactionalMessageCheckListener;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageBridge;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageServiceImpl;
import org.apache.rocketmq.broker.util.ServiceProvider;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.Configuration;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.stats.MomentStatsItem;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingServer;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.FileWatchService;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageArrivingListener;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.stats.BrokerStats;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class BrokerController {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final InternalLogger LOG_PROTECTION = InternalLoggerFactory.getLogger((String)"RocketmqProtection");
    private static final InternalLogger LOG_WATER_MARK = InternalLoggerFactory.getLogger((String)"RocketmqWaterMark");
    private final BrokerConfig brokerConfig;
    private final NettyServerConfig nettyServerConfig;
    private final NettyClientConfig nettyClientConfig;
    private final MessageStoreConfig messageStoreConfig;
    private final ConsumerOffsetManager consumerOffsetManager;
    private final ConsumerManager consumerManager;
    private final ConsumerFilterManager consumerFilterManager;
    private final ProducerManager producerManager;
    private final ClientHousekeepingService clientHousekeepingService;
    private final PullMessageProcessor pullMessageProcessor;
    private final PullRequestHoldService pullRequestHoldService;
    private final MessageArrivingListener messageArrivingListener;
    private final Broker2Client broker2Client;
    private final SubscriptionGroupManager subscriptionGroupManager;
    private final ConsumerIdsChangeListener consumerIdsChangeListener;
    private final RebalanceLockManager rebalanceLockManager = new RebalanceLockManager();
    private final BrokerOuterAPI brokerOuterAPI;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("BrokerControllerScheduledThread"));
    private final SlaveSynchronize slaveSynchronize;
    private final BlockingQueue<Runnable> sendThreadPoolQueue;
    private final BlockingQueue<Runnable> pullThreadPoolQueue;
    private final BlockingQueue<Runnable> queryThreadPoolQueue;
    private final BlockingQueue<Runnable> clientManagerThreadPoolQueue;
    private final BlockingQueue<Runnable> heartbeatThreadPoolQueue;
    private final BlockingQueue<Runnable> consumerManagerThreadPoolQueue;
    private final BlockingQueue<Runnable> endTransactionThreadPoolQueue;
    private final FilterServerManager filterServerManager;
    private final BrokerStatsManager brokerStatsManager;
    private final List<SendMessageHook> sendMessageHookList = new ArrayList<SendMessageHook>();
    private final List<ConsumeMessageHook> consumeMessageHookList = new ArrayList<ConsumeMessageHook>();
    private MessageStore messageStore;
    private RemotingServer remotingServer;
    private RemotingServer fastRemotingServer;
    private TopicConfigManager topicConfigManager;
    private ExecutorService sendMessageExecutor;
    private ExecutorService pullMessageExecutor;
    private ExecutorService queryMessageExecutor;
    private ExecutorService adminBrokerExecutor;
    private ExecutorService clientManageExecutor;
    private ExecutorService heartbeatExecutor;
    private ExecutorService consumerManageExecutor;
    private ExecutorService endTransactionExecutor;
    private boolean updateMasterHAServerAddrPeriodically = false;
    private BrokerStats brokerStats;
    private InetSocketAddress storeHost;
    private BrokerFastFailure brokerFastFailure;
    private Configuration configuration;
    private FileWatchService fileWatchService;
    private TransactionalMessageCheckService transactionalMessageCheckService;
    private TransactionalMessageService transactionalMessageService;
    private AbstractTransactionalMessageCheckListener transactionalMessageCheckListener;

    public BrokerController(BrokerConfig brokerConfig, NettyServerConfig nettyServerConfig, NettyClientConfig nettyClientConfig, MessageStoreConfig messageStoreConfig) {
        this.brokerConfig = brokerConfig;
        this.nettyServerConfig = nettyServerConfig;
        this.nettyClientConfig = nettyClientConfig;
        this.messageStoreConfig = messageStoreConfig;
        this.consumerOffsetManager = new ConsumerOffsetManager(this);
        this.topicConfigManager = new TopicConfigManager(this);
        this.pullMessageProcessor = new PullMessageProcessor(this);
        this.pullRequestHoldService = new PullRequestHoldService(this);
        this.messageArrivingListener = new NotifyMessageArrivingListener(this.pullRequestHoldService);
        this.consumerIdsChangeListener = new DefaultConsumerIdsChangeListener(this);
        this.consumerManager = new ConsumerManager(this.consumerIdsChangeListener);
        this.consumerFilterManager = new ConsumerFilterManager(this);
        this.producerManager = new ProducerManager();
        this.clientHousekeepingService = new ClientHousekeepingService(this);
        this.broker2Client = new Broker2Client(this);
        this.subscriptionGroupManager = new SubscriptionGroupManager(this);
        this.brokerOuterAPI = new BrokerOuterAPI(nettyClientConfig);
        this.filterServerManager = new FilterServerManager(this);
        this.slaveSynchronize = new SlaveSynchronize(this);
        this.sendThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getSendThreadPoolQueueCapacity());
        this.pullThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getPullThreadPoolQueueCapacity());
        this.queryThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getQueryThreadPoolQueueCapacity());
        this.clientManagerThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getClientManagerThreadPoolQueueCapacity());
        this.consumerManagerThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getConsumerManagerThreadPoolQueueCapacity());
        this.heartbeatThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getHeartbeatThreadPoolQueueCapacity());
        this.endTransactionThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getEndTransactionPoolQueueCapacity());
        this.brokerStatsManager = new BrokerStatsManager(this.brokerConfig.getBrokerClusterName());
        this.setStoreHost(new InetSocketAddress(this.getBrokerConfig().getBrokerIP1(), this.getNettyServerConfig().getListenPort()));
        this.brokerFastFailure = new BrokerFastFailure(this);
        this.configuration = new Configuration(log, BrokerPathConfigHelper.getBrokerConfigPath(), new Object[]{this.brokerConfig, this.nettyServerConfig, this.nettyClientConfig, this.messageStoreConfig});
    }

    public BrokerConfig getBrokerConfig() {
        return this.brokerConfig;
    }

    public NettyServerConfig getNettyServerConfig() {
        return this.nettyServerConfig;
    }

    public BlockingQueue<Runnable> getPullThreadPoolQueue() {
        return this.pullThreadPoolQueue;
    }

    public BlockingQueue<Runnable> getQueryThreadPoolQueue() {
        return this.queryThreadPoolQueue;
    }

    public boolean initialize() throws CloneNotSupportedException {
        boolean result = this.topicConfigManager.load();
        result = result && this.consumerOffsetManager.load();
        result = result && this.subscriptionGroupManager.load();
        boolean bl = result = result && this.consumerFilterManager.load();
        if (result) {
            try {
                this.messageStore = new DefaultMessageStore(this.messageStoreConfig, this.brokerStatsManager, this.messageArrivingListener, this.brokerConfig);
                this.brokerStats = new BrokerStats((DefaultMessageStore)this.messageStore);
                MessageStorePluginContext context = new MessageStorePluginContext(this.messageStoreConfig, this.brokerStatsManager, this.messageArrivingListener, this.brokerConfig);
                this.messageStore = MessageStoreFactory.build(context, this.messageStore);
                this.messageStore.getDispatcherList().addFirst(new CommitLogDispatcherCalcBitMap(this.brokerConfig, this.consumerFilterManager));
            }
            catch (IOException e) {
                result = false;
                log.error("Failed to initialize", (Throwable)e);
            }
        }
        boolean bl2 = result = result && this.messageStore.load();
        if (result) {
            this.remotingServer = new NettyRemotingServer(this.nettyServerConfig, (ChannelEventListener)this.clientHousekeepingService);
            NettyServerConfig fastConfig = (NettyServerConfig)this.nettyServerConfig.clone();
            fastConfig.setListenPort(this.nettyServerConfig.getListenPort() - 2);
            this.fastRemotingServer = new NettyRemotingServer(fastConfig, (ChannelEventListener)this.clientHousekeepingService);
            this.sendMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getSendMessageThreadPoolNums(), this.brokerConfig.getSendMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.sendThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("SendMessageThread_"));
            this.pullMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getPullMessageThreadPoolNums(), this.brokerConfig.getPullMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.pullThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("PullMessageThread_"));
            this.queryMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getQueryMessageThreadPoolNums(), this.brokerConfig.getQueryMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.queryThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("QueryMessageThread_"));
            this.adminBrokerExecutor = Executors.newFixedThreadPool(this.brokerConfig.getAdminBrokerThreadPoolNums(), (ThreadFactory)new ThreadFactoryImpl("AdminBrokerThread_"));
            this.clientManageExecutor = new ThreadPoolExecutor(this.brokerConfig.getClientManageThreadPoolNums(), this.brokerConfig.getClientManageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.clientManagerThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("ClientManageThread_"));
            this.heartbeatExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getHeartbeatThreadPoolNums(), this.brokerConfig.getHeartbeatThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.heartbeatThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("HeartbeatThread_", true));
            this.endTransactionExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getEndTransactionThreadPoolNums(), this.brokerConfig.getEndTransactionThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.endTransactionThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("EndTransactionThread_"));
            this.consumerManageExecutor = Executors.newFixedThreadPool(this.brokerConfig.getConsumerManageThreadPoolNums(), (ThreadFactory)new ThreadFactoryImpl("ConsumerManageThread_"));
            this.registerProcessor();
            long initialDelay = UtilAll.computNextMorningTimeMillis() - System.currentTimeMillis();
            long period = 86400000L;
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.getBrokerStats().record();
                    }
                    catch (Throwable e) {
                        log.error("schedule record error.", e);
                    }
                }
            }, initialDelay, 86400000L, TimeUnit.MILLISECONDS);
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.consumerOffsetManager.persist();
                    }
                    catch (Throwable e) {
                        log.error("schedule persist consumerOffset error.", e);
                    }
                }
            }, 10000L, this.brokerConfig.getFlushConsumerOffsetInterval(), TimeUnit.MILLISECONDS);
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.consumerFilterManager.persist();
                    }
                    catch (Throwable e) {
                        log.error("schedule persist consumer filter error.", e);
                    }
                }
            }, 10000L, 10000L, TimeUnit.MILLISECONDS);
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.protectBroker();
                    }
                    catch (Throwable e) {
                        log.error("protectBroker error.", e);
                    }
                }
            }, 3L, 3L, TimeUnit.MINUTES);
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.printWaterMark();
                    }
                    catch (Throwable e) {
                        log.error("printWaterMark error.", e);
                    }
                }
            }, 10L, 1L, TimeUnit.SECONDS);
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        log.info("dispatch behind commit log {} bytes", (Object)BrokerController.this.getMessageStore().dispatchBehindBytes());
                    }
                    catch (Throwable e) {
                        log.error("schedule dispatchBehindBytes error.", e);
                    }
                }
            }, 10000L, 60000L, TimeUnit.MILLISECONDS);
            if (this.brokerConfig.getNamesrvAddr() != null) {
                this.brokerOuterAPI.updateNameServerAddressList(this.brokerConfig.getNamesrvAddr());
                log.info("Set user specified name server address: {}", (Object)this.brokerConfig.getNamesrvAddr());
            } else if (this.brokerConfig.isFetchNamesrvAddrByAddressServer()) {
                this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BrokerController.this.brokerOuterAPI.fetchNameServerAddr();
                        }
                        catch (Throwable e) {
                            log.error("ScheduledTask fetchNameServerAddr exception", e);
                        }
                    }
                }, 10000L, 120000L, TimeUnit.MILLISECONDS);
            }
            if (BrokerRole.SLAVE == this.messageStoreConfig.getBrokerRole()) {
                if (this.messageStoreConfig.getHaMasterAddress() != null && this.messageStoreConfig.getHaMasterAddress().length() >= 6) {
                    this.messageStore.updateHaMasterAddress(this.messageStoreConfig.getHaMasterAddress());
                    this.updateMasterHAServerAddrPeriodically = false;
                } else {
                    this.updateMasterHAServerAddrPeriodically = true;
                }
                this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BrokerController.this.slaveSynchronize.syncAll();
                        }
                        catch (Throwable e) {
                            log.error("ScheduledTask syncAll slave exception", e);
                        }
                    }
                }, 10000L, 60000L, TimeUnit.MILLISECONDS);
            } else {
                this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BrokerController.this.printMasterAndSlaveDiff();
                        }
                        catch (Throwable e) {
                            log.error("schedule printMasterAndSlaveDiff error.", e);
                        }
                    }
                }, 10000L, 60000L, TimeUnit.MILLISECONDS);
            }
            if (TlsSystemConfig.tlsMode != TlsMode.DISABLED) {
                try {
                    this.fileWatchService = new FileWatchService(new String[]{TlsSystemConfig.tlsServerCertPath, TlsSystemConfig.tlsServerKeyPath, TlsSystemConfig.tlsServerTrustCertPath}, new FileWatchService.Listener(){
                        boolean certChanged;
                        boolean keyChanged = false;

                        public void onChanged(String path) {
                            if (path.equals(TlsSystemConfig.tlsServerTrustCertPath)) {
                                log.info("The trust certificate changed, reload the ssl context");
                                this.reloadServerSslContext();
                            }
                            if (path.equals(TlsSystemConfig.tlsServerCertPath)) {
                                this.certChanged = true;
                            }
                            if (path.equals(TlsSystemConfig.tlsServerKeyPath)) {
                                this.keyChanged = true;
                            }
                            if (this.certChanged && this.keyChanged) {
                                log.info("The certificate and private key changed, reload the ssl context");
                                this.keyChanged = false;
                                this.certChanged = false;
                                this.reloadServerSslContext();
                            }
                        }

                        private void reloadServerSslContext() {
                            ((NettyRemotingServer)BrokerController.this.remotingServer).loadSslContext();
                            ((NettyRemotingServer)BrokerController.this.fastRemotingServer).loadSslContext();
                        }
                    });
                }
                catch (Exception e) {
                    log.warn("FileWatchService created error, can't load the certificate dynamically");
                }
            }
            this.initialTransaction();
            this.initialAcl();
            this.initialRpcHooks();
        }
        return result;
    }

    private void initialTransaction() {
        this.transactionalMessageService = (TransactionalMessageService)ServiceProvider.loadClass("META-INF/service/org.apache.rocketmq.broker.transaction.TransactionalMessageService", TransactionalMessageService.class);
        if (null == this.transactionalMessageService) {
            this.transactionalMessageService = new TransactionalMessageServiceImpl(new TransactionalMessageBridge(this, this.getMessageStore()));
            log.warn("Load default transaction message hook service: {}", (Object)TransactionalMessageServiceImpl.class.getSimpleName());
        }
        this.transactionalMessageCheckListener = (AbstractTransactionalMessageCheckListener)ServiceProvider.loadClass("META-INF/service/org.apache.rocketmq.broker.transaction.AbstractTransactionalMessageCheckListener", AbstractTransactionalMessageCheckListener.class);
        if (null == this.transactionalMessageCheckListener) {
            this.transactionalMessageCheckListener = new DefaultTransactionalMessageCheckListener();
            log.warn("Load default discard message hook service: {}", (Object)DefaultTransactionalMessageCheckListener.class.getSimpleName());
        }
        this.transactionalMessageCheckListener.setBrokerController(this);
        this.transactionalMessageCheckService = new TransactionalMessageCheckService(this);
    }

    private void initialAcl() {
        if (!this.brokerConfig.isAclEnable()) {
            log.info("The broker dose not enable acl");
            return;
        }
        List accessValidators = ServiceProvider.load("META-INF/service/org.apache.rocketmq.acl.AccessValidator", AccessValidator.class);
        if (accessValidators == null || accessValidators.isEmpty()) {
            log.info("The broker dose not load the AccessValidator");
            return;
        }
        Iterator iterator = accessValidators.iterator();
        while (iterator.hasNext()) {
            AccessValidator accessValidator;
            final AccessValidator validator = accessValidator = (AccessValidator)iterator.next();
            this.registerServerRPCHook(new RPCHook(){

                public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
                    validator.validate(validator.parse(request, remoteAddr));
                }

                public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {
                }
            });
        }
    }

    private void initialRpcHooks() {
        List<RPCHook> rpcHooks = ServiceProvider.load("META-INF/service/org.apache.rocketmq.remoting.RPCHook", RPCHook.class);
        if (rpcHooks == null || rpcHooks.isEmpty()) {
            return;
        }
        for (RPCHook rpcHook : rpcHooks) {
            this.registerServerRPCHook(rpcHook);
        }
    }

    public void registerProcessor() {
        SendMessageProcessor sendProcessor = new SendMessageProcessor(this);
        sendProcessor.registerSendMessageHook(this.sendMessageHookList);
        sendProcessor.registerConsumeMessageHook(this.consumeMessageHookList);
        this.remotingServer.registerProcessor(10, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(310, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(320, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(36, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(10, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(310, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(320, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(36, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(11, (NettyRequestProcessor)this.pullMessageProcessor, this.pullMessageExecutor);
        this.pullMessageProcessor.registerConsumeMessageHook(this.consumeMessageHookList);
        QueryMessageProcessor queryProcessor = new QueryMessageProcessor(this);
        this.remotingServer.registerProcessor(12, (NettyRequestProcessor)queryProcessor, this.queryMessageExecutor);
        this.remotingServer.registerProcessor(33, (NettyRequestProcessor)queryProcessor, this.queryMessageExecutor);
        this.fastRemotingServer.registerProcessor(12, (NettyRequestProcessor)queryProcessor, this.queryMessageExecutor);
        this.fastRemotingServer.registerProcessor(33, (NettyRequestProcessor)queryProcessor, this.queryMessageExecutor);
        ClientManageProcessor clientProcessor = new ClientManageProcessor(this);
        this.remotingServer.registerProcessor(34, (NettyRequestProcessor)clientProcessor, this.heartbeatExecutor);
        this.remotingServer.registerProcessor(35, (NettyRequestProcessor)clientProcessor, this.clientManageExecutor);
        this.remotingServer.registerProcessor(46, (NettyRequestProcessor)clientProcessor, this.clientManageExecutor);
        this.fastRemotingServer.registerProcessor(34, (NettyRequestProcessor)clientProcessor, this.heartbeatExecutor);
        this.fastRemotingServer.registerProcessor(35, (NettyRequestProcessor)clientProcessor, this.clientManageExecutor);
        this.fastRemotingServer.registerProcessor(46, (NettyRequestProcessor)clientProcessor, this.clientManageExecutor);
        ConsumerManageProcessor consumerManageProcessor = new ConsumerManageProcessor(this);
        this.remotingServer.registerProcessor(38, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.remotingServer.registerProcessor(15, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.remotingServer.registerProcessor(14, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.fastRemotingServer.registerProcessor(38, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.fastRemotingServer.registerProcessor(15, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.fastRemotingServer.registerProcessor(14, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.remotingServer.registerProcessor(37, (NettyRequestProcessor)new EndTransactionProcessor(this), this.endTransactionExecutor);
        this.fastRemotingServer.registerProcessor(37, (NettyRequestProcessor)new EndTransactionProcessor(this), this.endTransactionExecutor);
        AdminBrokerProcessor adminProcessor = new AdminBrokerProcessor(this);
        this.remotingServer.registerDefaultProcessor((NettyRequestProcessor)adminProcessor, this.adminBrokerExecutor);
        this.fastRemotingServer.registerDefaultProcessor((NettyRequestProcessor)adminProcessor, this.adminBrokerExecutor);
    }

    public BrokerStats getBrokerStats() {
        return this.brokerStats;
    }

    public void setBrokerStats(BrokerStats brokerStats) {
        this.brokerStats = brokerStats;
    }

    public void protectBroker() {
        if (this.brokerConfig.isDisableConsumeIfConsumerReadSlowly()) {
            for (Map.Entry next : this.brokerStatsManager.getMomentStatsItemSetFallSize().getStatsItemTable().entrySet()) {
                long fallBehindBytes = ((MomentStatsItem)next.getValue()).getValue().get();
                if (fallBehindBytes <= this.brokerConfig.getConsumerFallbehindThreshold()) continue;
                String[] split = ((MomentStatsItem)next.getValue()).getStatsKey().split("@");
                String group = split[2];
                LOG_PROTECTION.info("[PROTECT_BROKER] the consumer[{}] consume slowly, {} bytes, disable it", (Object)group, (Object)fallBehindBytes);
                this.subscriptionGroupManager.disableConsume(group);
            }
        }
    }

    public long headSlowTimeMills(BlockingQueue<Runnable> q) {
        long slowTimeMills = 0L;
        Runnable peek = (Runnable)q.peek();
        if (peek != null) {
            RequestTask rt = BrokerFastFailure.castRunnable(peek);
            long l = slowTimeMills = rt == null ? 0L : this.messageStore.now() - rt.getCreateTimestamp();
        }
        if (slowTimeMills < 0L) {
            slowTimeMills = 0L;
        }
        return slowTimeMills;
    }

    public long headSlowTimeMills4SendThreadPoolQueue() {
        return this.headSlowTimeMills(this.sendThreadPoolQueue);
    }

    public long headSlowTimeMills4PullThreadPoolQueue() {
        return this.headSlowTimeMills(this.pullThreadPoolQueue);
    }

    public long headSlowTimeMills4QueryThreadPoolQueue() {
        return this.headSlowTimeMills(this.queryThreadPoolQueue);
    }

    public long headSlowTimeMills4EndTransactionThreadPoolQueue() {
        return this.headSlowTimeMills(this.endTransactionThreadPoolQueue);
    }

    public void printWaterMark() {
        LOG_WATER_MARK.info("[WATERMARK] Send Queue Size: {} SlowTimeMills: {}", (Object)this.sendThreadPoolQueue.size(), (Object)this.headSlowTimeMills4SendThreadPoolQueue());
        LOG_WATER_MARK.info("[WATERMARK] Pull Queue Size: {} SlowTimeMills: {}", (Object)this.pullThreadPoolQueue.size(), (Object)this.headSlowTimeMills4PullThreadPoolQueue());
        LOG_WATER_MARK.info("[WATERMARK] Query Queue Size: {} SlowTimeMills: {}", (Object)this.queryThreadPoolQueue.size(), (Object)this.headSlowTimeMills4QueryThreadPoolQueue());
        LOG_WATER_MARK.info("[WATERMARK] Transaction Queue Size: {} SlowTimeMills: {}", (Object)this.endTransactionThreadPoolQueue.size(), (Object)this.headSlowTimeMills4EndTransactionThreadPoolQueue());
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    private void printMasterAndSlaveDiff() {
        long diff = this.messageStore.slaveFallBehindMuch();
        log.info("Slave fall behind master: {} bytes", (Object)diff);
    }

    public Broker2Client getBroker2Client() {
        return this.broker2Client;
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public ConsumerFilterManager getConsumerFilterManager() {
        return this.consumerFilterManager;
    }

    public ConsumerOffsetManager getConsumerOffsetManager() {
        return this.consumerOffsetManager;
    }

    public MessageStoreConfig getMessageStoreConfig() {
        return this.messageStoreConfig;
    }

    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    public void setFastRemotingServer(RemotingServer fastRemotingServer) {
        this.fastRemotingServer = fastRemotingServer;
    }

    public PullMessageProcessor getPullMessageProcessor() {
        return this.pullMessageProcessor;
    }

    public PullRequestHoldService getPullRequestHoldService() {
        return this.pullRequestHoldService;
    }

    public SubscriptionGroupManager getSubscriptionGroupManager() {
        return this.subscriptionGroupManager;
    }

    public void shutdown() {
        if (this.brokerStatsManager != null) {
            this.brokerStatsManager.shutdown();
        }
        if (this.clientHousekeepingService != null) {
            this.clientHousekeepingService.shutdown();
        }
        if (this.pullRequestHoldService != null) {
            this.pullRequestHoldService.shutdown();
        }
        if (this.remotingServer != null) {
            this.remotingServer.shutdown();
        }
        if (this.fastRemotingServer != null) {
            this.fastRemotingServer.shutdown();
        }
        if (this.fileWatchService != null) {
            this.fileWatchService.shutdown();
        }
        if (this.messageStore != null) {
            this.messageStore.shutdown();
        }
        this.scheduledExecutorService.shutdown();
        try {
            this.scheduledExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.unregisterBrokerAll();
        if (this.sendMessageExecutor != null) {
            this.sendMessageExecutor.shutdown();
        }
        if (this.pullMessageExecutor != null) {
            this.pullMessageExecutor.shutdown();
        }
        if (this.adminBrokerExecutor != null) {
            this.adminBrokerExecutor.shutdown();
        }
        if (this.brokerOuterAPI != null) {
            this.brokerOuterAPI.shutdown();
        }
        this.consumerOffsetManager.persist();
        if (this.filterServerManager != null) {
            this.filterServerManager.shutdown();
        }
        if (this.brokerFastFailure != null) {
            this.brokerFastFailure.shutdown();
        }
        if (this.consumerFilterManager != null) {
            this.consumerFilterManager.persist();
        }
        if (this.clientManageExecutor != null) {
            this.clientManageExecutor.shutdown();
        }
        if (this.queryMessageExecutor != null) {
            this.queryMessageExecutor.shutdown();
        }
        if (this.consumerManageExecutor != null) {
            this.consumerManageExecutor.shutdown();
        }
        if (this.fileWatchService != null) {
            this.fileWatchService.shutdown();
        }
        if (this.transactionalMessageCheckService != null) {
            this.transactionalMessageCheckService.shutdown(false);
        }
        if (this.endTransactionExecutor != null) {
            this.endTransactionExecutor.shutdown();
        }
    }

    private void unregisterBrokerAll() {
        this.brokerOuterAPI.unregisterBrokerAll(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId());
    }

    public String getBrokerAddr() {
        return this.brokerConfig.getBrokerIP1() + ":" + this.nettyServerConfig.getListenPort();
    }

    public void start() throws Exception {
        if (this.messageStore != null) {
            this.messageStore.start();
        }
        if (this.remotingServer != null) {
            this.remotingServer.start();
        }
        if (this.fastRemotingServer != null) {
            this.fastRemotingServer.start();
        }
        if (this.fileWatchService != null) {
            this.fileWatchService.start();
        }
        if (this.brokerOuterAPI != null) {
            this.brokerOuterAPI.start();
        }
        if (this.pullRequestHoldService != null) {
            this.pullRequestHoldService.start();
        }
        if (this.clientHousekeepingService != null) {
            this.clientHousekeepingService.start();
        }
        if (this.filterServerManager != null) {
            this.filterServerManager.start();
        }
        this.registerBrokerAll(true, false, true);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerController.this.registerBrokerAll(true, false, BrokerController.this.brokerConfig.isForceRegister());
                }
                catch (Throwable e) {
                    log.error("registerBrokerAll Exception", e);
                }
            }
        }, 10000L, Math.max(10000, Math.min(this.brokerConfig.getRegisterNameServerPeriod(), 60000)), TimeUnit.MILLISECONDS);
        if (this.brokerStatsManager != null) {
            this.brokerStatsManager.start();
        }
        if (this.brokerFastFailure != null) {
            this.brokerFastFailure.start();
        }
        if (BrokerRole.SLAVE != this.messageStoreConfig.getBrokerRole() && this.transactionalMessageCheckService != null) {
            log.info("Start transaction service!");
            this.transactionalMessageCheckService.start();
        }
    }

    public synchronized void registerIncrementBrokerData(TopicConfig topicConfig, DataVersion dataVersion) {
        TopicConfig registerTopicConfig = topicConfig;
        if (!PermName.isWriteable((int)this.getBrokerConfig().getBrokerPermission()) || !PermName.isReadable((int)this.getBrokerConfig().getBrokerPermission())) {
            registerTopicConfig = new TopicConfig(topicConfig.getTopicName(), topicConfig.getReadQueueNums(), topicConfig.getWriteQueueNums(), this.brokerConfig.getBrokerPermission());
        }
        ConcurrentHashMap<String, TopicConfig> topicConfigTable = new ConcurrentHashMap<String, TopicConfig>();
        topicConfigTable.put(topicConfig.getTopicName(), registerTopicConfig);
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = new TopicConfigSerializeWrapper();
        topicConfigSerializeWrapper.setDataVersion(dataVersion);
        topicConfigSerializeWrapper.setTopicConfigTable(topicConfigTable);
        this.doRegisterBrokerAll(true, false, topicConfigSerializeWrapper);
    }

    public synchronized void registerBrokerAll(boolean checkOrderConfig, boolean oneway, boolean forceRegister) {
        TopicConfigSerializeWrapper topicConfigWrapper = this.getTopicConfigManager().buildTopicConfigSerializeWrapper();
        if (!PermName.isWriteable((int)this.getBrokerConfig().getBrokerPermission()) || !PermName.isReadable((int)this.getBrokerConfig().getBrokerPermission())) {
            ConcurrentHashMap<String, TopicConfig> topicConfigTable = new ConcurrentHashMap<String, TopicConfig>();
            for (TopicConfig topicConfig : topicConfigWrapper.getTopicConfigTable().values()) {
                TopicConfig tmp = new TopicConfig(topicConfig.getTopicName(), topicConfig.getReadQueueNums(), topicConfig.getWriteQueueNums(), this.brokerConfig.getBrokerPermission());
                topicConfigTable.put(topicConfig.getTopicName(), tmp);
            }
            topicConfigWrapper.setTopicConfigTable(topicConfigTable);
        }
        if (forceRegister || this.needRegister(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.brokerConfig.getRegisterBrokerTimeoutMills())) {
            this.doRegisterBrokerAll(checkOrderConfig, oneway, topicConfigWrapper);
        }
    }

    private void doRegisterBrokerAll(boolean checkOrderConfig, boolean oneway, TopicConfigSerializeWrapper topicConfigWrapper) {
        RegisterBrokerResult registerBrokerResult;
        List<RegisterBrokerResult> registerBrokerResultList = this.brokerOuterAPI.registerBrokerAll(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.getHAServerAddr(), topicConfigWrapper, this.filterServerManager.buildNewFilterServerList(), oneway, this.brokerConfig.getRegisterBrokerTimeoutMills(), this.brokerConfig.isCompressedRegister());
        if (registerBrokerResultList.size() > 0 && (registerBrokerResult = registerBrokerResultList.get(0)) != null) {
            if (this.updateMasterHAServerAddrPeriodically && registerBrokerResult.getHaServerAddr() != null) {
                this.messageStore.updateHaMasterAddress(registerBrokerResult.getHaServerAddr());
            }
            this.slaveSynchronize.setMasterAddr(registerBrokerResult.getMasterAddr());
            if (checkOrderConfig) {
                this.getTopicConfigManager().updateOrderTopicConfig(registerBrokerResult.getKvTable());
            }
        }
    }

    private boolean needRegister(String clusterName, String brokerAddr, String brokerName, long brokerId, int timeoutMills) {
        TopicConfigSerializeWrapper topicConfigWrapper = this.getTopicConfigManager().buildTopicConfigSerializeWrapper();
        List<Boolean> changeList = this.brokerOuterAPI.needRegister(clusterName, brokerAddr, brokerName, brokerId, topicConfigWrapper, timeoutMills);
        boolean needRegister = false;
        for (Boolean changed : changeList) {
            if (!changed.booleanValue()) continue;
            needRegister = true;
            break;
        }
        return needRegister;
    }

    public TopicConfigManager getTopicConfigManager() {
        return this.topicConfigManager;
    }

    public void setTopicConfigManager(TopicConfigManager topicConfigManager) {
        this.topicConfigManager = topicConfigManager;
    }

    public String getHAServerAddr() {
        return this.brokerConfig.getBrokerIP2() + ":" + this.messageStoreConfig.getHaListenPort();
    }

    public RebalanceLockManager getRebalanceLockManager() {
        return this.rebalanceLockManager;
    }

    public SlaveSynchronize getSlaveSynchronize() {
        return this.slaveSynchronize;
    }

    public ExecutorService getPullMessageExecutor() {
        return this.pullMessageExecutor;
    }

    public void setPullMessageExecutor(ExecutorService pullMessageExecutor) {
        this.pullMessageExecutor = pullMessageExecutor;
    }

    public BlockingQueue<Runnable> getSendThreadPoolQueue() {
        return this.sendThreadPoolQueue;
    }

    public FilterServerManager getFilterServerManager() {
        return this.filterServerManager;
    }

    public BrokerStatsManager getBrokerStatsManager() {
        return this.brokerStatsManager;
    }

    public List<SendMessageHook> getSendMessageHookList() {
        return this.sendMessageHookList;
    }

    public void registerSendMessageHook(SendMessageHook hook) {
        this.sendMessageHookList.add(hook);
        log.info("register SendMessageHook Hook, {}", (Object)hook.hookName());
    }

    public List<ConsumeMessageHook> getConsumeMessageHookList() {
        return this.consumeMessageHookList;
    }

    public void registerConsumeMessageHook(ConsumeMessageHook hook) {
        this.consumeMessageHookList.add(hook);
        log.info("register ConsumeMessageHook Hook, {}", (Object)hook.hookName());
    }

    public void registerServerRPCHook(RPCHook rpcHook) {
        this.getRemotingServer().registerRPCHook(rpcHook);
        this.fastRemotingServer.registerRPCHook(rpcHook);
    }

    public RemotingServer getRemotingServer() {
        return this.remotingServer;
    }

    public void setRemotingServer(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
    }

    public void registerClientRPCHook(RPCHook rpcHook) {
        this.getBrokerOuterAPI().registerRPCHook(rpcHook);
    }

    public BrokerOuterAPI getBrokerOuterAPI() {
        return this.brokerOuterAPI;
    }

    public InetSocketAddress getStoreHost() {
        return this.storeHost;
    }

    public void setStoreHost(InetSocketAddress storeHost) {
        this.storeHost = storeHost;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public BlockingQueue<Runnable> getHeartbeatThreadPoolQueue() {
        return this.heartbeatThreadPoolQueue;
    }

    public TransactionalMessageCheckService getTransactionalMessageCheckService() {
        return this.transactionalMessageCheckService;
    }

    public void setTransactionalMessageCheckService(TransactionalMessageCheckService transactionalMessageCheckService) {
        this.transactionalMessageCheckService = transactionalMessageCheckService;
    }

    public TransactionalMessageService getTransactionalMessageService() {
        return this.transactionalMessageService;
    }

    public void setTransactionalMessageService(TransactionalMessageService transactionalMessageService) {
        this.transactionalMessageService = transactionalMessageService;
    }

    public AbstractTransactionalMessageCheckListener getTransactionalMessageCheckListener() {
        return this.transactionalMessageCheckListener;
    }

    public void setTransactionalMessageCheckListener(AbstractTransactionalMessageCheckListener transactionalMessageCheckListener) {
        this.transactionalMessageCheckListener = transactionalMessageCheckListener;
    }

    public BlockingQueue<Runnable> getEndTransactionThreadPoolQueue() {
        return this.endTransactionThreadPoolQueue;
    }
}

