/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import org.apache.qpid.amqp_1_0.codec.SimpleVariableWidthWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.type.Binary;

public class BinaryWriter
extends SimpleVariableWidthWriter<Binary> {
    private int _offset;
    private int _length;
    private static ValueWriter.Factory<Binary> FACTORY = new ValueWriter.Factory<Binary>(){

        @Override
        public ValueWriter<Binary> newInstance(ValueWriter.Registry registry) {
            return new BinaryWriter();
        }
    };

    @Override
    protected byte getFourOctetEncodingCode() {
        return -80;
    }

    @Override
    protected byte getSingleOctetEncodingCode() {
        return -96;
    }

    @Override
    protected byte[] getByteArray(Binary value) {
        this._offset = value.getArrayOffset();
        this._length = value.getLength();
        return value.getArray();
    }

    @Override
    protected int getOffset() {
        return this._offset;
    }

    @Override
    protected int getLength() {
        return this._length;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Binary.class, FACTORY);
    }
}

