/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.sprm;

import java.util.List;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public final class SprmUtils {
    public static byte[] shortArrayToByteArray(short[] convert) {
        byte[] buf = new byte[convert.length * 2];
        for (int x = 0; x < convert.length; ++x) {
            LittleEndian.putShort((byte[])buf, (int)(x * 2), (short)convert[x]);
        }
        return buf;
    }

    public static int addSpecialSprm(short instruction, byte[] varParam, List<byte[]> list) {
        byte[] sprm = new byte[varParam.length + 4];
        System.arraycopy(varParam, 0, sprm, 4, varParam.length);
        LittleEndian.putShort((byte[])sprm, (int)0, (short)instruction);
        LittleEndian.putShort((byte[])sprm, (int)2, (short)((short)(varParam.length + 1)));
        list.add(sprm);
        return sprm.length;
    }

    public static int addSprm(short instruction, boolean param, List<byte[]> list) {
        return SprmUtils.addSprm(instruction, param ? 1 : 0, null, list);
    }

    public static int addSprm(short instruction, int param, byte[] varParam, List<byte[]> list) {
        int type = (instruction & 0xE000) >> 13;
        byte[] sprm = null;
        switch (type) {
            case 0: 
            case 1: {
                sprm = new byte[3];
                sprm[2] = (byte)param;
                break;
            }
            case 2: {
                sprm = new byte[4];
                LittleEndian.putShort((byte[])sprm, (int)2, (short)((short)param));
                break;
            }
            case 3: {
                sprm = new byte[6];
                LittleEndian.putInt((byte[])sprm, (int)2, (int)param);
                break;
            }
            case 4: 
            case 5: {
                sprm = new byte[4];
                LittleEndian.putShort((byte[])sprm, (int)2, (short)((short)param));
                break;
            }
            case 6: {
                sprm = new byte[3 + varParam.length];
                sprm[2] = (byte)varParam.length;
                System.arraycopy(varParam, 0, sprm, 3, varParam.length);
                break;
            }
            case 7: {
                sprm = new byte[5];
                byte[] temp = new byte[4];
                LittleEndian.putInt((byte[])temp, (int)0, (int)param);
                System.arraycopy(temp, 0, sprm, 2, 3);
                break;
            }
            default: {
                throw new RuntimeException("Invalid sprm type");
            }
        }
        LittleEndian.putShort((byte[])sprm, (int)0, (short)instruction);
        list.add(sprm);
        return sprm.length;
    }

    public static byte[] getGrpprl(List<byte[]> sprmList, int size) {
        byte[] grpprl = new byte[size];
        int index = 0;
        for (int listSize = sprmList.size() - 1; listSize >= 0; --listSize) {
            byte[] sprm = sprmList.remove(0);
            System.arraycopy(sprm, 0, grpprl, index, sprm.length);
            index += sprm.length;
        }
        return grpprl;
    }

    public static int convertBrcToInt(short[] brc) {
        byte[] buf = new byte[4];
        LittleEndian.putShort((byte[])buf, (int)0, (short)brc[0]);
        LittleEndian.putShort((byte[])buf, (int)2, (short)brc[1]);
        return LittleEndian.getInt((byte[])buf);
    }
}

