/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.graphic;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceNAttributes;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaces;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;

public class StandardColorSpaceHelper
implements ColorSpaceHelper {
    protected PreflightContext context = null;
    protected ICCProfileWrapper iccpw = null;
    protected PDColorSpace pdcs = null;

    protected StandardColorSpaceHelper(PreflightContext _context, PDColorSpace _cs) {
        this.context = _context;
        this.pdcs = _cs;
    }

    public final void validate() throws ValidationException {
        if (this.pdcs == null) {
            throw new ValidationException("Unable to create a PDColorSpace with the value null");
        }
        this.iccpw = ICCProfileWrapper.getOrSearchICCProfile(this.context);
        this.processAllColorSpace(this.pdcs);
    }

    protected final void processAllColorSpace(PDColorSpace pdcs) {
        ColorSpaces cs = ColorSpaces.valueOf(pdcs.getName());
        switch (cs) {
            case DeviceRGB: 
            case DeviceRGB_SHORT: {
                this.processRGBColorSpace(pdcs);
                break;
            }
            case DeviceCMYK: 
            case DeviceCMYK_SHORT: {
                this.processCYMKColorSpace(pdcs);
                break;
            }
            case CalRGB: 
            case CalGray: 
            case Lab: {
                this.processCalibratedColorSpace(pdcs);
                break;
            }
            case DeviceGray: 
            case DeviceGray_SHORT: {
                this.processGrayColorSpace(pdcs);
                break;
            }
            case ICCBased: {
                this.processICCBasedColorSpace(pdcs);
                break;
            }
            case DeviceN: {
                this.processDeviceNColorSpace(pdcs);
                break;
            }
            case Indexed: 
            case Indexed_SHORT: {
                this.processIndexedColorSpace(pdcs);
                break;
            }
            case Separation: {
                this.processSeparationColorSpace(pdcs);
                break;
            }
            case Pattern: {
                this.processPatternColorSpace(pdcs);
                break;
            }
            default: {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.4", cs.getLabel() + " is unknown as ColorSpace"));
            }
        }
    }

    protected void processRGBColorSpace(PDColorSpace pdcs) {
        if (!this.processDefaultColorSpace(pdcs)) {
            if (this.iccpw == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
            } else if (!this.iccpw.isRGBColorSpace()) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.1", "DestOutputProfile isn't RGB ColorSpace"));
            }
        }
    }

    protected void processCYMKColorSpace(PDColorSpace pdcs) {
        if (!this.processDefaultColorSpace(pdcs)) {
            if (this.iccpw == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
            } else if (!this.iccpw.isCMYKColorSpace()) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.2", "DestOutputProfile isn't CMYK ColorSpace"));
            }
        }
    }

    protected void processPatternColorSpace(PDColorSpace pdcs) {
        if (this.iccpw == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
        }
    }

    protected void processGrayColorSpace(PDColorSpace pdcs) {
        if (!this.processDefaultColorSpace(pdcs) && this.iccpw == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
        }
    }

    protected void processCalibratedColorSpace(PDColorSpace pdcs) {
    }

    protected void processICCBasedColorSpace(PDColorSpace pdcs) {
        PDICCBased iccBased = (PDICCBased)pdcs;
        try {
            ICC_Profile iccp = ICC_Profile.getInstance(iccBased.getPDStream().createInputStream());
            if (iccp == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.11", "Unable to read ICCBase color space "));
                return;
            }
            List altCs = iccBased.getAlternateColorSpaces();
            for (PDColorSpace altpdcs : altCs) {
                ColorSpaces altCsId;
                if (altpdcs == null || (altCsId = ColorSpaces.valueOf(altpdcs.getName())) != ColorSpaces.Pattern) continue;
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.5", "Pattern is forbidden as AlternateColorSpace of a ICCBased"));
                return;
            }
        }
        catch (IllegalArgumentException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4.11", "ICCBase color space is invalid. Caused By: " + e.getMessage()));
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read ICCBase color space. Caused by : " + e.getMessage()));
        }
    }

    protected void processDeviceNColorSpace(PDColorSpace pdcs) {
        PDDeviceN deviceN = (PDDeviceN)pdcs;
        try {
            Map colorants;
            if (this.iccpw == null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.3", "DestOutputProfile is missing"));
                return;
            }
            PDColorSpace altColor = deviceN.getAlternateColorSpace();
            if (altColor != null) {
                this.processAllColorSpace(altColor);
            }
            int numberOfColorants = 0;
            PDDeviceNAttributes attr = deviceN.getAttributes();
            if (attr != null && (colorants = attr.getColorants()) != null) {
                numberOfColorants = colorants.size();
                for (Object col : colorants.values()) {
                    if (col == null) continue;
                    this.processAllColorSpace((PDColorSpace)col);
                }
            }
            int numberOfComponents = deviceN.getNumberOfComponents();
            if (numberOfColorants > 8 || numberOfComponents > 8) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.10", "DeviceN has too many tint components or colorants"));
            }
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read DeviceN color space : " + e.getMessage()));
        }
    }

    protected void processIndexedColorSpace(PDColorSpace pdcs) {
        PDIndexed indexed = (PDIndexed)pdcs;
        try {
            PDColorSpace based = indexed.getBaseColorSpace();
            ColorSpaces cs = ColorSpaces.valueOf(based.getName());
            if (cs == ColorSpaces.Indexed || cs == ColorSpaces.Indexed_SHORT) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.8", "Indexed color space can't be used as Base color space"));
                return;
            }
            if (cs == ColorSpaces.Pattern) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.8", "Pattern color space can't be used as Base color space"));
                return;
            }
            this.processAllColorSpace(based);
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read Indexed color space : " + e.getMessage()));
        }
    }

    protected void processSeparationColorSpace(PDColorSpace pdcs) {
        PDSeparation separation = (PDSeparation)pdcs;
        try {
            PDColorSpace altCol = separation.getAlternateColorSpace();
            if (altCol != null) {
                ColorSpaces acs = ColorSpaces.valueOf(altCol.getName());
                switch (acs) {
                    case DeviceN: 
                    case Indexed: 
                    case Indexed_SHORT: 
                    case Separation: 
                    case Pattern: {
                        this.context.addValidationError(new ValidationResult.ValidationError("2.4.7", acs.getLabel() + " color space can't be used as alternate color space"));
                        break;
                    }
                    default: {
                        this.processAllColorSpace(altCol);
                    }
                }
            }
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.4", "Unable to read Separation color space : " + e.getMessage()));
        }
    }

    protected boolean processDefaultColorSpace(PDColorSpace pdcs) {
        boolean result = false;
        PreflightPath vPath = this.context.getValidationPath();
        PDResources resources = vPath.getClosestPathElement(PDResources.class);
        if (resources != null && resources.getColorSpaces() != null) {
            PDColorSpace defaultCS = null;
            Map colorsSpaces = resources.getColorSpaces();
            if (pdcs.getName().equals(ColorSpaces.DeviceCMYK.getLabel())) {
                defaultCS = (PDColorSpace)colorsSpaces.get("DefaultCMYK");
            } else if (pdcs.getName().equals(ColorSpaces.DeviceRGB.getLabel())) {
                defaultCS = (PDColorSpace)colorsSpaces.get("DefaultRGB");
            } else if (pdcs.getName().equals(ColorSpaces.DeviceGray.getLabel())) {
                defaultCS = (PDColorSpace)colorsSpaces.get("DefaultGray");
            }
            if (defaultCS != null) {
                int nbOfErrors = this.context.getDocument().getResult().getErrorsList().size();
                this.processAllColorSpace(defaultCS);
                int newNbOfErrors = this.context.getDocument().getResult().getErrorsList().size();
                result = nbOfErrors == newNbOfErrors;
            }
        }
        return result;
    }
}

