/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;

public class HCatURI {
    public static final String PARTITION_SEPARATOR = ";";
    public static final String PARTITION_KEYVAL_SEPARATOR = "=";
    public static final String PATH_SEPARATOR = "/";
    public static final String PARTITION_VALUE_QUOTE = "'";
    private URI uri;
    private String db;
    private String table;
    private Map<String, String> partitions;

    public HCatURI(String s) throws URISyntaxException {
        this(new URI(s));
    }

    public HCatURI(URI uri) throws URISyntaxException {
        this.parse(uri);
    }

    private void parse(URI uri) throws URISyntaxException {
        String[] parts;
        this.uri = uri;
        if (uri.getAuthority() == null) {
            throw new URISyntaxException(uri.toString(), "Server host and port are missing");
        }
        String[] paths = uri.getPath().split(PATH_SEPARATOR);
        if (paths.length != 4) {
            throw new URISyntaxException(uri.toString(), "URI path is not in expected format");
        }
        this.db = paths[1];
        this.table = paths[2];
        String partRaw = paths[3];
        if (this.db == null || this.db.length() == 0) {
            throw new URISyntaxException(uri.toString(), "DB name is missing");
        }
        if (this.table == null || this.table.length() == 0) {
            throw new URISyntaxException(uri.toString(), "Table name is missing");
        }
        if (partRaw == null || partRaw.length() == 0) {
            throw new URISyntaxException(uri.toString(), "Partition details are missing");
        }
        this.partitions = new LinkedHashMap<String, String>();
        for (String part : parts = partRaw.split(PARTITION_SEPARATOR)) {
            if (part == null || part.length() == 0) continue;
            String[] keyVal = part.split(PARTITION_KEYVAL_SEPARATOR);
            if (keyVal.length != 2) {
                throw new URISyntaxException(uri.toString(), "Partition key value pair is not specified properly in (" + part + ")");
            }
            this.partitions.put(keyVal[0], keyVal[1]);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String toURIString() {
        return this.uri.toString();
    }

    public String getServerEndPoint() {
        return this.uri.getScheme() + "://" + this.uri.getAuthority();
    }

    public String getServer() {
        return this.uri.getAuthority();
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    public Map<String, String> getPartitionMap() {
        return this.partitions;
    }

    public String getPartitionValue(String key) {
        return this.partitions.get(key);
    }

    public void setPartition(String key, String value) {
        this.partitions.put(key, value);
    }

    public boolean hasPartition(String key) {
        return this.partitions.containsKey(key);
    }

    public static String getHCatURI(String server, String db, String table, Map<String, String> partitions) {
        return HCatURI.getHCatURI("hcat", server, db, table, partitions);
    }

    public static String getHCatURI(String scheme, String server, String db, String table, Map<String, String> partitions) {
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(server);
        sb.append(PATH_SEPARATOR);
        sb.append(db);
        sb.append(PATH_SEPARATOR);
        sb.append(table);
        sb.append(PATH_SEPARATOR);
        for (Map.Entry<String, String> entry : partitions.entrySet()) {
            sb.append(entry.getKey());
            sb.append(PARTITION_KEYVAL_SEPARATOR);
            sb.append(entry.getValue());
            sb.append(PARTITION_SEPARATOR);
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public int hashCode() {
        return this.uri == null ? 0 : this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HCatURI other = (HCatURI)obj;
        return this.uri.equals(other.uri);
    }

    public String toPartitionFilter(String type) {
        StringBuilder filter = new StringBuilder();
        String comparator = null;
        filter.append("(");
        comparator = type.equalsIgnoreCase("pig") ? "==" : PARTITION_KEYVAL_SEPARATOR;
        for (Map.Entry<String, String> entry : this.partitions.entrySet()) {
            if (filter.length() > 1) {
                filter.append(" AND ");
            }
            filter.append(entry.getKey());
            filter.append(comparator);
            filter.append(PARTITION_VALUE_QUOTE);
            filter.append(entry.getValue());
            filter.append(PARTITION_VALUE_QUOTE);
        }
        filter.append(")");
        return filter.toString();
    }

    public String toPartitionString() {
        StringBuilder filter = new StringBuilder();
        filter.append(PARTITION_VALUE_QUOTE);
        for (Map.Entry<String, String> entry : this.partitions.entrySet()) {
            if (filter.length() > 1) {
                filter.append(",");
            }
            filter.append(entry.getKey());
            filter.append(PARTITION_KEYVAL_SEPARATOR);
            filter.append(entry.getValue());
        }
        filter.append(PARTITION_VALUE_QUOTE);
        return filter.toString();
    }

    public String toPartitionValueString(String type) {
        StringBuilder value = new StringBuilder();
        if (type.equals("hive-export")) {
            String comparator = PARTITION_KEYVAL_SEPARATOR;
            String separator = ",";
            for (Map.Entry<String, String> entry : this.partitions.entrySet()) {
                if (value.length() > 1) {
                    value.append(separator);
                }
                value.append(entry.getKey());
                value.append(comparator);
                value.append(PARTITION_VALUE_QUOTE);
                value.append(entry.getValue());
                value.append(PARTITION_VALUE_QUOTE);
            }
        } else {
            throw new RuntimeException("Unsupported type: " + type);
        }
        return value.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("URI: ");
        sb.append(this.uri.toString());
        sb.append("\n");
        sb.append("SCHEME: ");
        sb.append(this.uri.getScheme());
        sb.append("\n");
        sb.append("SERVER: ");
        sb.append(this.getServer());
        sb.append("\n");
        sb.append("DB: ");
        sb.append(this.getDb());
        sb.append("\n");
        sb.append("TABLE: ");
        sb.append(this.getTable());
        int partcnt = 0;
        for (Map.Entry<String, String> entry : this.partitions.entrySet()) {
            sb.append("\n");
            sb.append("PARTITION(" + partcnt + "): ");
            sb.append(entry.getKey());
            sb.append(PARTITION_KEYVAL_SEPARATOR);
            sb.append(entry.getValue());
            ++partcnt;
        }
        return sb.toString();
    }
}

