/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.project.MavenProject;
import org.vafer.jdependency.Clazz;
import org.vafer.jdependency.Clazzpath;
import org.vafer.jdependency.ClazzpathUnit;

public class MinijarFilter
implements Filter {
    private Log log;
    private Set<Clazz> removable;
    private int classesKept;
    private int classesRemoved;

    MinijarFilter(int classesKept, int classesRemoved, Log log) {
        this.classesKept = classesKept;
        this.classesRemoved = classesRemoved;
        this.log = log;
    }

    public MinijarFilter(MavenProject project, Log log) throws IOException {
        this(project, log, Collections.emptyList());
    }

    public MinijarFilter(MavenProject project, Log log, List<SimpleFilter> simpleFilters) throws IOException {
        this.log = log;
        File artifactFile = project.getArtifact().getFile();
        if (artifactFile != null) {
            Clazzpath cp = new Clazzpath();
            ClazzpathUnit artifactUnit = cp.addClazzpathUnit((InputStream)new FileInputStream(artifactFile), project.toString());
            for (Artifact dependency : project.getArtifacts()) {
                this.addDependencyToClasspath(cp, dependency);
            }
            this.removable = cp.getClazzes();
            if (this.removable.remove(new Clazz("module-info"))) {
                log.warn((CharSequence)("Removing module-info from " + artifactFile.getName()));
            }
            this.removePackages(artifactUnit);
            this.removable.removeAll(artifactUnit.getClazzes());
            this.removable.removeAll(artifactUnit.getTransitiveDependencies());
            this.removeSpecificallyIncludedClasses(project, simpleFilters == null ? Collections.emptyList() : simpleFilters);
        }
    }

    /*
     * Exception decompiling
     */
    private ClazzpathUnit addDependencyToClasspath(Clazzpath cp, Artifact dependency) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removePackages(ClazzpathUnit artifactUnit) {
        HashSet<String> packageNames = new HashSet<String>();
        this.removePackages(artifactUnit.getClazzes(), packageNames);
        this.removePackages(artifactUnit.getTransitiveDependencies(), packageNames);
    }

    private void removePackages(Set clazzes, Set<String> packageNames) {
        for (Object clazze : clazzes) {
            Clazz clazz = (Clazz)clazze;
            String name = clazz.getName();
            while (name.contains(".")) {
                if (!packageNames.add(name = name.substring(0, name.lastIndexOf(46)))) continue;
                this.removable.remove(new Clazz(name + ".package-info"));
            }
        }
    }

    private void removeSpecificallyIncludedClasses(MavenProject project, List<SimpleFilter> simpleFilters) throws IOException {
        Clazzpath checkCp = new Clazzpath();
        for (Artifact dependency : project.getArtifacts()) {
            File jar = dependency.getFile();
            for (SimpleFilter simpleFilter : simpleFilters) {
                ClazzpathUnit depClazzpathUnit;
                if (!simpleFilter.canFilter(jar) || (depClazzpathUnit = this.addDependencyToClasspath(checkCp, dependency)) == null) continue;
                Set clazzes = depClazzpathUnit.getClazzes();
                Iterator<Clazz> j = this.removable.iterator();
                while (j.hasNext()) {
                    Clazz clazz = j.next();
                    if (!clazzes.contains(clazz) || !simpleFilter.isSpecificallyIncluded(clazz.getName().replace('.', '/'))) continue;
                    this.log.info((CharSequence)(clazz.getName() + " not removed because it was specifically included"));
                    j.remove();
                }
            }
        }
    }

    @Override
    public boolean canFilter(File jar) {
        return true;
    }

    @Override
    public boolean isFiltered(String classFile) {
        String className = classFile.replace('/', '.').replaceFirst("\\.class$", "");
        Clazz clazz = new Clazz(className);
        if (this.removable != null && this.removable.contains(clazz)) {
            this.log.debug((CharSequence)("Removing " + className));
            ++this.classesRemoved;
            return true;
        }
        ++this.classesKept;
        return false;
    }

    @Override
    public void finished() {
        int classesTotal = this.classesRemoved + this.classesKept;
        if (classesTotal != 0) {
            this.log.info((CharSequence)("Minimized " + classesTotal + " -> " + this.classesKept + " (" + 100 * this.classesKept / classesTotal + "%)"));
        } else {
            this.log.info((CharSequence)("Minimized " + classesTotal + " -> " + this.classesKept));
        }
    }
}

