/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public abstract class AbstractUnpackingMojo
extends AbstractMojo {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected File outputDirectory;
    protected String finalName;
    protected File workDirectory;
    protected ArchiverManager archiverManager;
    protected ArtifactResolver artifactResolver;
    protected ArtifactRepository localRepository;
    protected List reactorProjects;
    protected String classifier;
    protected MavenProject project;

    protected Set getDependencies() {
        Set projectArtifacts;
        MavenProject project = this.getExecutedProject();
        HashSet<Artifact> dependenciesSet = new HashSet<Artifact>();
        if (project.getArtifact() != null && project.getArtifact().getFile() != null) {
            dependenciesSet.add(project.getArtifact());
        }
        if ((projectArtifacts = project.getArtifacts()) != null) {
            dependenciesSet.addAll(projectArtifacts);
        }
        return dependenciesSet;
    }

    protected abstract MavenProject getExecutedProject();

    protected void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(file);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }

    public String getClassifier() {
        return this.classifier;
    }
}

