/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.als;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.QRDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntObjectHashMap;

public class ImplicitFeedbackAlternatingLeastSquaresSolver {
    private final int numFeatures;
    private final double alpha;
    private final double lambda;
    private final OpenIntObjectHashMap<Vector> Y;
    private final Matrix YtransposeY;

    public ImplicitFeedbackAlternatingLeastSquaresSolver(int numFeatures, double lambda, double alpha, OpenIntObjectHashMap Y) {
        this.numFeatures = numFeatures;
        this.lambda = lambda;
        this.alpha = alpha;
        this.Y = Y;
        this.YtransposeY = this.YtransposeY((OpenIntObjectHashMap<Vector>)Y);
    }

    public Vector solve(Vector ratings) {
        return ImplicitFeedbackAlternatingLeastSquaresSolver.solve(this.YtransposeY.plus(this.YtransponseCuMinusIYPlusLambdaI(ratings)), this.YtransponseCuPu(ratings));
    }

    private static Vector solve(Matrix A, Matrix y) {
        return new QRDecomposition(A).solve(y).viewColumn(0);
    }

    protected double confidence(double rating) {
        return 1.0 + this.alpha * rating;
    }

    private Matrix YtransposeY(OpenIntObjectHashMap<Vector> Y) {
        DenseMatrix compactedY = new DenseMatrix(Y.size(), this.numFeatures);
        IntArrayList indexes = Y.keys();
        indexes.quickSort();
        int row = 0;
        for (int index : indexes.elements()) {
            compactedY.assignRow(row++, (Vector)Y.get(index));
        }
        return compactedY.transpose().times(compactedY);
    }

    private Matrix YtransponseCuMinusIYPlusLambdaI(Vector userRatings) {
        Preconditions.checkArgument((boolean)userRatings.isSequentialAccess(), (Object)"need sequential access to ratings!");
        OpenIntObjectHashMap CuMinusIY = new OpenIntObjectHashMap();
        Iterator<Vector.Element> ratings = userRatings.iterateNonZero();
        while (ratings.hasNext()) {
            Vector.Element e = ratings.next();
            CuMinusIY.put(e.index(), (Object)((Vector)this.Y.get(e.index())).times(this.confidence(e.get()) - 1.0));
        }
        DenseMatrix YtransponseCuMinusIY = new DenseMatrix(this.numFeatures, this.numFeatures);
        ratings = userRatings.iterateNonZero();
        while (ratings.hasNext()) {
            Vector.Element e = ratings.next();
            for (Vector.Element feature : (Vector)this.Y.get(e.index())) {
                Vector partial = ((Vector)CuMinusIY.get(e.index())).times(feature.get());
                YtransponseCuMinusIY.viewRow(feature.index()).assign(partial, Functions.PLUS);
            }
        }
        for (int feature = 0; feature < this.numFeatures; ++feature) {
            YtransponseCuMinusIY.setQuick(feature, feature, YtransponseCuMinusIY.getQuick(feature, feature) + this.lambda);
        }
        return YtransponseCuMinusIY;
    }

    private Matrix YtransponseCuPu(Vector userRatings) {
        Preconditions.checkArgument((boolean)userRatings.isSequentialAccess(), (Object)"need sequential access to ratings!");
        DenseVector YtransponseCuPu = new DenseVector(this.numFeatures);
        Iterator<Vector.Element> ratings = userRatings.iterateNonZero();
        while (ratings.hasNext()) {
            Vector.Element e = ratings.next();
            YtransponseCuPu.assign(((Vector)this.Y.get(e.index())).times(this.confidence(e.get())), Functions.PLUS);
        }
        return this.columnVectorAsMatrix(YtransponseCuPu);
    }

    private Matrix columnVectorAsMatrix(Vector v) {
        DenseMatrix matrix = new DenseMatrix(this.numFeatures, 1);
        for (Vector.Element e : v) {
            matrix.setQuick(e.index(), 0, e.get());
        }
        return matrix;
    }
}

