/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.Vector;

public class VectorView
extends AbstractVector {
    private Vector vector;
    private int offset;

    public VectorView() {
        super(0);
    }

    public VectorView(Vector vector, int offset, int cardinality) {
        super(cardinality);
        this.vector = vector;
        this.offset = offset;
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return ((AbstractVector)this.vector).matrixLike(rows, columns);
    }

    @Override
    public Vector clone() {
        VectorView r = (VectorView)super.clone();
        r.vector = this.vector.clone();
        r.offset = this.offset;
        return r;
    }

    @Override
    public boolean isDense() {
        return this.vector.isDense();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.vector.isSequentialAccess();
    }

    @Override
    public VectorView like() {
        return new VectorView(this.vector.like(), this.offset, this.size());
    }

    @Override
    public double getQuick(int index) {
        return this.vector.getQuick(this.offset + index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.vector.setQuick(this.offset + index, value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.size();
    }

    @Override
    public Vector viewPart(int offset, int length) {
        if (offset < 0) {
            throw new IndexException(offset, this.size());
        }
        if (offset + length > this.size()) {
            throw new IndexException(offset + length, this.size());
        }
        return new VectorView(this.vector, offset + this.offset, length);
    }

    private boolean isInView(int index) {
        return index >= this.offset && index < this.offset + this.size();
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonZeroIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    @Override
    public double getLengthSquared() {
        double result = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double value = this.getQuick(i);
            result += value * value;
        }
        return result;
    }

    @Override
    public double getDistanceSquared(Vector v) {
        double result = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double delta = this.getQuick(i) - v.getQuick(i);
            result += delta * delta;
        }
        return result;
    }

    @Override
    public double getLookupCost() {
        return this.vector.getLookupCost();
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 2.0 * this.vector.getIteratorAdvanceCost();
    }

    @Override
    public boolean isAddConstantTime() {
        return this.vector.isAddConstantTime();
    }

    @Override
    public void mergeUpdates(OrderedIntDoubleMapping updates) {
        for (int i = 0; i < updates.getNumMappings(); ++i) {
            updates.setIndexAt(i, updates.indexAt(i) + this.offset);
        }
        this.vector.mergeUpdates(updates);
    }

    private final class DecoratorElement
    implements Vector.Element {
        private final Vector.Element decorated;

        private DecoratorElement(Vector.Element decorated) {
            this.decorated = decorated;
        }

        @Override
        public double get() {
            return this.decorated.get();
        }

        @Override
        public int index() {
            return this.decorated.index() - VectorView.this.offset;
        }

        @Override
        public void set(double value) {
            this.decorated.set(value);
        }
    }

    public final class AllIterator
    extends AbstractIterator<Vector.Element> {
        private final Iterator<Vector.Element> it;

        private AllIterator() {
            this.it = VectorView.this.vector.all().iterator();
        }

        protected Vector.Element computeNext() {
            while (this.it.hasNext()) {
                Vector.Element el = this.it.next();
                if (!VectorView.this.isInView(el.index())) continue;
                Vector.Element decorated = VectorView.this.vector.getElement(el.index());
                return new DecoratorElement(decorated);
            }
            return (Vector.Element)this.endOfData();
        }
    }

    public final class NonZeroIterator
    extends AbstractIterator<Vector.Element> {
        private final Iterator<Vector.Element> it;

        private NonZeroIterator() {
            this.it = VectorView.this.vector.nonZeroes().iterator();
        }

        protected Vector.Element computeNext() {
            while (this.it.hasNext()) {
                Vector.Element el = this.it.next();
                if (!VectorView.this.isInView(el.index()) || el.get() == 0.0) continue;
                Vector.Element decorated = VectorView.this.vector.getElement(el.index());
                return new DecoratorElement(decorated);
            }
            return (Vector.Element)this.endOfData();
        }
    }
}

