/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client.model;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.apache.lens.api.result.PrettyPrintable;
import org.apache.lens.client.model.BriefError;
import org.apache.lens.client.model.IdBriefErrorTemplateKey;

public class IdBriefErrorTemplate
implements PrettyPrintable {
    private final IdBriefErrorTemplateKey idKey;
    private final String idValue;
    private final BriefError briefError;

    public IdBriefErrorTemplate(@NonNull IdBriefErrorTemplateKey idKey, String idValue, @NonNull BriefError briefError) {
        if (idKey == null) {
            throw new NullPointerException("idKey");
        }
        if (briefError == null) {
            throw new NullPointerException("briefError");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)idValue));
        this.idKey = idKey;
        this.idValue = idValue;
        this.briefError = briefError;
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder(this.idKey.getConstant()).append(": ").append(this.idValue).append("\n").append(this.briefError.toPrettyString());
        return sb.toString();
    }
}

