/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.lens.client.LensStatement;
import org.apache.lens.client.exceptions.LensAPIException;
import org.apache.lens.client.jdbc.LensJdbcConnection;
import org.apache.lens.client.jdbc.LensJdbcResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensJdbcStatement
implements Statement {
    private static final Logger log = LoggerFactory.getLogger(LensJdbcStatement.class);
    private final LensJdbcConnection connection;
    private final LensStatement statement;
    private boolean closed;

    public LensJdbcStatement(LensJdbcConnection connection) {
        this.connection = connection;
        this.statement = new LensStatement(connection.getConnection());
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        try {
            this.statement.execute(s, null);
        }
        catch (LensAPIException e) {
            log.error("Execution Failed for Statement:{}", (Object)s, (Object)e);
        }
        return new LensJdbcResultSet(this.statement.getResultSet(), this.statement.getResultSetMetaData(), this);
    }

    @Override
    public void close() throws SQLException {
        this.killUnderlyingLensQuery();
        this.closed = true;
    }

    @Override
    public void cancel() throws SQLException {
        this.killUnderlyingLensQuery();
    }

    private void killUnderlyingLensQuery() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.statement.isIdle()) {
            return;
        }
        boolean status = this.statement.kill();
        if (!status) {
            throw new SQLException("Unable to close the Statement on lens server");
        }
    }

    @Override
    public boolean execute(String s) throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot execute statemes on closed statements");
        }
        try {
            this.statement.execute(s, true, null);
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
        return this.statement.wasQuerySuccessful();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot get resultset for closed statements");
        }
        return new LensJdbcResultSet(this.statement.getResultSet(), this.statement.getResultSetMetaData(), this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    void closeResultSet() {
        this.statement.closeResultSet();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String s) throws SQLException {
        throw new SQLException("Operation not supported!!!!");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new SQLException("Operation not supported!!!!");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLException("Operation not supported!!!!");
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        throw new SQLException("Operation not supported!!!!");
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        throw new SQLException("Operation not supported!!!!");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("Operation not supported!!!!");
    }

    @Override
    public int executeUpdate(String s) throws SQLException {
        throw new SQLException("Operation not supported");
    }

    @Override
    public void addBatch(String s) throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        throw new SQLException("Operation not supported");
    }

    @Override
    public int executeUpdate(String s, int[] ints) throws SQLException {
        throw new SQLException("Operation not supported");
    }

    @Override
    public int executeUpdate(String s, String[] strings) throws SQLException {
        throw new SQLException("Operation not supported");
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        throw new SQLException("Operation not supported");
    }

    @Override
    public boolean execute(String s, int[] ints) throws SQLException {
        throw new SQLException("Operation not supported");
    }

    @Override
    public boolean execute(String s, String[] strings) throws SQLException {
        throw new SQLException("Operation not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public void setEscapeProcessing(boolean b) throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new SQLException("Operation not supported!!!!");
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        throw new SQLException("Operation not supported!!!!");
    }
}

