/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lens.api.query.QueryResultSetMetadata;
import org.apache.lens.api.query.ResultColumn;
import org.apache.lens.client.jdbc.JDBCUtils;

public class LensJdbcResultSetMetadata
implements ResultSetMetaData {
    private final QueryResultSetMetadata metadata;
    private final List<String> colNames;
    private final List<String> colTypes;

    public LensJdbcResultSetMetadata(QueryResultSetMetadata metadata) {
        this.metadata = metadata;
        this.colNames = new ArrayList<String>();
        this.colTypes = new ArrayList<String>();
        for (ResultColumn column : metadata.getColumns()) {
            this.colNames.add(column.getName());
            this.colTypes.add(column.getType().name());
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.metadata.getColumns().size();
    }

    @Override
    public boolean isAutoIncrement(int index) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int index) throws SQLException {
        return "string".equalsIgnoreCase(this.colTypes.get(this.toZeroIndex(index)));
    }

    @Override
    public boolean isSearchable(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int i) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int i) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int i) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int i) throws SQLException {
        return this.getPrecision(i);
    }

    @Override
    public String getColumnLabel(int i) throws SQLException {
        return this.colNames.get(this.toZeroIndex(i));
    }

    @Override
    public String getColumnName(int i) throws SQLException {
        return this.colNames.get(this.toZeroIndex(i));
    }

    @Override
    public String getSchemaName(int i) throws SQLException {
        throw new SQLException("Operation not supported!!!");
    }

    @Override
    public int getPrecision(int i) throws SQLException {
        return JDBCUtils.columnPrecision(this.getColumnType(i));
    }

    @Override
    public int getScale(int i) throws SQLException {
        return JDBCUtils.columnScale(this.getColumnType(i));
    }

    @Override
    public String getTableName(int i) throws SQLException {
        throw new SQLException("Operation not supported!!!!");
    }

    @Override
    public String getCatalogName(int i) throws SQLException {
        throw new SQLException("Opertation not supported!!!");
    }

    @Override
    public int getColumnType(int index) throws SQLException {
        return JDBCUtils.getSQLType(this.colTypes.get(this.toZeroIndex(index)));
    }

    @Override
    public String getColumnTypeName(int index) throws SQLException {
        return this.colTypes.get(this.toZeroIndex(index));
    }

    @Override
    public boolean isReadOnly(int i) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int i) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int i) throws SQLException {
        return JDBCUtils.columnClassName(this.getColumnType(i));
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return false;
    }

    protected int toZeroIndex(int column) throws SQLException {
        if (this.colTypes.isEmpty()) {
            throw new SQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.colTypes.size()) {
            throw new SQLException("Invalid column value: " + column);
        }
        return column - 1;
    }
}

