/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.lens.client.jdbc.JDBCUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensJdbcDriver
implements Driver {
    private static final Logger log = LoggerFactory.getLogger(LensJdbcDriver.class);
    private static final boolean JDBC_COMPLIANT = false;

    @Override
    public Connection connect(String s, Properties properties) throws SQLException {
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Pattern.matches("jdbc:lens://.*", url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith("jdbc:lens://")) {
            info = JDBCUtils.parseUrlForPropertyInfo(url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo("HOST", info.getProperty("HOST"));
        hostProp.required = false;
        hostProp.description = "Hostname of Lens Server. Defaults to localhost";
        DriverPropertyInfo portProp = new DriverPropertyInfo("PORT", info.getProperty("PORT"));
        portProp.required = false;
        portProp.description = "Portnumber where lens server runs. Defaults to 8080";
        DriverPropertyInfo dbProp = new DriverPropertyInfo("DBNAME", info.getProperty("DBNAME"));
        dbProp.required = false;
        dbProp.description = "Database to connect to on lens server. Defaults to 'default'";
        return new DriverPropertyInfo[]{hostProp, portProp, dbProp};
    }

    @Override
    public int getMajorVersion() {
        return JDBCUtils.getVersion(0);
    }

    @Override
    public int getMinorVersion() {
        return JDBCUtils.getVersion(1);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    static {
        try {
            DriverManager.registerDriver(new LensJdbcDriver());
        }
        catch (SQLException e) {
            log.error("Error in registering jdbc driver", (Throwable)e);
        }
    }
}

