/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client.jdbc;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.apache.lens.client.LensConnectionParams;

public final class JDBCUtils {
    static final String DB_PROPERTY_KEY = "DBNAME";
    static final String HOST_PROPERTY_KEY = "HOST";
    static final String PORT_PROPERTY_KEY = "PORT";
    public static final String URL_PREFIX = "jdbc:lens://";
    private static final String URI_JDBC_PREFIX = "jdbc:";
    private static final String KEY_VALUE_REGEX = "([^;]*)=([^;]*)[;]?";
    private static Attributes manifestAttributes = null;

    private JDBCUtils() {
    }

    public static LensConnectionParams parseUrl(String uri) throws IllegalArgumentException {
        String varStr;
        String confStr;
        LensConnectionParams params = new LensConnectionParams();
        if (!uri.startsWith(URL_PREFIX)) {
            throw new IllegalArgumentException("Bad URL format");
        }
        if (uri.equalsIgnoreCase(URL_PREFIX)) {
            return params;
        }
        URI jdbcUri = URI.create(uri.substring(URI_JDBC_PREFIX.length()));
        Pattern pattern = Pattern.compile(KEY_VALUE_REGEX);
        String sessVars = jdbcUri.getPath();
        if (sessVars != null && !sessVars.isEmpty()) {
            String dbName = "";
            if (!(sessVars = sessVars.substring(1)).contains(";")) {
                dbName = sessVars;
            } else {
                dbName = sessVars.substring(0, sessVars.indexOf(59));
                if ((sessVars = sessVars.substring(sessVars.indexOf(59) + 1)) != null) {
                    Matcher sessMatcher = pattern.matcher(sessVars);
                    while (sessMatcher.find()) {
                        params.getSessionVars().put(sessMatcher.group(1), sessMatcher.group(2));
                    }
                }
            }
            if (!dbName.isEmpty()) {
                params.setDbName(dbName);
            }
        }
        if ((confStr = jdbcUri.getQuery()) != null) {
            Matcher confMatcher = pattern.matcher(confStr);
            while (confMatcher.find()) {
                params.getLensConfs().put(confMatcher.group(1), confMatcher.group(2));
            }
        }
        if ((varStr = jdbcUri.getFragment()) != null) {
            Matcher varMatcher = pattern.matcher(varStr);
            while (varMatcher.find()) {
                params.getLensVars().put(varMatcher.group(1), varMatcher.group(2));
            }
        }
        UriBuilder baseUriBuilder = UriBuilder.fromUri((String)"http://0.0.0.0:9999/lensapi");
        if (jdbcUri.getHost() != null) {
            baseUriBuilder.host(jdbcUri.getHost());
        }
        if (jdbcUri.getPort() != -1) {
            baseUriBuilder.port(jdbcUri.getPort());
        }
        params.setBaseUrl(baseUriBuilder.build(new Object[0]).toString());
        return params;
    }

    private static synchronized void loadManifestAttributes() throws IOException {
        if (manifestAttributes != null) {
            return;
        }
        Class<JDBCUtils> clazz = JDBCUtils.class;
        String classContainer = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
        URL manifestUrl = new URL("jar:" + classContainer + "!/META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest(manifestUrl.openStream());
        manifestAttributes = manifest.getMainAttributes();
    }

    private static String fetchManifestAttribute(Attributes.Name attributeName) throws IOException {
        JDBCUtils.loadManifestAttributes();
        return manifestAttributes.getValue(attributeName);
    }

    static int getVersion(int tokenPosition) {
        int version = -1;
        try {
            String fullVersion = JDBCUtils.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
            String[] tokens = fullVersion.split("\\.");
            if (tokens != null && tokens.length > 0 && tokens[tokenPosition] != null) {
                version = Integer.parseInt(tokens[tokenPosition]);
            }
        }
        catch (Exception e) {
            version = -1;
        }
        return version;
    }

    static Properties parseUrlForPropertyInfo(String url, Properties info) throws SQLException {
        Properties urlProperties;
        Properties properties = urlProperties = info != null ? new Properties(info) : new Properties();
        if (url == null || !url.startsWith(URL_PREFIX)) {
            throw new SQLException("Invalid connection url :" + url);
        }
        LensConnectionParams params = JDBCUtils.parseUrl(url);
        urlProperties.put(DB_PROPERTY_KEY, params.getDbName());
        return urlProperties;
    }

    public static int getSQLType(String type) throws SQLException {
        if ("string".equalsIgnoreCase(type)) {
            return 12;
        }
        if ("varchar".equalsIgnoreCase(type)) {
            return 12;
        }
        if ("char".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("float".equalsIgnoreCase(type)) {
            return 6;
        }
        if ("double".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return 16;
        }
        if ("tinyint".equalsIgnoreCase(type)) {
            return -6;
        }
        if ("smallint".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("int".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("bigint".equalsIgnoreCase(type)) {
            return -5;
        }
        if ("date".equalsIgnoreCase(type)) {
            return 91;
        }
        if ("timestamp".equalsIgnoreCase(type)) {
            return 93;
        }
        if ("decimal".equalsIgnoreCase(type)) {
            return 3;
        }
        if ("binary".equalsIgnoreCase(type)) {
            return -2;
        }
        if ("map".equalsIgnoreCase(type)) {
            return 2000;
        }
        if ("array".equalsIgnoreCase(type)) {
            return 2003;
        }
        if ("struct".equalsIgnoreCase(type)) {
            return 2002;
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    static int columnDisplaySize(int columnType) throws SQLException {
        switch (columnType) {
            case 16: {
                return JDBCUtils.columnPrecision(columnType);
            }
            case 1: 
            case 12: {
                return JDBCUtils.columnPrecision(columnType);
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return JDBCUtils.columnPrecision(columnType) + 1;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return JDBCUtils.columnPrecision(columnType);
            }
            case 6: {
                return 24;
            }
            case 8: {
                return 25;
            }
            case 3: {
                return JDBCUtils.columnPrecision(columnType) + 2;
            }
            case 2000: 
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static int columnPrecision(int columnType) throws SQLException {
        switch (columnType) {
            case 16: {
                return 1;
            }
            case 1: 
            case 12: {
                return Integer.MAX_VALUE;
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return 29;
            }
            case 3: {
                return 5;
            }
            case 2000: 
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static int columnScale(int columnType) throws SQLException {
        switch (columnType) {
            case -6: 
            case -5: 
            case -2: 
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 91: {
                return 0;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: {
                return 9;
            }
            case 3: {
                return 5;
            }
            case 2000: 
            case 2002: 
            case 2003: {
                return 0;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static String columnClassName(int columnType) throws SQLException {
        switch (columnType) {
            case 16: {
                return Boolean.class.getName();
            }
            case 1: 
            case 12: {
                return String.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 91: {
                return Date.class.getName();
            }
            case 6: {
                return Float.class.getName();
            }
            case 8: {
                return Double.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case 3: {
                return BigInteger.class.getName();
            }
            case -2: {
                return byte[].class.getName();
            }
            case 2000: 
            case 2002: 
            case 2003: {
                return String.class.getName();
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }
}

