/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client;

import java.beans.ConstructorProperties;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.query.LensPreparedQuery;
import org.apache.lens.api.query.LensQuery;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryPlan;
import org.apache.lens.api.query.QueryPrepareHandle;
import org.apache.lens.api.query.QueryResult;
import org.apache.lens.api.query.QueryResultSetMetadata;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.api.result.LensAPIResult;
import org.apache.lens.client.LensClient;
import org.apache.lens.client.LensConnection;
import org.apache.lens.client.exceptions.LensAPIException;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensStatement {
    private static final Logger log = LoggerFactory.getLogger(LensStatement.class);
    private final LensConnection connection;
    private LensQuery query;

    public LensAPIResult<QueryHandle> execute(String sql, boolean waitForQueryToComplete, String queryName) throws LensAPIException {
        LensAPIResult<QueryHandle> lensAPIResult = this.executeQuery(sql, waitForQueryToComplete, queryName);
        this.query = this.getQuery((QueryHandle)lensAPIResult.getData());
        return lensAPIResult;
    }

    public void execute(String sql, String queryName) throws LensAPIException {
        QueryHandle handle = (QueryHandle)this.executeQuery(sql, true, queryName).getData();
        this.query = this.getQuery(handle);
    }

    public LensAPIResult<QueryHandle> executeQuery(String sql, boolean waitForQueryToComplete, String queryName) throws LensAPIException {
        LensAPIResult<QueryHandle> lensAPIResult = this.executeQuery(sql, queryName);
        if (waitForQueryToComplete) {
            this.waitForQueryToComplete((QueryHandle)lensAPIResult.getData());
        }
        return lensAPIResult;
    }

    public QueryHandle executeQuery(QueryPrepareHandle phandle, boolean waitForQueryToComplete, String queryName) {
        QueryHandle handle = this.executeQuery(phandle, queryName);
        if (waitForQueryToComplete) {
            this.waitForQueryToComplete(handle);
        }
        return handle;
    }

    public LensAPIResult<QueryPrepareHandle> prepareQuery(String sql, String queryName) throws LensAPIException {
        if (!this.connection.isOpen()) {
            throw new IllegalStateException("Lens Connection has to be established before querying");
        }
        Client client = this.connection.buildClient();
        WebTarget target = this.getPreparedQueriesWebTarget(client);
        Response response = target.request().post(Entity.entity((Object)this.prepareForm(sql, "PREPARE", queryName), (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (LensAPIResult)response.readEntity((GenericType)new GenericType<LensAPIResult<QueryPrepareHandle>>(){});
        }
        throw new LensAPIException((LensAPIResult)response.readEntity(LensAPIResult.class));
    }

    public LensAPIResult<QueryPlan> explainAndPrepare(String sql, String queryName) throws LensAPIException {
        if (!this.connection.isOpen()) {
            throw new IllegalStateException("Lens Connection has to be established before querying");
        }
        Client client = this.connection.buildClient();
        WebTarget target = this.getPreparedQueriesWebTarget(client);
        Response response = (Response)target.request().post(Entity.entity((Object)this.prepareForm(sql, "EXPLAIN_AND_PREPARE", queryName), (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), Response.class);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (LensAPIResult)response.readEntity((GenericType)new GenericType<LensAPIResult<QueryPlan>>(){});
        }
        throw new LensAPIException((LensAPIResult)response.readEntity(LensAPIResult.class));
    }

    private FormDataMultiPart prepareForm(String sql, String op, String queryName) {
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"sessionid").build(), (Object)this.connection.getSessionHandle(), MediaType.APPLICATION_XML_TYPE));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"query").build(), sql));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"operation").build(), op));
        if (!StringUtils.isBlank((String)queryName)) {
            mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"queryName").build(), queryName));
        }
        mp.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"conf").fileName("conf")).build(), (Object)new LensConf(), MediaType.APPLICATION_XML_TYPE));
        return mp;
    }

    public void waitForQueryToComplete(QueryHandle handle) {
        LensClient.getCliLooger().info("Query handle: {}", (Object)handle);
        this.query = this.getQuery(handle);
        while (this.query.queued()) {
            this.query = this.getQuery(handle);
            LensClient.getCliLooger().debug("Query {} status: {}", (Object)handle, (Object)this.query.getStatus());
            try {
                Thread.sleep(this.connection.getLensConnectionParams().getQueryPollInterval());
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        LensClient.getCliLooger().info("User query: '{}' was submitted to {}", (Object)this.query.getUserQuery(), (Object)this.query.getSelectedDriverName());
        if (this.query.getDriverQuery() != null) {
            LensClient.getCliLooger().info(" Driver query: '{}' and Driver handle: {}", (Object)this.query.getDriverQuery(), (Object)this.query.getDriverOpHandle());
        }
        while (!this.query.getStatus().finished() && !this.query.getStatus().toString().equals(QueryStatus.Status.CLOSED.toString())) {
            this.query = this.getQuery(handle);
            LensClient.getCliLooger().info("Query Status:{} ", (Object)this.query.getStatus());
            try {
                Thread.sleep(this.connection.getLensConnectionParams().getQueryPollInterval());
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private WebTarget getQueryWebTarget(Client client) {
        return client.target(this.connection.getLensConnectionParams().getBaseConnectionUrl()).path(this.connection.getLensConnectionParams().getQueryResourcePath()).path("queries");
    }

    private WebTarget getPreparedQueriesWebTarget(Client client) {
        return client.target(this.connection.getLensConnectionParams().getBaseConnectionUrl()).path(this.connection.getLensConnectionParams().getQueryResourcePath()).path("preparedqueries");
    }

    public LensQuery getQuery(QueryHandle handle) {
        try {
            Client client = this.connection.buildClient();
            WebTarget target = this.getQueryWebTarget(client);
            this.query = (LensQuery)target.path(handle.toString()).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().get(LensQuery.class);
            return this.query;
        }
        catch (Exception e) {
            log.error("Failed to get query status, cause:", (Throwable)e);
            throw new IllegalStateException("Failed to get query status, cause:" + e.getMessage());
        }
    }

    public LensPreparedQuery getPreparedQuery(QueryPrepareHandle handle) {
        try {
            Client client = this.connection.buildClient();
            WebTarget target = this.getPreparedQueriesWebTarget(client);
            return (LensPreparedQuery)target.path(handle.toString()).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().get(LensPreparedQuery.class);
        }
        catch (Exception e) {
            log.error("Failed to get prepared query, cause:", (Throwable)e);
            throw new IllegalStateException("Failed to get prepared query, cause:" + e.getMessage());
        }
    }

    private LensAPIResult<QueryHandle> executeQuery(String sql, String queryName) throws LensAPIException {
        if (!this.connection.isOpen()) {
            throw new IllegalStateException("Lens Connection has to be established before querying");
        }
        Client client = this.connection.buildClient();
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"sessionid").build(), (Object)this.connection.getSessionHandle(), MediaType.APPLICATION_XML_TYPE));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"query").build(), sql));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"operation").build(), "execute"));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"queryName").build(), queryName == null ? "" : queryName));
        mp.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"conf").fileName("conf")).build(), (Object)new LensConf(), MediaType.APPLICATION_XML_TYPE));
        WebTarget target = this.getQueryWebTarget(client);
        Response response = target.request().post(Entity.entity((Object)mp, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (LensAPIResult)response.readEntity((GenericType)new GenericType<LensAPIResult<QueryHandle>>(){});
        }
        throw new LensAPIException((LensAPIResult)response.readEntity(LensAPIResult.class));
    }

    public QueryHandle executeQuery(QueryPrepareHandle phandle, String queryName) {
        if (!this.connection.isOpen()) {
            throw new IllegalStateException("Lens Connection has to be established before querying");
        }
        Client client = this.connection.buildClient();
        WebTarget target = this.getPreparedQueriesWebTarget(client).path(phandle.toString());
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"sessionid").build(), (Object)this.connection.getSessionHandle(), MediaType.APPLICATION_XML_TYPE));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"operation").build(), "execute"));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"queryName").build(), queryName == null ? "" : queryName));
        mp.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"conf").fileName("conf")).build(), (Object)new LensConf(), MediaType.APPLICATION_XML_TYPE));
        QueryHandle handle = (QueryHandle)target.request().post(Entity.entity((Object)mp, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), QueryHandle.class);
        return handle;
    }

    public LensAPIResult<QueryPlan> explainQuery(String sql) throws LensAPIException {
        if (!this.connection.isOpen()) {
            throw new IllegalStateException("Lens Connection has to be established before querying");
        }
        Client client = this.connection.buildClient();
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"sessionid").build(), (Object)this.connection.getSessionHandle(), MediaType.APPLICATION_XML_TYPE));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"query").build(), sql));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"operation").build(), "explain"));
        mp.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"conf").fileName("conf")).build(), (Object)new LensConf(), MediaType.APPLICATION_XML_TYPE));
        WebTarget target = this.getQueryWebTarget(client);
        Response response = target.request().post(Entity.entity((Object)mp, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (LensAPIResult)response.readEntity((GenericType)new GenericType<LensAPIResult<QueryPlan>>(){});
        }
        throw new LensAPIException((LensAPIResult)response.readEntity(LensAPIResult.class));
    }

    public List<QueryHandle> getAllQueries(String state, String queryName, String user, String driver, long fromDate, long toDate) {
        WebTarget target = this.getQueryWebTarget(this.connection.buildClient());
        List handles = (List)target.queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("state", new Object[]{state}).queryParam("queryName", new Object[]{queryName}).queryParam("user", new Object[]{user}).queryParam("driver", new Object[]{driver}).queryParam("fromDate", new Object[]{fromDate}).queryParam("toDate", new Object[]{toDate}).request().get((GenericType)new GenericType<List<QueryHandle>>(){});
        return handles;
    }

    public List<QueryPrepareHandle> getAllPreparedQueries(String userName, String queryName, long fromDate, long toDate) {
        Client client = this.connection.buildClient();
        WebTarget target = this.getPreparedQueriesWebTarget(client);
        List handles = (List)target.queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("user", new Object[]{userName}).queryParam("queryName", new Object[]{queryName}).queryParam("fromDate", new Object[]{fromDate}).queryParam("toDate", new Object[]{toDate}).request().get((GenericType)new GenericType<List<QueryPrepareHandle>>(){});
        return handles;
    }

    public QueryResultSetMetadata getResultSetMetaData() {
        return this.getResultSetMetaData(this.query);
    }

    public QueryResultSetMetadata getResultSetMetaData(LensQuery query) {
        if (query.getStatus().getStatus() != QueryStatus.Status.SUCCESSFUL) {
            throw new IllegalArgumentException("Result set metadata can be only queries for successful queries");
        }
        Client client = this.connection.buildClient();
        try {
            WebTarget target = this.getQueryWebTarget(client);
            return (QueryResultSetMetadata)target.path(query.getQueryHandle().toString()).path("resultsetmetadata").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().get(QueryResultSetMetadata.class);
        }
        catch (Exception e) {
            log.error("Failed to get resultset metadata, cause:", (Throwable)e);
            throw new IllegalStateException("Failed to get resultset metadata, cause:" + e.getMessage());
        }
    }

    public QueryResult getResultSet() {
        return this.getResultSet(this.query);
    }

    public Response getHttpResultSet() {
        return this.getHttpResultSet(this.query);
    }

    public QueryResult getResultSet(LensQuery query) {
        if (query.getStatus().getStatus() != QueryStatus.Status.SUCCESSFUL) {
            throw new IllegalArgumentException("Result set metadata can be only queries for successful queries");
        }
        Client client = this.connection.buildClient();
        try {
            WebTarget target = this.getQueryWebTarget(client);
            return (QueryResult)target.path(query.getQueryHandle().toString()).path("resultset").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(QueryResult.class);
        }
        catch (Exception e) {
            log.error("Failed to get resultset, cause:", (Throwable)e);
            throw new IllegalStateException("Failed to get resultset, cause:" + e.getMessage());
        }
    }

    public Response getHttpResultSet(LensQuery query) {
        if (query.getStatus().getStatus() != QueryStatus.Status.SUCCESSFUL) {
            throw new IllegalArgumentException("Result set metadata can be only queries for successful queries");
        }
        Client client = this.connection.buildClient();
        try {
            WebTarget target = this.getQueryWebTarget(client);
            return target.path(query.getQueryHandle().toString()).path("httpresultset").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().get();
        }
        catch (Exception e) {
            log.error("Failed to get http resultset, cause:", (Throwable)e);
            throw new IllegalStateException("Failed to get http resultset, cause:" + e.getMessage());
        }
    }

    public boolean kill() {
        return this.kill(this.query);
    }

    public boolean kill(LensQuery query) {
        if (query.getStatus().finished()) {
            return false;
        }
        Client client = this.connection.buildClient();
        WebTarget target = this.getQueryWebTarget(client);
        APIResult result = (APIResult)target.path(query.getQueryHandle().toString()).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().delete(APIResult.class);
        return result.getStatus().equals((Object)APIResult.Status.SUCCEEDED);
    }

    public boolean closeResultSet() {
        if (!this.query.getStatus().isResultSetAvailable()) {
            return false;
        }
        Client client = this.connection.buildClient();
        WebTarget target = this.getQueryWebTarget(client);
        APIResult result = (APIResult)target.path(this.query.getQueryHandle().toString()).path("resultset").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().delete(APIResult.class);
        return result.getStatus() == APIResult.Status.SUCCEEDED;
    }

    public boolean destroyPrepared(QueryPrepareHandle phandle) {
        Client client = this.connection.buildClient();
        WebTarget target = this.getPreparedQueriesWebTarget(client);
        APIResult result = (APIResult)target.path(phandle.toString()).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().delete(APIResult.class);
        return result.getStatus() == APIResult.Status.SUCCEEDED;
    }

    public boolean isIdle() {
        return this.query == null || this.query.getStatus().finished();
    }

    public boolean wasQuerySuccessful() {
        return this.query.getStatus().getStatus().equals((Object)QueryStatus.Status.SUCCESSFUL);
    }

    public QueryStatus getStatus() {
        return this.getQuery().getStatus();
    }

    public LensQuery getQuery() {
        return this.query;
    }

    public int getErrorCode() {
        return this.query.getErrorCode();
    }

    public String getErrorMessage() {
        return this.query.getErrorMessage();
    }

    public String getQueryHandleString() {
        return this.query.getQueryHandleString();
    }

    @ConstructorProperties(value={"connection"})
    public LensStatement(LensConnection connection) {
        this.connection = connection;
    }
}

