/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.DateTime;
import org.apache.lens.api.StringList;
import org.apache.lens.api.jaxb.LensJAXBContext;
import org.apache.lens.api.metastore.ObjectFactory;
import org.apache.lens.api.metastore.XCube;
import org.apache.lens.api.metastore.XDimension;
import org.apache.lens.api.metastore.XDimensionTable;
import org.apache.lens.api.metastore.XFactTable;
import org.apache.lens.api.metastore.XFlattenedColumns;
import org.apache.lens.api.metastore.XJoinChains;
import org.apache.lens.api.metastore.XNativeTable;
import org.apache.lens.api.metastore.XPartition;
import org.apache.lens.api.metastore.XPartitionList;
import org.apache.lens.api.metastore.XStorage;
import org.apache.lens.api.metastore.XStorageTableElement;
import org.apache.lens.client.LensConnection;
import org.apache.lens.client.LensConnectionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensMetadataClient {
    private static final Logger log = LoggerFactory.getLogger(LensMetadataClient.class);
    private final LensConnection connection;
    private final LensConnectionParams params;
    private final ObjectFactory objFact;
    public static final Unmarshaller JAXB_UNMARSHALLER;

    public LensMetadataClient(LensConnection connection) {
        this.connection = connection;
        this.params = connection.getLensConnectionParams();
        this.objFact = new ObjectFactory();
    }

    private WebTarget getMetastoreWebTarget(Client client) {
        return client.target(this.params.getBaseConnectionUrl()).path(this.params.getMetastoreResourcePath());
    }

    private WebTarget getMetastoreWebTarget() {
        return this.getMetastoreWebTarget(this.connection.buildClient());
    }

    public List<String> getAlldatabases() {
        WebTarget target = this.getMetastoreWebTarget();
        StringList databases = (StringList)target.path("databases").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().get(StringList.class);
        return databases.getElements();
    }

    public String getCurrentDatabase() {
        WebTarget target = this.getMetastoreWebTarget();
        return (String)target.path("databases").path("current").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().get(String.class);
    }

    public APIResult setDatabase(String database) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("databases").path("current").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.xml((Object)database), APIResult.class);
    }

    public APIResult createDatabase(String database, boolean ignoreIfExists) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("databases").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("ignoreIfExisting", new Object[]{ignoreIfExists}).request(new String[]{"application/xml"}).post(Entity.xml((Object)database), APIResult.class);
    }

    public APIResult createDatabase(String database) {
        return this.createDatabase(database, false);
    }

    public APIResult dropDatabase(String database, boolean cascade) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("databases").path(database).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("cascade", new Object[]{cascade}).request().delete(APIResult.class);
    }

    public APIResult dropDatabase(String database) {
        return this.dropDatabase(database, false);
    }

    public List<String> getAllNativeTables() {
        WebTarget target = this.getMetastoreWebTarget();
        StringList nativetables = (StringList)target.path("nativetables").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().get(StringList.class);
        return nativetables.getElements();
    }

    public XNativeTable getNativeTable(String tblName) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement htable = (JAXBElement)target.path("nativetables").path(tblName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XNativeTable>>(){});
        return (XNativeTable)htable.getValue();
    }

    public List<String> getAllCubes() {
        WebTarget target = this.getMetastoreWebTarget();
        StringList cubes = (StringList)target.path("cubes").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(StringList.class);
        return cubes.getElements();
    }

    public APIResult dropAllCubes() {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("cubes").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult createCube(XCube cube) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("cubes").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XCube>>(this.objFact.createXCube(cube)){}), APIResult.class);
    }

    private <T> T readFromXML(String filename) throws JAXBException, IOException {
        if (filename.startsWith("/")) {
            return (T)((JAXBElement)JAXB_UNMARSHALLER.unmarshal(new File(filename))).getValue();
        }
        InputStream file = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (file == null) {
            throw new IOException("File not found:" + filename);
        }
        return (T)((JAXBElement)JAXB_UNMARSHALLER.unmarshal(file)).getValue();
    }

    public APIResult createCube(String cubeSpec) {
        try {
            return this.createCube((XCube)this.readFromXML(cubeSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult updateCube(String cubeName, XCube cube) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("cubes").path(cubeName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).put(Entity.xml((Object)new GenericEntity<JAXBElement<XCube>>(this.objFact.createXCube(cube)){}), APIResult.class);
    }

    public APIResult updateCube(String cubeName, String cubeSpec) {
        try {
            return this.updateCube(cubeName, (XCube)this.readFromXML(cubeSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public XCube getCube(String cubeName) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement cube = (JAXBElement)target.path("cubes").path(cubeName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XCube>>(){});
        return (XCube)cube.getValue();
    }

    public XFlattenedColumns getQueryableFields(String tableName, boolean flattened) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement fields = (JAXBElement)target.path("flattened").path(tableName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("add_chains", new Object[]{flattened}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XFlattenedColumns>>(){});
        return (XFlattenedColumns)fields.getValue();
    }

    public XJoinChains getJoinChains(String tableName) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement fields = (JAXBElement)target.path("chains").path(tableName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XJoinChains>>(){});
        return (XJoinChains)fields.getValue();
    }

    public APIResult dropCube(String cubeName) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("cubes").path(cubeName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public List<String> getAllDimensions() {
        WebTarget target = this.getMetastoreWebTarget();
        StringList dimensions = (StringList)target.path("dimensions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(StringList.class);
        return dimensions.getElements();
    }

    public APIResult dropAllDimensions() {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimensions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult createDimension(XDimension dimension) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimensions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XDimension>>(this.objFact.createXDimension(dimension)){}), APIResult.class);
    }

    public APIResult createDimension(String dimSpec) {
        try {
            return this.createDimension((XDimension)this.readFromXML(dimSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult updateDimension(String dimName, XDimension dimension) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimensions").path(dimName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).put(Entity.xml((Object)new GenericEntity<JAXBElement<XDimension>>(this.objFact.createXDimension(dimension)){}), APIResult.class);
    }

    public APIResult updateDimension(String dimName, String dimSpec) {
        try {
            return this.updateDimension(dimName, (XDimension)this.readFromXML(dimSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public XDimension getDimension(String dimName) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement dim = (JAXBElement)target.path("dimensions").path(dimName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XDimension>>(){});
        return (XDimension)dim.getValue();
    }

    public APIResult dropDimension(String dimName) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimensions").path(dimName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public List<String> getAllStorages() {
        WebTarget target = this.getMetastoreWebTarget();
        StringList storages = (StringList)target.path("storages").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request().get(StringList.class);
        return storages.getElements();
    }

    public APIResult createNewStorage(XStorage storage) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("storages").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XStorage>>(this.objFact.createXStorage(storage)){}), APIResult.class);
    }

    public APIResult createNewStorage(String storage) {
        try {
            return this.createNewStorage((XStorage)this.readFromXML(storage));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult dropAllStorages() {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("storages").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult updateStorage(String storageName, XStorage storage) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("storages").path(storageName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).put(Entity.xml((Object)new GenericEntity<JAXBElement<XStorage>>(this.objFact.createXStorage(storage)){}), APIResult.class);
    }

    public APIResult updateStorage(String storageName, String storage) {
        try {
            return this.updateStorage(storageName, (XStorage)this.readFromXML(storage));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public XStorage getStorage(String storageName) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement result = (JAXBElement)target.path("storages").path(storageName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XStorage>>(){});
        return (XStorage)result.getValue();
    }

    public APIResult dropStorage(String storageName) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("storages").path(storageName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public List<String> getAllFactTables(String cubeName) {
        if (cubeName == null) {
            return this.getAllFactTables();
        }
        WebTarget target = this.getMetastoreWebTarget();
        StringList factTables = (StringList)target.path("cubes").path(cubeName).path("facts").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(StringList.class);
        return factTables.getElements();
    }

    public List<String> getAllFactTables() {
        WebTarget target = this.getMetastoreWebTarget();
        StringList factTables = (StringList)target.path("facts").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(StringList.class);
        return factTables.getElements();
    }

    public APIResult deleteAllFactTables(boolean cascade) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("cascade", new Object[]{cascade}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public XFactTable getFactTable(String factTableName) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement table = (JAXBElement)target.path("facts").path(factTableName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XFactTable>>(){});
        return (XFactTable)table.getValue();
    }

    public APIResult createFactTable(XFactTable f) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XFactTable>>(this.objFact.createXFactTable(f)){}), APIResult.class);
    }

    public APIResult createFactTable(String factSpec) {
        try {
            return this.createFactTable((XFactTable)this.readFromXML(factSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult updateFactTable(String factName, XFactTable table) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(factName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.xml((Object)new GenericEntity<JAXBElement<XFactTable>>(this.objFact.createXFactTable(table)){}), APIResult.class);
    }

    public APIResult updateFactTable(String factName, String table) {
        try {
            return this.updateFactTable(factName, (XFactTable)this.readFromXML(table));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult dropFactTable(String factName, boolean cascade) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(factName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("cascade", new Object[]{cascade}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult dropFactTable(String factName) {
        return this.dropFactTable(factName, false);
    }

    public List<String> getAllStoragesOfFactTable(String factName) {
        WebTarget target = this.getMetastoreWebTarget();
        StringList storageList = (StringList)target.path("facts").path(factName).path("storages").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(StringList.class);
        return storageList.getElements();
    }

    public APIResult dropAllStoragesOfFactTable(String factName) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(factName).path("storages").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult addStorageToFactTable(String factname, XStorageTableElement storage) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(factname).path("storages").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XStorageTableElement>>(this.objFact.createXStorageTableElement(storage)){}), APIResult.class);
    }

    public APIResult addStorageToFactTable(String factname, String storageSpec) {
        try {
            return this.addStorageToFactTable(factname, (XStorageTableElement)this.readFromXML(storageSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult dropStorageFromFactTable(String factName, String storageName) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(factName).path("storages").path(storageName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public XStorageTableElement getStorageOfFactTable(String factName, String storageName) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement element = (JAXBElement)target.path("facts").path(factName).path("storages").path(storageName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XStorageTableElement>>(){});
        return (XStorageTableElement)element.getValue();
    }

    public List<XPartition> getPartitionsOfFactTable(String factName, String storage, String filter) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement elements = (JAXBElement)target.path("facts").path(factName).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("filter", new Object[]{filter}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XPartitionList>>(){});
        return ((XPartitionList)elements.getValue()).getPartition();
    }

    public List<XPartition> getPartitionsOfFactTable(String factName, String storage) {
        return this.getPartitionsOfFactTable(factName, storage, "");
    }

    public APIResult dropPartitionsOfFactTable(String factName, String storage, String filter) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(factName).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("filter", new Object[]{filter}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult dropPartitionsOfFactTable(String factName, String storage) {
        return this.dropPartitionsOfFactTable(factName, storage, "");
    }

    public APIResult dropPartitionsOfFactTable(String factName, String storage, List<String> partitions) {
        String values = Joiner.on((String)",").skipNulls().join(partitions);
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(factName).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("values", new Object[]{values}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public List<String> getAllDimensionTables(String dimensionName) {
        if (dimensionName == null) {
            return this.getAllDimensionTables();
        }
        WebTarget target = this.getMetastoreWebTarget();
        StringList dimtables = (StringList)target.path("dimensions").path(dimensionName).path("dimtables").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(StringList.class);
        return dimtables.getElements();
    }

    public List<String> getAllDimensionTables() {
        WebTarget target = this.getMetastoreWebTarget();
        StringList dimtables = (StringList)target.path("dimtables").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(StringList.class);
        return dimtables.getElements();
    }

    public APIResult createDimensionTable(XDimensionTable table) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XDimensionTable>>(this.objFact.createXDimensionTable(table)){}), APIResult.class);
    }

    public APIResult createDimensionTable(String tableXml) {
        try {
            return this.createDimensionTable((XDimensionTable)this.readFromXML(tableXml));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult updateDimensionTable(XDimensionTable table) {
        String dimTableName = table.getTableName();
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTableName).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).put(Entity.xml((Object)new GenericEntity<JAXBElement<XDimensionTable>>(this.objFact.createXDimensionTable(table)){}), APIResult.class);
    }

    public APIResult updateDimensionTable(String dimTblName, String dimSpec) {
        try {
            XDimensionTable dimensionTable = (XDimensionTable)this.readFromXML(dimSpec);
            dimensionTable.setTableName(dimTblName);
            return this.updateDimensionTable(dimensionTable);
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult dropDimensionTable(String table, boolean cascade) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(table).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("cascade", new Object[]{cascade}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult dropDimensionTable(String table) {
        return this.dropDimensionTable(table, false);
    }

    public XDimensionTable getDimensionTable(String table) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement result = (JAXBElement)target.path("dimtables").path(table).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XDimensionTable>>(){});
        return (XDimensionTable)result.getValue();
    }

    public List<String> getAllStoragesOfDimTable(String dimTblName) {
        WebTarget target = this.getMetastoreWebTarget();
        StringList list = (StringList)target.path("dimtables").path(dimTblName).path("storages").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(StringList.class);
        return list.getElements();
    }

    public APIResult addStorageToDimTable(String dimTblName, XStorageTableElement table) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTblName).path("storages").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XStorageTableElement>>(this.objFact.createXStorageTableElement(table)){}), APIResult.class);
    }

    public APIResult addStorageToDimTable(String dimTblName, String table) {
        try {
            return this.addStorageToDimTable(dimTblName, (XStorageTableElement)this.readFromXML(table));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public XStorageTableElement getStorageOfDimensionTable(String dimTblName, String storage) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement result = (JAXBElement)target.path("dimtables").path(dimTblName).path("storages").path(storage).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XStorageTableElement>>(){});
        return (XStorageTableElement)result.getValue();
    }

    public APIResult dropAllStoragesOfDimension(String dimTblName) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTblName).path("storages").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult dropStoragesOfDimensionTable(String dimTblName, String storage) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTblName).path("storages").path(storage).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public List<XPartition> getAllPartitionsOfDimensionTable(String dimTblName, String storage, String filter) {
        WebTarget target = this.getMetastoreWebTarget();
        JAXBElement partList = (JAXBElement)target.path("dimtables").path(dimTblName).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("filter", new Object[]{filter}).request(new String[]{"application/xml"}).get((GenericType)new GenericType<JAXBElement<XPartitionList>>(){});
        return ((XPartitionList)partList.getValue()).getPartition();
    }

    public List<XPartition> getAllPartitionsOfDimensionTable(String dimTblName, String storage) {
        return this.getAllPartitionsOfDimensionTable(dimTblName, storage, "");
    }

    public APIResult dropAllPartitionsOfDimensionTable(String dimTblName, String storage, String filter) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTblName).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("filter", new Object[]{filter}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult dropAllPartitionsOfDimensionTable(String dimTblName, String storage) {
        return this.dropAllPartitionsOfDimensionTable(dimTblName, storage, "");
    }

    public APIResult dropAllPartitionsOfDimensionTable(String dimTblName, String storage, List<String> vals) {
        String values = Joiner.on((String)",").skipNulls().join(vals);
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTblName).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).queryParam("values", new Object[]{values}).request(new String[]{"application/xml"}).delete(APIResult.class);
    }

    public APIResult addPartitionToDimensionTable(String dimTblName, String storage, XPartition partition) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTblName).path("storages").path(storage).path("partition").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XPartition>>(this.objFact.createXPartition(partition)){}), APIResult.class);
    }

    public APIResult addPartitionToDimensionTable(String dimTblName, String storage, String partitionSpec) {
        try {
            return this.addPartitionToDimensionTable(dimTblName, storage, (XPartition)this.readFromXML(partitionSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult addPartitionsToDimensionTable(String dimTblName, String storage, XPartitionList partitions) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTblName).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XPartitionList>>(this.objFact.createXPartitionList(partitions)){}), APIResult.class);
    }

    public APIResult addPartitionsToDimensionTable(String dimTblName, String storage, String partitionsSpec) {
        try {
            return this.addPartitionsToDimensionTable(dimTblName, storage, (XPartitionList)this.readFromXML(partitionsSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult addPartitionToFactTable(String fact, String storage, XPartition partition) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(fact).path("storages").path(storage).path("partition").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XPartition>>(this.objFact.createXPartition(partition)){}), APIResult.class);
    }

    public APIResult addPartitionToFactTable(String fact, String storage, String partitionSpec) {
        try {
            return this.addPartitionToFactTable(fact, storage, (XPartition)this.readFromXML(partitionSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult addPartitionsToFactTable(String fact, String storage, XPartitionList partitions) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(fact).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).post(Entity.xml((Object)new GenericEntity<JAXBElement<XPartitionList>>(this.objFact.createXPartitionList(partitions)){}), APIResult.class);
    }

    public APIResult addPartitionsToFactTable(String fact, String storage, String partitionsSpec) {
        try {
            return this.addPartitionsToFactTable(fact, storage, (XPartitionList)this.readFromXML(partitionsSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult updatePartitionOfDimensionTable(String dimTblName, String storage, XPartition partition) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTblName).path("storages").path(storage).path("partition").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).put(Entity.xml((Object)new GenericEntity<JAXBElement<XPartition>>(this.objFact.createXPartition(partition)){}), APIResult.class);
    }

    public APIResult updatePartitionOfDimensionTable(String dimTblName, String storage, String partitionSpec) {
        try {
            return this.updatePartitionOfDimensionTable(dimTblName, storage, (XPartition)this.readFromXML(partitionSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult updatePartitionsOfDimensionTable(String dimTblName, String storage, XPartitionList partitions) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("dimtables").path(dimTblName).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).put(Entity.xml((Object)new GenericEntity<JAXBElement<XPartitionList>>(this.objFact.createXPartitionList(partitions)){}), APIResult.class);
    }

    public APIResult updatePartitionsOfDimensionTable(String dimTblName, String storage, String partitionsSpec) {
        try {
            return this.updatePartitionsOfDimensionTable(dimTblName, storage, (XPartitionList)this.readFromXML(partitionsSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult updatePartitionOfFactTable(String fact, String storage, XPartition partition) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(fact).path("storages").path(storage).path("partition").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).put(Entity.xml((Object)new GenericEntity<JAXBElement<XPartition>>(this.objFact.createXPartition(partition)){}), APIResult.class);
    }

    public APIResult updatePartitionOfFactTable(String fact, String storage, String partitionSpec) {
        try {
            return this.updatePartitionOfFactTable(fact, storage, (XPartition)this.readFromXML(partitionSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public APIResult updatePartitionsOfFactTable(String fact, String storage, XPartitionList partitions) {
        WebTarget target = this.getMetastoreWebTarget();
        return (APIResult)target.path("facts").path(fact).path("storages").path(storage).path("partitions").queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).put(Entity.xml((Object)new GenericEntity<JAXBElement<XPartitionList>>(this.objFact.createXPartitionList(partitions)){}), APIResult.class);
    }

    public APIResult updatePartitionsOfFactTable(String fact, String storage, String partitionsSpec) {
        try {
            return this.updatePartitionsOfFactTable(fact, storage, (XPartitionList)this.readFromXML(partitionsSpec));
        }
        catch (IOException | JAXBException e) {
            return this.failureAPIResult((Exception)e);
        }
    }

    public Date getLatestDateOfCube(String cubeName, String timePartition) {
        return ((DateTime)this.getMetastoreWebTarget().path("cubes").path(cubeName).path("latestdate").queryParam("timeDimension", new Object[]{timePartition}).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(DateTime.class)).getDate();
    }

    public List<String> getPartitionTimelines(String factName, String storageName, String updatePeriod, String timeDimension) {
        return ((StringList)this.getMetastoreWebTarget().path("facts").path(factName).path("timelines").queryParam("storage", new Object[]{storageName}).queryParam("updatePeriod", new Object[]{updatePeriod}).queryParam("timeDimension", new Object[]{timeDimension}).queryParam("sessionid", new Object[]{this.connection.getSessionHandle()}).request(new String[]{"application/xml"}).get(StringList.class)).getElements();
    }

    private APIResult failureAPIResult(Exception e) {
        log.error("Failed", (Throwable)e);
        return APIResult.failure((Exception)e);
    }

    static {
        try {
            LensJAXBContext jaxbContext = new LensJAXBContext(new Class[]{ObjectFactory.class});
            JAXB_UNMARSHALLER = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            log.error("Could not initialize JAXBContext. ", (Throwable)e);
            throw new RuntimeException("Could not initialize JAXBContext. ", e);
        }
    }
}

