/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lens.api.LensConf;
import org.apache.lens.client.LensClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensConnectionParams {
    private static final Logger log = LoggerFactory.getLogger(LensConnectionParams.class);
    private Map<String, String> lensConfs = new HashMap<String, String>();
    private Map<String, String> lensVars = new HashMap<String, String>();
    private Map<String, String> sessionVars = new HashMap<String, String>();
    private final LensClientConfig conf;
    private Set<Class<?>> requestFilters = new HashSet();

    private void setupRequestFilters() {
        if (this.conf.get("lens.client.ws.request.filternames") != null) {
            String[] filterNames;
            for (String filterName : filterNames = this.conf.getStrings("lens.client.ws.request.filternames")) {
                Class wsFilterClass = this.conf.getClass(LensClientConfig.getWSFilterImplConfKey(filterName), null);
                if (wsFilterClass != null) {
                    this.requestFilters.add(wsFilterClass);
                }
                log.info("Request filter added " + filterName);
            }
        }
    }

    public LensConnectionParams() {
        this.conf = new LensClientConfig();
        this.setupRequestFilters();
    }

    public LensConnectionParams(LensClientConfig conf) {
        this.conf = conf;
        this.setupRequestFilters();
    }

    public String getDbName() {
        return this.conf.getLensDatabase();
    }

    public Map<String, String> getLensConfs() {
        return this.lensConfs;
    }

    public Map<String, String> getLensVars() {
        return this.lensVars;
    }

    public Map<String, String> getSessionVars() {
        return this.sessionVars;
    }

    public void setDbName(String dbName) {
        this.conf.setLensDatabase(dbName);
    }

    public String getBaseConnectionUrl() {
        return this.conf.getBaseURL();
    }

    public LensClientConfig getConf() {
        return this.conf;
    }

    public String getUser() {
        return this.conf.getUser();
    }

    public String getSessionResourcePath() {
        return this.conf.getSessionResourcePath();
    }

    public String getQueryResourcePath() {
        return this.conf.getQueryResourcePath();
    }

    public String getMetastoreResourcePath() {
        return this.conf.getMetastoreResourcePath();
    }

    public String getLogResourcePath() {
        return this.conf.getLogResourcePath();
    }

    public long getQueryPollInterval() {
        return this.conf.getQueryPollInterval();
    }

    public LensConf getSessionConf() {
        LensConf conf = new LensConf();
        Iterator itr = this.conf.iterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            conf.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.lensConfs.entrySet()) {
            conf.addProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.sessionVars.entrySet()) {
            conf.addProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.lensVars.entrySet()) {
            conf.addProperty(entry.getKey(), entry.getValue());
        }
        return conf;
    }

    public String toString() {
        return "LensConnectionParams{" + "dbName='" + this.conf.getLensDatabase() + '\'' + ", baseUrl='" + this.conf.getBaseURL() + '\'' + ", user=" + this.conf.getUser() + ", lensConfs=" + this.lensConfs + ", lensVars=" + this.lensVars + ", sessionVars=" + this.sessionVars + '}';
    }

    public void setBaseUrl(String baseUrl) {
        this.conf.setBaseUrl(baseUrl);
    }

    public Set<Class<?>> getRequestFilters() {
        return this.requestFilters;
    }
}

