/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client;

import org.apache.lens.client.LensConnection;
import org.apache.lens.client.LensConnectionParams;

public class LensConnectionBuilder {
    private String baseUrl;
    private String database;
    private String user;
    private String password;

    public LensConnectionBuilder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public LensConnectionBuilder database(String database) {
        this.database = database;
        return this;
    }

    public LensConnectionBuilder user(String user) {
        this.user = user;
        return this;
    }

    public LensConnectionBuilder password(String password) {
        this.password = password;
        return this;
    }

    public LensConnection build() {
        LensConnectionParams params = new LensConnectionParams();
        if (this.baseUrl != null && !this.baseUrl.isEmpty()) {
            params.setBaseUrl(this.baseUrl);
        }
        if (this.database != null && !this.database.isEmpty()) {
            params.setDbName(this.database);
        }
        if (this.user != null && !this.user.isEmpty()) {
            params.getSessionVars().put("user.name", this.user);
        }
        if (this.password != null && !this.password.isEmpty()) {
            params.getSessionVars().put("user.pass", this.password);
        }
        return new LensConnection(params);
    }
}

