/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client;

import java.net.ConnectException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.api.StringList;
import org.apache.lens.api.util.MoxyJsonConfigurationContextResolver;
import org.apache.lens.client.LensConnectionParams;
import org.apache.lens.client.exceptions.LensClientServerConnectionException;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.moxy.json.MoxyJsonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensConnection {
    private static final Logger log = LoggerFactory.getLogger(LensConnection.class);
    private final LensConnectionParams params;
    private AtomicBoolean open = new AtomicBoolean(false);
    private LensSessionHandle sessionHandle;

    public LensConnection(LensConnectionParams params) {
        this.params = params;
    }

    public LensConnection(LensConnectionParams params, LensSessionHandle sessionHandle) {
        this.params = params;
        this.sessionHandle = sessionHandle;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    private WebTarget getSessionWebTarget(Client client) {
        return client.target(this.params.getBaseConnectionUrl()).path(this.params.getSessionResourcePath());
    }

    private WebTarget getMetastoreWebTarget(Client client) {
        return client.target(this.params.getBaseConnectionUrl()).path(this.params.getMetastoreResourcePath());
    }

    public Client buildClient() {
        ClientBuilder cb = (ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(MultiPartFeature.class)).register(MoxyJsonFeature.class)).register(MoxyJsonConfigurationContextResolver.class);
        Iterator<Class<?>> itr = this.params.getRequestFilters().iterator();
        while (itr.hasNext()) {
            cb.register(itr.next());
        }
        return cb.build();
    }

    private WebTarget getSessionWebTarget() {
        return this.getSessionWebTarget(this.buildClient());
    }

    private WebTarget getMetastoreWebTarget() {
        return this.getMetastoreWebTarget(this.buildClient());
    }

    public WebTarget getLogWebTarget() {
        Client client = this.buildClient();
        return this.getLogWebTarget(client);
    }

    public WebTarget getLogWebTarget(Client client) {
        return client.target(this.params.getBaseConnectionUrl()).path(this.params.getLogResourcePath());
    }

    public LensSessionHandle open(String password) {
        block4: {
            WebTarget target = this.getSessionWebTarget();
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"username").build(), this.params.getUser()));
            mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"password").build(), password));
            String database = this.params.getDbName();
            mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"database").build(), database));
            mp.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"sessionconf").fileName("sessionconf")).build(), (Object)this.params.getSessionConf(), MediaType.APPLICATION_XML_TYPE));
            try {
                Response response = target.request().post(Entity.entity((Object)mp, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
                if (response.getStatus() != 200) {
                    throw new LensClientServerConnectionException(response.getStatus());
                }
                LensSessionHandle handle = (LensSessionHandle)response.readEntity(LensSessionHandle.class);
                if (handle == null) {
                    throw new IllegalStateException("Unable to connect to lens server with following paramters" + this.params);
                }
                this.sessionHandle = handle;
                log.debug("Created a new session {}", (Object)this.sessionHandle.getPublicId());
            }
            catch (ProcessingException e) {
                if (e.getCause() == null || !(e.getCause() instanceof ConnectException)) break block4;
                throw new LensClientServerConnectionException(e.getCause().getMessage(), (Exception)((Object)e));
            }
        }
        log.debug("Successfully switched to database {}", (Object)this.params.getDbName());
        this.open.set(true);
        return this.sessionHandle;
    }

    public APIResult attachDatabaseToSession() {
        WebTarget target = this.getMetastoreWebTarget();
        APIResult result = (APIResult)target.path("databases").path("current").queryParam("sessionid", new Object[]{this.sessionHandle}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.xml((Object)this.params.getDbName()), APIResult.class);
        return result;
    }

    public APIResult close() {
        WebTarget target = this.getSessionWebTarget();
        APIResult result = (APIResult)target.queryParam("sessionid", new Object[]{this.sessionHandle}).request().delete(APIResult.class);
        if (result.getStatus() != APIResult.Status.SUCCEEDED) {
            throw new IllegalStateException("Unable to close lens connection with params " + this.params);
        }
        log.debug("Lens connection closed.");
        return result;
    }

    public APIResult addResourceToConnection(String type, String resourcePath) {
        WebTarget target = this.getSessionWebTarget();
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"sessionid").build(), (Object)this.sessionHandle, MediaType.APPLICATION_XML_TYPE));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"type").build(), type));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"path").build(), resourcePath));
        APIResult result = (APIResult)target.path("resources/add").request().put(Entity.entity((Object)mp, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), APIResult.class);
        return result;
    }

    public APIResult removeResourceFromConnection(String type, String resourcePath) {
        WebTarget target = this.getSessionWebTarget();
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"sessionid").build(), (Object)this.sessionHandle, MediaType.APPLICATION_XML_TYPE));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"type").build(), type));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"path").build(), resourcePath));
        APIResult result = (APIResult)target.path("resources/delete").request().put(Entity.entity((Object)mp, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), APIResult.class);
        return result;
    }

    public List<String> listResourcesFromConnection(String type) {
        WebTarget target = this.getSessionWebTarget();
        StringList result = (StringList)target.path("resources/list").queryParam("sessionid", new Object[]{this.sessionHandle}).queryParam("type", new Object[]{type}).request().get(StringList.class);
        return result.getElements();
    }

    public Response getLogs(String logFile) {
        WebTarget target = this.getLogWebTarget();
        Response result = target.path(logFile).request(new String[]{"application/octet-stream"}).get();
        return result;
    }

    public APIResult setConnectionParams(String key, String value) {
        WebTarget target = this.getSessionWebTarget();
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"sessionid").build(), (Object)this.sessionHandle, MediaType.APPLICATION_XML_TYPE));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"key").build(), key));
        mp.bodyPart((BodyPart)new FormDataBodyPart(FormDataContentDisposition.name((String)"value").build(), value));
        log.debug("Setting connection params {}={}", (Object)key, (Object)value);
        APIResult result = (APIResult)target.path("params").request().put(Entity.entity((Object)mp, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), APIResult.class);
        return result;
    }

    public List<String> getConnectionParams() {
        WebTarget target = this.getSessionWebTarget();
        StringList list = (StringList)target.path("params").queryParam("sessionid", new Object[]{this.sessionHandle}).queryParam("verbose", new Object[]{true}).request().get(StringList.class);
        return list.getElements();
    }

    public List<String> getConnectionParams(String key) {
        WebTarget target = this.getSessionWebTarget();
        StringList value = (StringList)target.path("params").queryParam("sessionid", new Object[]{this.sessionHandle}).queryParam("key", new Object[]{key}).request().get(StringList.class);
        return value.getElements();
    }

    LensConnectionParams getLensConnectionParams() {
        return this.params;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LensConnection{");
        sb.append("sessionHandle=").append(this.sessionHandle.getPublicId());
        sb.append('}');
        return sb.toString();
    }

    public LensSessionHandle getSessionHandle() {
        return this.sessionHandle;
    }
}

