/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client;

import org.apache.lens.client.Credentials;
import org.apache.lens.client.LensClient;
import org.apache.lens.client.exceptions.LensClientServerConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensClientSingletonWrapper {
    private static final Logger log = LoggerFactory.getLogger(LensClientSingletonWrapper.class);
    private LensClient client;
    private static final int MAX_RETRIES = 3;

    public static LensClientSingletonWrapper instance() {
        return InstanceHolder.INSTANCE;
    }

    LensClientSingletonWrapper() {
    }

    public void explainFailedAttempt(LensClientServerConnectionException e) {
        log.error("failed login attempt", (Throwable)e);
        switch (e.getErrorCode()) {
            case 401: {
                System.console().printf("username/password combination incorrect.\n", new Object[0]);
                break;
            }
            case 500: {
                System.console().printf("server unresponsive, Returned error code 500\n", new Object[0]);
                break;
            }
            default: {
                System.console().printf("ERROR: " + e.getMessage() + "\n", new Object[0]);
            }
        }
    }

    public LensClient getClient() {
        if (this.client == null) {
            try {
                this.client = new LensClient();
            }
            catch (LensClientServerConnectionException e) {
                if (e.getErrorCode() != 401) {
                    this.explainFailedAttempt(e);
                    throw e;
                }
                for (int i = 0; i < 3; ++i) {
                    try {
                        this.client = new LensClient(Credentials.prompt());
                        break;
                    }
                    catch (LensClientServerConnectionException lensClientServerConnectionException) {
                        this.explainFailedAttempt(lensClientServerConnectionException);
                        if (i != 2) continue;
                        throw lensClientServerConnectionException;
                    }
                }
            }
        }
        return this.client;
    }

    public void setClient(LensClient client) {
        this.client = client;
    }

    public static class InstanceHolder {
        public static final LensClientSingletonWrapper INSTANCE = new LensClientSingletonWrapper();
    }
}

