/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client;

import org.apache.hadoop.conf.Configuration;

public class LensClientConfig
extends Configuration {
    public static final String CLIENT_PFX = "lens.client.";
    public static final String DBNAME_KEY = "lens.client.dbname";
    public static final String DEFAULT_DBNAME_VALUE = "default";
    private static final String QUERY_POLL_INTERVAL_KEY = "lens.client.query.poll.interval";
    private static final long DEFAULT_QUERY_POLL_INTERVAL = 10L;
    private static final String USER_NAME = "lens.client.user.name";
    public static final String DEFAULT_USER_NAME = "anonymous";
    private static final String DEFAULT_METASTORE_RESOURCE_PATH = "metastore";
    private static final String DEFAULT_QUERY_RESOURCE_PATH = "queryapi";
    public static final String DEFAULT_SESSION_RESOURCE_PATH = "session";
    public static final String DEFAULT_LOG_RESOURCE_PATH = "logs";
    public static final String SERVER_BASE_URL = "lens.server.base.url";
    public static final String DEFAULT_SERVER_BASE_URL = "http://0.0.0.0:9999/lensapi";
    public static final String SESSION_CLUSTER_USER = "lens.session.cluster.user";
    public static final String SESSION_FILTER_NAMES = "lens.client.ws.request.filternames";
    public static final String WS_FILTER_IMPL_SFX = ".ws.filter.impl";

    public LensClientConfig() {
        super(false);
        this.addResource("lens-client-default.xml");
        this.addResource("lens-client-site.xml");
    }

    public String getUser() {
        return this.get(USER_NAME, DEFAULT_USER_NAME);
    }

    public void setUser(String user) {
        this.set(USER_NAME, user);
    }

    public String getBaseURL() {
        return this.get(SERVER_BASE_URL, DEFAULT_SERVER_BASE_URL);
    }

    public String getLensDatabase() {
        return this.get(DBNAME_KEY, DEFAULT_DBNAME_VALUE);
    }

    public String getSessionResourcePath() {
        return DEFAULT_SESSION_RESOURCE_PATH;
    }

    public String getQueryResourcePath() {
        return DEFAULT_QUERY_RESOURCE_PATH;
    }

    public void setLensDatabase(String dbName) {
        this.set(DBNAME_KEY, dbName);
    }

    public long getQueryPollInterval() {
        return this.getLong(QUERY_POLL_INTERVAL_KEY, 10L);
    }

    public String getMetastoreResourcePath() {
        return DEFAULT_METASTORE_RESOURCE_PATH;
    }

    public void setBaseUrl(String baseUrl) {
        this.set(SERVER_BASE_URL, baseUrl);
    }

    public String getLogResourcePath() {
        return DEFAULT_LOG_RESOURCE_PATH;
    }

    public static String getWSFilterImplConfKey(String filterName) {
        return CLIENT_PFX + filterName + WS_FILTER_IMPL_SFX;
    }
}

