/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.metastore.XCube;
import org.apache.lens.api.metastore.XDimension;
import org.apache.lens.api.metastore.XDimensionTable;
import org.apache.lens.api.metastore.XFactTable;
import org.apache.lens.api.metastore.XFlattenedColumns;
import org.apache.lens.api.metastore.XJoinChains;
import org.apache.lens.api.metastore.XNativeTable;
import org.apache.lens.api.metastore.XPartition;
import org.apache.lens.api.metastore.XPartitionList;
import org.apache.lens.api.metastore.XStorage;
import org.apache.lens.api.metastore.XStorageTableElement;
import org.apache.lens.api.query.LensPreparedQuery;
import org.apache.lens.api.query.LensQuery;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryPlan;
import org.apache.lens.api.query.QueryPrepareHandle;
import org.apache.lens.api.query.QueryResult;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.api.result.LensAPIResult;
import org.apache.lens.api.util.PathValidator;
import org.apache.lens.client.Credentials;
import org.apache.lens.client.LensClientConfig;
import org.apache.lens.client.LensClientResultSet;
import org.apache.lens.client.LensConnection;
import org.apache.lens.client.LensConnectionParams;
import org.apache.lens.client.LensMetadataClient;
import org.apache.lens.client.LensStatement;
import org.apache.lens.client.exceptions.LensAPIException;
import org.apache.lens.client.exceptions.LensBriefErrorException;
import org.apache.lens.client.model.BriefError;
import org.apache.lens.client.model.IdBriefErrorTemplate;
import org.apache.lens.client.model.IdBriefErrorTemplateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LensClient {
    private static final Logger log = LoggerFactory.getLogger(LensClient.class);
    public static final String CLILOGGER = "cliLogger";
    private static final String DEFAULT_PASSWORD = "";
    private final LensClientConfig conf;
    private final LensMetadataClient mc;
    private String password;
    private LensConnection connection;
    private final HashMap<QueryHandle, LensStatement> statementMap = Maps.newHashMap();
    private final LensStatement statement;
    private PathValidator pathValidator;

    public static Logger getCliLooger() {
        return LoggerFactory.getLogger((String)CLILOGGER);
    }

    public LensClient() {
        this(new LensClientConfig());
    }

    public LensClient(LensClientConfig conf) {
        this(conf, conf.getUser(), DEFAULT_PASSWORD);
    }

    public LensClient(String username, String password) {
        this(new LensClientConfig(), username, password);
    }

    public LensClient(LensClientConfig conf, String username, String password) {
        this.conf = conf;
        conf.setUser(username);
        this.password = password;
        if (this.conf.get("lens.session.cluster.user") == null) {
            this.conf.set("lens.session.cluster.user", System.getProperty("user.name"));
        }
        this.connectToLensServer();
        this.mc = new LensMetadataClient(this.connection);
        this.statement = new LensStatement(this.connection);
    }

    public LensClient(Credentials cred) {
        this(cred.getUsername(), cred.getPassword());
    }

    public LensMetadataClient getMetadataClient() {
        return this.mc;
    }

    public LensAPIResult<QueryHandle> executeQueryAsynch(String sql, String queryName) throws LensAPIException {
        log.debug("Executing query {}", (Object)sql);
        LensAPIResult<QueryHandle> lensAPIResult = this.statement.execute(sql, false, queryName);
        LensQuery query = this.statement.getQuery();
        log.debug("Adding query to statementMap {}", (Object)query.getQueryHandle());
        this.statementMap.put(query.getQueryHandle(), this.statement);
        return lensAPIResult;
    }

    public Date getLatestDateOfCube(String cubeName, String timePartition) {
        return this.mc.getLatestDateOfCube(cubeName, timePartition);
    }

    public List<String> getPartitionTimelines(String factName, String storageName, String updatePeriod, String timeDimension) {
        return this.mc.getPartitionTimelines(factName, storageName, updatePeriod, timeDimension);
    }

    public LensClientResultSetWithStats getResults(String sql, String queryName) throws LensAPIException {
        log.debug("Executing query {}", (Object)sql);
        this.statement.execute(sql, true, queryName);
        return this.getResultsFromStatement(this.statement);
    }

    private LensClientResultSetWithStats getResultsFromStatement(LensStatement statement) {
        QueryStatus.Status status = statement.getStatus().getStatus();
        if (status != QueryStatus.Status.SUCCESSFUL) {
            IdBriefErrorTemplate errorResult = new IdBriefErrorTemplate(IdBriefErrorTemplateKey.QUERY_ID, statement.getQueryHandleString(), new BriefError(statement.getErrorCode(), statement.getErrorMessage()));
            throw new LensBriefErrorException(errorResult);
        }
        LensClientResultSet result = null;
        if (statement.getStatus().isResultSetAvailable()) {
            result = new LensClientResultSet(statement.getResultSetMetaData(), statement.getResultSet());
        }
        return new LensClientResultSetWithStats(result, statement.getQuery());
    }

    private LensClientResultSetWithStats getResultsFromHandle(QueryHandle q, boolean async) {
        LensQuery query;
        if (!async) {
            this.statement.waitForQueryToComplete(q);
        }
        if ((query = this.statement.getQuery(q)).getStatus().getStatus() == QueryStatus.Status.FAILED) {
            throw new IllegalStateException(query.getStatus().getErrorMessage());
        }
        LensClientResultSet result = null;
        if (this.statement.getStatus().isResultSetAvailable()) {
            result = new LensClientResultSet(this.statement.getResultSetMetaData(), this.statement.getResultSet());
        }
        return new LensClientResultSetWithStats(result, this.statement.getQuery());
    }

    public LensClientResultSetWithStats getAsyncResults(QueryHandle q) {
        return this.getResultsFromHandle(q, true);
    }

    public LensClientResultSetWithStats getSyncResults(QueryHandle q) {
        return this.getResultsFromHandle(q, false);
    }

    public Response getHttpResults() {
        return this.statement.getHttpResultSet();
    }

    public Response getHttpResults(QueryHandle q) {
        return this.statement.getHttpResultSet(this.statement.getQuery(q));
    }

    public LensStatement getLensStatement(QueryHandle query) {
        return this.statementMap.get(query);
    }

    public QueryStatus getQueryStatus(QueryHandle query) {
        return this.statement.getQuery(query).getStatus();
    }

    public LensQuery getQueryDetails(QueryHandle handle) {
        return this.statement.getQuery(handle);
    }

    public QueryStatus getQueryStatus(String q) {
        return this.getQueryStatus(QueryHandle.fromString((String)q));
    }

    public LensQuery getQueryDetails(String handle) {
        return this.getQueryDetails(QueryHandle.fromString((String)handle));
    }

    public LensAPIResult<QueryPlan> getQueryPlan(String q) throws LensAPIException {
        return this.statement.explainQuery(q);
    }

    public boolean killQuery(QueryHandle q) {
        return this.statement.kill(this.statement.getQuery(q));
    }

    public QueryResult getResults(QueryHandle query) {
        QueryStatus status = this.getLensStatement(query).getStatus();
        if (!status.isResultSetAvailable()) {
            log.debug("Current status of the query is {}", (Object)status);
            throw new IllegalStateException("Resultset for the query " + query + " is not available, its current status is " + status);
        }
        return this.getLensStatement(query).getResultSet();
    }

    public List<QueryHandle> getQueries(String state, String queryName, String user, String driver, long fromDate, long toDate) {
        return this.statement.getAllQueries(state, queryName, user, driver, fromDate, toDate);
    }

    private void connectToLensServer() {
        log.debug("Connecting to lens server {}", (Object)new LensConnectionParams(this.conf));
        this.connection = new LensConnection(new LensConnectionParams(this.conf));
        this.connection.open(this.password);
        log.debug("Successfully connected to server {}", (Object)this.connection);
        this.pathValidator = new PathValidator(this.connection.getLensConnectionParams().getSessionConf());
        Preconditions.checkNotNull((Object)this.pathValidator, (Object)"Error in initializing Path Validator.");
    }

    public List<String> getAllDatabases() {
        log.debug("Getting all database");
        return this.mc.getAlldatabases();
    }

    public List<String> getAllNativeTables() {
        log.debug("Getting all native tables");
        return this.mc.getAllNativeTables();
    }

    public List<String> getAllFactTables() {
        log.debug("Getting all fact table");
        return this.mc.getAllFactTables();
    }

    public List<String> getAllFactTables(String cubeName) {
        log.debug("Getting all fact table");
        return this.mc.getAllFactTables(cubeName);
    }

    public List<String> getAllDimensionTables() {
        log.debug("Getting all dimension table");
        return this.mc.getAllDimensionTables();
    }

    public List<String> getAllDimensionTables(String dimensionName) {
        log.debug("Getting all dimension table");
        return this.mc.getAllDimensionTables(dimensionName);
    }

    public List<String> getAllCubes() {
        log.debug("Getting all cubes in database");
        return this.mc.getAllCubes();
    }

    public List<String> getAllDimensions() {
        log.debug("Getting all dimensions in database");
        return this.mc.getAllDimensions();
    }

    public String getCurrentDatabae() {
        log.debug("Getting current database");
        return this.mc.getCurrentDatabase();
    }

    public boolean setDatabase(String database) {
        log.debug("Set the database to {}", (Object)database);
        APIResult result = this.mc.setDatabase(database);
        return result.getStatus() == APIResult.Status.SUCCEEDED;
    }

    public APIResult dropDatabase(String database, boolean cascade) {
        log.debug("Dropping database {}, cascade: {}", (Object)database, (Object)cascade);
        APIResult result = this.mc.dropDatabase(database, cascade);
        log.debug("Return status of dropping {} result {}", (Object)database, (Object)result);
        return result;
    }

    public APIResult createDatabase(String database, boolean ignoreIfExists) {
        log.debug("Creating database {} ignore {}", (Object)database, (Object)ignoreIfExists);
        APIResult result = this.mc.createDatabase(database, ignoreIfExists);
        log.debug("Create database result {}", (Object)result);
        return result;
    }

    public APIResult setConnectionParam(String key, String val) {
        return this.connection.setConnectionParams(key, val);
    }

    public List<String> getConnectionParam() {
        return this.connection.getConnectionParams();
    }

    public List<String> getConnectionParam(String key) {
        return this.connection.getConnectionParams(key);
    }

    public APIResult closeConnection() {
        log.debug("Closing lens connection: {}", (Object)new LensConnectionParams(this.conf));
        return this.connection.close();
    }

    public APIResult addJarResource(String path) {
        return this.connection.addResourceToConnection("jar", path);
    }

    public APIResult removeJarResource(String path) {
        return this.connection.removeResourceFromConnection("jar", path);
    }

    public APIResult addFileResource(String path) {
        return this.connection.addResourceToConnection("file", path);
    }

    public APIResult removeFileResource(String path) {
        return this.connection.removeResourceFromConnection("file", path);
    }

    public APIResult createFactTable(String factSpec) {
        return this.mc.createFactTable(factSpec);
    }

    public APIResult createCube(String cubeSpec) {
        return this.mc.createCube(cubeSpec);
    }

    public APIResult createStorage(String storageSpec) {
        return this.mc.createNewStorage(storageSpec);
    }

    public APIResult createDimension(String dimSpec) {
        return this.mc.createDimension(dimSpec);
    }

    public APIResult createDimensionTable(String dimSpec) {
        return this.mc.createDimensionTable(dimSpec);
    }

    public List<String> getAllStorages() {
        return this.mc.getAllStorages();
    }

    public APIResult dropDimensionTable(String dim, boolean cascade) {
        return this.mc.dropDimensionTable(dim, cascade);
    }

    public APIResult dropFactTable(String fact, boolean cascade) {
        return this.mc.dropFactTable(fact, cascade);
    }

    public APIResult dropCube(String cube) {
        return this.mc.dropCube(cube);
    }

    public APIResult dropStorage(String storage) {
        return this.mc.dropStorage(storage);
    }

    public APIResult dropDimension(String dimName) {
        return this.mc.dropDimension(dimName);
    }

    public APIResult updateFactTable(String factName, String factSpec) {
        return this.mc.updateFactTable(factName, factSpec);
    }

    public APIResult updateDimensionTable(String dimName, String dimSpec) {
        return this.mc.updateDimensionTable(dimName, dimSpec);
    }

    public APIResult updateCube(String cubeName, String cubeSpec) {
        return this.mc.updateCube(cubeName, cubeSpec);
    }

    public APIResult updateStorage(String storageName, String storageSpec) {
        return this.mc.updateStorage(storageName, storageSpec);
    }

    public APIResult updateDimension(String dimName, String dimSpec) {
        return this.mc.updateDimension(dimName, dimSpec);
    }

    public XFactTable getFactTable(String factName) {
        return this.mc.getFactTable(factName);
    }

    public XDimensionTable getDimensionTable(String dimName) {
        return this.mc.getDimensionTable(dimName);
    }

    public XNativeTable getNativeTable(String tblName) {
        return this.mc.getNativeTable(tblName);
    }

    public XCube getCube(String cubeName) {
        return this.mc.getCube(cubeName);
    }

    public XFlattenedColumns getQueryableFields(String table, boolean flattened) {
        return this.mc.getQueryableFields(table, flattened);
    }

    public XJoinChains getJoinChains(String table) {
        return this.mc.getJoinChains(table);
    }

    public XDimension getDimension(String dimName) {
        return this.mc.getDimension(dimName);
    }

    public XStorage getStorage(String storageName) {
        return this.mc.getStorage(storageName);
    }

    public List<String> getFactStorages(String fact) {
        return this.mc.getAllStoragesOfFactTable(fact);
    }

    public List<String> getDimStorages(String dim) {
        return this.mc.getAllStoragesOfDimTable(dim);
    }

    public APIResult dropAllStoragesOfDim(String table) {
        return this.mc.dropAllStoragesOfDimension(table);
    }

    public APIResult dropAllStoragesOfFact(String table) {
        return this.mc.dropAllStoragesOfFactTable(table);
    }

    public APIResult addStorageToFact(String factName, String spec) {
        return this.mc.addStorageToFactTable(factName, spec);
    }

    public APIResult dropStorageFromFact(String factName, String storage) {
        return this.mc.dropStorageFromFactTable(factName, storage);
    }

    public XStorageTableElement getStorageFromFact(String fact, String storage) {
        return this.mc.getStorageOfFactTable(fact, storage);
    }

    public APIResult addStorageToDim(String dim, String storage) {
        return this.mc.addStorageToDimTable(dim, storage);
    }

    public APIResult dropStorageFromDim(String dim, String storage) {
        return this.mc.dropStoragesOfDimensionTable(dim, storage);
    }

    public XStorageTableElement getStorageFromDim(String dim, String storage) {
        return this.mc.getStorageOfDimensionTable(dim, storage);
    }

    public List<XPartition> getAllPartitionsOfFact(String fact, String storage) {
        return this.mc.getPartitionsOfFactTable(fact, storage);
    }

    public List<XPartition> getAllPartitionsOfFact(String fact, String storage, String list) {
        return this.mc.getPartitionsOfFactTable(fact, storage, list);
    }

    public List<XPartition> getAllPartitionsOfDim(String dim, String storage) {
        return this.mc.getAllPartitionsOfDimensionTable(dim, storage);
    }

    public List<XPartition> getAllPartitionsOfDim(String dim, String storage, String list) {
        return this.mc.getAllPartitionsOfDimensionTable(dim, storage);
    }

    public APIResult dropAllPartitionsOfFact(String fact, String storage) {
        return this.mc.dropPartitionsOfFactTable(fact, storage);
    }

    public APIResult dropAllPartitionsOfFact(String fact, String storage, String list) {
        return this.mc.dropPartitionsOfFactTable(fact, storage, list);
    }

    public APIResult dropAllPartitionsOfDim(String dim, String storage) {
        return this.mc.dropAllPartitionsOfDimensionTable(dim, storage);
    }

    public APIResult dropAllPartitionsOfDim(String dim, String storage, String list) {
        return this.mc.dropAllPartitionsOfDimensionTable(dim, storage, list);
    }

    public APIResult addPartitionToFact(String table, String storage, String partSpec) {
        return this.mc.addPartitionToFactTable(table, storage, partSpec);
    }

    public APIResult addPartitionsToFact(String table, String storage, String partsSpec) {
        return this.mc.addPartitionsToFactTable(table, storage, partsSpec);
    }

    public APIResult addPartitionToFact(String table, String storage, XPartition xp) {
        return this.mc.addPartitionToFactTable(table, storage, xp);
    }

    public APIResult addPartitionsToFact(String table, String storage, XPartitionList xpList) {
        return this.mc.addPartitionsToFactTable(table, storage, xpList);
    }

    public APIResult addPartitionToDim(String table, String storage, String partSpec) {
        return this.mc.addPartitionToDimensionTable(table, storage, partSpec);
    }

    public APIResult addPartitionToDim(String table, String storage, XPartition xp) {
        return this.mc.addPartitionToDimensionTable(table, storage, xp);
    }

    public APIResult addPartitionsToDim(String table, String storage, XPartitionList xpList) {
        return this.mc.addPartitionsToDimensionTable(table, storage, xpList);
    }

    public APIResult addPartitionsToDim(String table, String storage, String partsSpec) {
        return this.mc.addPartitionsToDimensionTable(table, storage, partsSpec);
    }

    public APIResult updatePartitionOfFact(String table, String storage, String partSpec) {
        return this.mc.updatePartitionOfFactTable(table, storage, partSpec);
    }

    public APIResult updatePartitionsOfFact(String table, String storage, String partsSpec) {
        return this.mc.updatePartitionsOfFactTable(table, storage, partsSpec);
    }

    public APIResult updatePartitionOfFact(String table, String storage, XPartition xp) {
        return this.mc.updatePartitionOfFactTable(table, storage, xp);
    }

    public APIResult updatePartitionsOfFact(String table, String storage, XPartitionList xpList) {
        return this.mc.updatePartitionsOfFactTable(table, storage, xpList);
    }

    public APIResult updatePartitionOfDim(String table, String storage, String partSpec) {
        return this.mc.updatePartitionOfDimensionTable(table, storage, partSpec);
    }

    public APIResult updatePartitionOfDim(String table, String storage, XPartition xp) {
        return this.mc.updatePartitionOfDimensionTable(table, storage, xp);
    }

    public APIResult updatePartitionsOfDim(String table, String storage, XPartitionList xpList) {
        return this.mc.updatePartitionsOfDimensionTable(table, storage, xpList);
    }

    public APIResult updatePartitionsOfDim(String table, String storage, String partsSpec) {
        return this.mc.updatePartitionsOfDimensionTable(table, storage, partsSpec);
    }

    public LensAPIResult<QueryPrepareHandle> prepare(String sql, String queryName) throws LensAPIException {
        return this.statement.prepareQuery(sql, queryName);
    }

    public LensAPIResult<QueryPlan> explainAndPrepare(String sql, String queryName) throws LensAPIException {
        return this.statement.explainAndPrepare(sql, queryName);
    }

    public boolean destroyPrepared(QueryPrepareHandle queryPrepareHandle) {
        return this.statement.destroyPrepared(queryPrepareHandle);
    }

    public List<QueryPrepareHandle> getPreparedQueries(String userName, String queryName, long fromDate, long toDate) {
        return this.statement.getAllPreparedQueries(userName, queryName, fromDate, toDate);
    }

    public LensPreparedQuery getPreparedQuery(QueryPrepareHandle phandle) {
        return this.statement.getPreparedQuery(phandle);
    }

    public LensClientResultSetWithStats getResultsFromPrepared(QueryPrepareHandle phandle, String queryName) {
        QueryHandle qh = this.statement.executeQuery(phandle, true, queryName);
        return this.getResultsFromHandle(qh, true);
    }

    public QueryHandle executePrepared(QueryPrepareHandle phandle, String queryName) {
        return this.statement.executeQuery(phandle, false, queryName);
    }

    public boolean isConnectionOpen() {
        return this.connection.isOpen();
    }

    public List<String> listResources(String type) {
        return this.connection.listResourcesFromConnection(type);
    }

    public Response getLogs(String logFile) {
        return this.connection.getLogs(logFile);
    }

    public LensMetadataClient getMc() {
        return this.mc;
    }

    public LensConnection getConnection() {
        return this.connection;
    }

    public LensStatement getStatement() {
        return this.statement;
    }

    public PathValidator getPathValidator() {
        return this.pathValidator;
    }

    public static class LensClientResultSetWithStats {
        private final LensClientResultSet resultSet;
        private final LensQuery query;

        public LensClientResultSetWithStats(LensClientResultSet resultSet, LensQuery query) {
            this.resultSet = resultSet;
            this.query = query;
        }

        public LensClientResultSet getResultSet() {
            return this.resultSet;
        }

        public LensQuery getQuery() {
            return this.query;
        }
    }
}

