/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.config.ConfigCommandSupport;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class ConfigPropertyCommandSupport
extends ConfigCommandSupport {
    @Option(name="-p", aliases={"--pid"}, description="The configuration pid", required=false, multiValued=false)
    protected String pid;
    @Option(name="-b", aliases={"--bypass-storage"}, multiValued=false, required=false, description="Do not store the configuration in a properties file, but feed it directly to ConfigAdmin")
    protected boolean bypassStorage;

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Dictionary props = this.getEditedProps();
        if (props == null && this.pid == null) {
            System.err.println("No configuration is being edited--run the edit command first");
        } else {
            if (props == null) {
                props = new Properties();
            }
            this.propertyAction(props);
            if (this.requiresUpdate(this.pid)) {
                this.update(admin, this.pid, props, this.bypassStorage);
            }
        }
    }

    protected abstract void propertyAction(Dictionary var1);

    protected boolean requiresUpdate(String pid) {
        return pid != null;
    }

    protected Dictionary getEditedProps() throws Exception {
        Configuration configuration;
        Configuration[] configs;
        ConfigurationAdmin configurationAdmin;
        if (this.pid != null && (configurationAdmin = this.getConfigurationAdmin()) != null && (configs = configurationAdmin.listConfigurations("(service.pid=" + this.pid + ")")) != null && configs.length > 0 && (configuration = configs[0]) != null) {
            return configuration.getProperties();
        }
        return super.getEditedProps();
    }
}

