/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.dev.internal;

import java.io.File;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.management.mbeans.dev.DevMBean;
import org.osgi.framework.BundleContext;

public class DevMBeanImpl
extends StandardMBean
implements DevMBean {
    private BundleContext bundleContext;

    public DevMBeanImpl() throws NotCompliantMBeanException {
        super(DevMBean.class);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String framework() throws Exception {
        if (this.bundleContext.getBundle(0L).getSymbolicName().contains("felix")) {
            return "Felix";
        }
        return "Equinox";
    }

    public void frameworkOptions(boolean debug, String framework) throws Exception {
        Properties properties = new Properties(new File(System.getProperty("karaf.base"), "etc/config.properties"));
        if (framework != null) {
            if (!framework.equalsIgnoreCase("felix") && !framework.equalsIgnoreCase("equinox")) {
                throw new IllegalArgumentException("Unsupported framework " + framework);
            }
            properties.put("karaf.framework", framework.toLowerCase());
        }
        if (debug) {
            properties.put("felix.log.level", "4");
            properties.put("osgi.debug", "etc/equinox-debug.properties");
        } else {
            properties.remove("felix.log.level");
            properties.remove("osgi.debug");
        }
        properties.save();
    }

    public void restart(boolean clean) throws Exception {
        System.setProperty("karaf.restart", "true");
        System.setProperty("karaf.restart.clean", Boolean.toString(clean));
        this.bundleContext.getBundle(0L).stop();
    }
}

