/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.h2.result.RowFactory;
import org.h2.value.Value;

public class GridH2RowFactory
extends RowFactory {
    public static GridH2Row create(Value v) {
        return new RowKey(v);
    }

    public static GridH2Row create(Value v1, Value v2) {
        return new RowPair(v1, v2);
    }

    public static GridH2Row create(Value ... data) {
        switch (data.length) {
            case 0: {
                throw new IllegalStateException("Zero columns row.");
            }
            case 1: {
                return new RowKey(data[0]);
            }
            case 2: {
                return new RowPair(data[0], data[1]);
            }
        }
        return new RowSimple(data);
    }

    public GridH2Row createRow(Value[] data, int memory) {
        return GridH2RowFactory.create(data);
    }

    private static final class RowSimple
    extends GridH2Row {
        @GridToStringInclude
        private Value[] vals;

        private RowSimple(Value[] vals) {
            this.vals = vals;
        }

        public int getColumnCount() {
            return this.vals.length;
        }

        public Value getValue(int idx) {
            return this.vals[idx];
        }

        public void setValue(int idx, Value v) {
            this.vals[idx] = v;
        }

        public String toString() {
            return S.toString(RowSimple.class, (Object)this);
        }

        public long expireTime() {
            return 0L;
        }
    }

    private static final class RowPair
    extends GridH2Row {
        private Value v1;
        private Value v2;

        private RowPair(Value v1, Value v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public int getColumnCount() {
            return 2;
        }

        public Value getValue(int idx) {
            return idx == 0 ? this.v1 : this.v2;
        }

        public void setValue(int idx, Value v) {
            if (idx == 0) {
                this.v1 = v;
            } else {
                assert (idx == 1) : idx;
                this.v2 = v;
            }
        }

        public long expireTime() {
            return 0L;
        }
    }

    private static final class RowKey
    extends GridH2Row {
        private Value key;

        public RowKey(Value key) {
            this.key = key;
        }

        public int getColumnCount() {
            return 1;
        }

        public Value getValue(int idx) {
            assert (idx == 0) : idx;
            return this.key;
        }

        public void setValue(int idx, Value v) {
            assert (idx == 0) : idx;
            this.key = v;
        }

        public long expireTime() {
            return 0L;
        }
    }
}

