/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto;

import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWEProvider;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jca.JWEJCAContext;

abstract class BaseJWEProvider
implements JWEProvider {
    private final Set<JWEAlgorithm> algs;
    private final Set<EncryptionMethod> encs;
    private final JWEJCAContext jcaContext = new JWEJCAContext();

    public BaseJWEProvider(Set<JWEAlgorithm> algs, Set<EncryptionMethod> encs) {
        if (algs == null) {
            throw new IllegalArgumentException("The supported JWE algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(algs);
        if (encs == null) {
            throw new IllegalArgumentException("The supported encryption methods must not be null");
        }
        this.encs = encs;
    }

    @Override
    public Set<JWEAlgorithm> supportedJWEAlgorithms() {
        return this.algs;
    }

    @Override
    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return this.encs;
    }

    @Override
    public JWEJCAContext getJCAContext() {
        return this.jcaContext;
    }
}

