/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestStoreFileScannerWithTagCompression {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf = TEST_UTIL.getConfiguration();
    private static CacheConfig cacheConf = new CacheConfig(TEST_UTIL.getConfiguration());
    private static String ROOT_DIR = TEST_UTIL.getDataTestDir("TestStoreFileScannerWithTagCompression").toString();
    private static FileSystem fs = null;

    @BeforeClass
    public static void setUp() throws IOException {
        conf.setInt("hfile.format.version", 3);
        fs = FileSystem.get((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReseek() throws Exception {
        Path f = new Path(ROOT_DIR, "testReseek");
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withIncludesTags(true).withCompressTags(true).withDataBlockEncoding(DataBlockEncoding.PREFIX).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(conf, cacheConf, fs).withFilePath(f).withFileContext(meta).build();
        this.writeStoreFile(writer);
        writer.close();
        StoreFile.Reader reader = new StoreFile.Reader(fs, f, cacheConf, conf);
        try (StoreFileScanner s = reader.getStoreFileScanner(false, false);){
            KeyValue k = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"k2"));
            s.reseek((Cell)k);
            Cell kv = s.next();
            kv = s.next();
            kv = s.next();
            byte[] key5 = Bytes.toBytes((String)"k5");
            Assert.assertTrue((boolean)Bytes.equals((byte[])key5, (int)0, (int)key5.length, (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
            List tags = KeyValueUtil.ensureKeyValue((Cell)kv).getTags();
            Assert.assertEquals((long)1L, (long)tags.size());
            Assert.assertEquals((Object)"tag3", (Object)Bytes.toString((byte[])((Tag)tags.get(0)).getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStoreFile(StoreFile.Writer writer) throws IOException {
        byte[] fam = Bytes.toBytes((String)"f");
        byte[] qualifier = Bytes.toBytes((String)"q");
        long now = System.currentTimeMillis();
        byte[] b = Bytes.toBytes((String)"k1");
        Tag t1 = new Tag(1, "tag1");
        Tag t2 = new Tag(2, "tag2");
        Tag t3 = new Tag(3, "tag3");
        try {
            writer.append((Cell)new KeyValue(b, fam, qualifier, now, b, new Tag[]{t1}));
            b = Bytes.toBytes((String)"k3");
            writer.append((Cell)new KeyValue(b, fam, qualifier, now, b, new Tag[]{t2, t1}));
            b = Bytes.toBytes((String)"k4");
            writer.append((Cell)new KeyValue(b, fam, qualifier, now, b, new Tag[]{t3}));
            b = Bytes.toBytes((String)"k5");
            writer.append((Cell)new KeyValue(b, fam, qualifier, now, b, new Tag[]{t3}));
        }
        finally {
            writer.close();
        }
    }
}

