/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestRegionRebalancing {
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"col");
    public static final Log LOG = LogFactory.getLog(TestRegionRebalancing.class);
    private final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private RegionLocator regionLocator;
    private HTableDescriptor desc;
    private String balancerName;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        String[][] balancers = new String[][]{{"org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer"}, {"org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer"}};
        return Arrays.asList(balancers);
    }

    public TestRegionRebalancing(String balancerName) {
        this.balancerName = balancerName;
    }

    @After
    public void after() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws Exception {
        this.UTIL.getConfiguration().set("hbase.master.loadbalancer.class", this.balancerName);
        this.UTIL.startMiniCluster(1);
        this.desc = new HTableDescriptor(TableName.valueOf((String)"test"));
        this.desc.addFamily(new HColumnDescriptor(FAMILY_NAME));
    }

    @Test(timeout=300000L)
    public void testRebalanceOnRegionServerNumberChange() throws IOException, InterruptedException {
        try (Connection connection = ConnectionFactory.createConnection((Configuration)this.UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable(this.desc, (byte[][])Arrays.copyOfRange(HBaseTestingUtility.KEYS, 1, HBaseTestingUtility.KEYS.length));
            this.regionLocator = connection.getRegionLocator(this.desc.getTableName());
            MetaTableAccessor.fullScanMetaAndPrint((Connection)admin.getConnection());
            Assert.assertEquals((String)"Test table should have right number of regions", (long)HBaseTestingUtility.KEYS.length, (long)this.regionLocator.getStartKeys().length);
            this.assertRegionsAreBalanced();
            LOG.info((Object)("Started second server=" + this.UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName()));
            this.UTIL.getHBaseCluster().getMaster().balance();
            this.assertRegionsAreBalanced();
            assert (this.UTIL.getHBaseCluster().getMaster().balance());
            LOG.info((Object)("Started third server=" + this.UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName()));
            assert (this.UTIL.getHBaseCluster().getMaster().balance());
            this.assertRegionsAreBalanced();
            LOG.info((Object)("Stopped third server=" + this.UTIL.getHBaseCluster().stopRegionServer(2, false)));
            this.UTIL.getHBaseCluster().waitOnRegionServer(2);
            this.waitOnCrashProcessing();
            this.UTIL.getHBaseCluster().getMaster().balance();
            this.assertRegionsAreBalanced();
            LOG.info((Object)("Readding third server=" + this.UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName()));
            LOG.info((Object)("Added fourth server=" + this.UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName()));
            this.waitOnCrashProcessing();
            assert (this.UTIL.getHBaseCluster().getMaster().balance());
            this.assertRegionsAreBalanced();
            for (int i = 0; i < 6; ++i) {
                LOG.info((Object)("Adding " + (i + 5) + "th region server"));
                this.UTIL.getHBaseCluster().startRegionServer();
            }
            assert (this.UTIL.getHBaseCluster().getMaster().balance());
            this.assertRegionsAreBalanced();
            this.regionLocator.close();
        }
    }

    private void waitOnCrashProcessing() {
        while (this.UTIL.getHBaseCluster().getMaster().getServerManager().areDeadServersInProgress()) {
            LOG.info((Object)"Waiting on processing of crashed server before proceeding...");
            Threads.sleep((long)1000L);
        }
    }

    private void assertRegionsAreBalanced() throws IOException {
        boolean success = false;
        float slop = this.UTIL.getConfiguration().getFloat("hbase.regions.slop", 0.1f);
        if (slop <= 0.0f) {
            slop = 1.0f;
        }
        for (int i = 0; i < 5; ++i) {
            success = true;
            this.waitForAllRegionsAssigned();
            long regionCount = this.UTIL.getMiniHBaseCluster().countServedRegions();
            List<HRegionServer> servers = this.getOnlineRegionServers();
            double avg = this.UTIL.getHBaseCluster().getMaster().getAverageLoad();
            int avgLoadPlusSlop = (int)Math.ceil(avg * (double)(1.0f + slop));
            int avgLoadMinusSlop = (int)Math.floor(avg * (double)(1.0f - slop)) - 1;
            LOG.debug((Object)("There are " + servers.size() + " servers and " + regionCount + " regions. Load Average: " + avg + " low border: " + avgLoadMinusSlop + ", up border: " + avgLoadPlusSlop + "; attempt: " + i));
            for (HRegionServer server : servers) {
                int serverLoad = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices()).size();
                LOG.debug((Object)(server.getServerName() + " Avg: " + avg + " actual: " + serverLoad));
                if (avg > 2.0 && serverLoad <= avgLoadPlusSlop && serverLoad >= avgLoadMinusSlop) continue;
                for (HRegionInfo hri : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices())) {
                    if (!hri.isMetaRegion()) continue;
                    --serverLoad;
                }
                if (serverLoad <= avgLoadPlusSlop && serverLoad >= avgLoadMinusSlop) continue;
                LOG.debug((Object)(server.getServerName() + " Isn't balanced!!! Avg: " + avg + " actual: " + serverLoad + " slop: " + slop));
                success = false;
                break;
            }
            if (!success) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } else {
                return;
            }
            this.UTIL.getHBaseCluster().getMaster().balance();
        }
        Assert.fail((String)"After 5 attempts, region assignments were not balanced.");
    }

    private List<HRegionServer> getOnlineRegionServers() {
        ArrayList<HRegionServer> list = new ArrayList<HRegionServer>();
        for (JVMClusterUtil.RegionServerThread rst : this.UTIL.getHBaseCluster().getRegionServerThreads()) {
            if (!rst.getRegionServer().isOnline()) continue;
            list.add(rst.getRegionServer());
        }
        return list;
    }

    private void waitForAllRegionsAssigned() throws IOException {
        int totalRegions = HBaseTestingUtility.KEYS.length;
        while (this.UTIL.getMiniHBaseCluster().countServedRegions() < (long)totalRegions) {
            LOG.debug((Object)("Waiting for there to be " + totalRegions + " regions, but there are " + this.UTIL.getMiniHBaseCluster().countServedRegions() + " right now."));
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {}
        }
        RegionStates regionStates = this.UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
        while (!regionStates.getRegionsInTransition().isEmpty()) {
            Threads.sleep((long)100L);
        }
    }
}

