/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCreatedLeafQueue
extends AbstractAutoCreatedLeafQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AutoCreatedLeafQueue.class);

    public AutoCreatedLeafQueue(CapacitySchedulerContext cs, String queueName, ManagedParentQueue parent) throws IOException {
        super(cs, parent.getLeafQueueConfigs(queueName), queueName, parent, null);
        this.updateCapacitiesToZero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        try {
            this.writeLock.lock();
            this.validate(newlyParsedQueue);
            ManagedParentQueue managedParentQueue = (ManagedParentQueue)this.parent;
            super.reinitialize(newlyParsedQueue, clusterResource, managedParentQueue.getLeafQueueConfigs(newlyParsedQueue.getQueueName()));
            this.updateCapacitiesToZero();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reinitializeFromTemplate(AutoCreatedLeafQueueConfig leafQueueTemplate) throws SchedulerDynamicEditException, IOException {
        try {
            this.writeLock.lock();
            QueueCapacities capacities = leafQueueTemplate.getQueueCapacities();
            this.setupConfigurableCapacities(capacities);
            this.mergeCapacities(capacities);
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this.csContext.getClusterResource(), this, this.labelManager, null);
            this.activateApplications();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void mergeCapacities(QueueCapacities capacities) {
        for (String nodeLabel : capacities.getExistingNodeLabels()) {
            this.queueCapacities.setCapacity(nodeLabel, capacities.getCapacity(nodeLabel));
            this.queueCapacities.setAbsoluteCapacity(nodeLabel, capacities.getAbsoluteCapacity(nodeLabel));
            this.queueCapacities.setMaximumCapacity(nodeLabel, capacities.getMaximumCapacity(nodeLabel));
            this.queueCapacities.setAbsoluteMaximumCapacity(nodeLabel, capacities.getAbsoluteMaximumCapacity(nodeLabel));
            Resource resourceByLabel = this.labelManager.getResourceByLabel(nodeLabel, this.csContext.getClusterResource());
            this.getQueueResourceQuotas().setEffectiveMinResource(nodeLabel, Resources.multiply((Resource)resourceByLabel, (double)this.queueCapacities.getAbsoluteCapacity(nodeLabel)));
            this.getQueueResourceQuotas().setEffectiveMaxResource(nodeLabel, Resources.multiply((Resource)resourceByLabel, (double)this.queueCapacities.getAbsoluteMaximumCapacity(nodeLabel)));
        }
    }

    public void validateConfigurations(AutoCreatedLeafQueueConfig template) throws SchedulerDynamicEditException {
        QueueCapacities capacities = template.getQueueCapacities();
        for (String label : capacities.getExistingNodeLabels()) {
            float capacity = capacities.getCapacity(label);
            if (!(capacity < 0.0f) && !(capacity > 1.0f)) continue;
            throw new SchedulerDynamicEditException("Capacity demand is not in the [0,1] range: " + capacity);
        }
    }

    private void validate(CSQueue newlyParsedQueue) throws IOException {
        if (!(newlyParsedQueue instanceof AutoCreatedLeafQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Error trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
    }

    private void updateCapacitiesToZero() throws IOException {
        try {
            for (String nodeLabel : this.parent.getQueueCapacities().getExistingNodeLabels()) {
                this.setEntitlement(nodeLabel, new QueueEntitlement(0.0f, this.parent.getLeafQueueTemplate().getQueueCapacities().getMaximumCapacity(nodeLabel)));
            }
        }
        catch (SchedulerDynamicEditException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }
}

