/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RLESparseResourceAllocation {
    private static final int THRESHOLD = 100;
    private static final Resource ZERO_RESOURCE = Resource.newInstance((int)0, (int)0);
    private TreeMap<Long, Resource> cumulativeCapacity = new TreeMap();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final ResourceCalculator resourceCalculator;
    private final Resource minAlloc;

    public RLESparseResourceAllocation(ResourceCalculator resourceCalculator, Resource minAlloc) {
        this.resourceCalculator = resourceCalculator;
        this.minAlloc = minAlloc;
    }

    private boolean isSameAsPrevious(Long key, Resource capacity) {
        Map.Entry<Long, Resource> previous = this.cumulativeCapacity.lowerEntry(key);
        return previous != null && previous.getValue().equals((Object)capacity);
    }

    private boolean isSameAsNext(Long key, Resource capacity) {
        Map.Entry<Long, Resource> next = this.cumulativeCapacity.higherEntry(key);
        return next != null && next.getValue().equals((Object)capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInterval(ReservationInterval reservationInterval, ReservationRequest capacity) {
        Resource totCap = Resources.multiply((Resource)capacity.getCapability(), (double)capacity.getNumContainers());
        if (totCap.equals((Object)ZERO_RESOURCE)) {
            return true;
        }
        this.writeLock.lock();
        try {
            long startKey = reservationInterval.getStartTime();
            long endKey = reservationInterval.getEndTime();
            NavigableMap<Long, Resource> ticks = this.cumulativeCapacity.headMap(endKey, false);
            if (ticks != null && !ticks.isEmpty()) {
                Resource updatedCapacity = Resource.newInstance((int)0, (int)0);
                Map.Entry<Long, Resource> lowEntry = ticks.floorEntry(startKey);
                if (lowEntry == null) {
                    this.cumulativeCapacity.put(startKey, totCap);
                } else {
                    updatedCapacity = Resources.add((Resource)lowEntry.getValue(), (Resource)totCap);
                    if (startKey == lowEntry.getKey() && this.isSameAsPrevious(lowEntry.getKey(), updatedCapacity)) {
                        this.cumulativeCapacity.remove(lowEntry.getKey());
                    } else {
                        this.cumulativeCapacity.put(startKey, updatedCapacity);
                    }
                }
                Set overlapSet = ticks.tailMap(startKey, false).entrySet();
                for (Map.Entry entry : overlapSet) {
                    updatedCapacity = Resources.add((Resource)((Resource)entry.getValue()), (Resource)totCap);
                    entry.setValue(updatedCapacity);
                }
            } else {
                this.cumulativeCapacity.put(startKey, totCap);
            }
            Resource nextTick = this.cumulativeCapacity.get(endKey);
            if (nextTick != null) {
                if (this.isSameAsPrevious(endKey, nextTick)) {
                    this.cumulativeCapacity.remove(endKey);
                }
            } else {
                this.cumulativeCapacity.put(endKey, Resources.subtract((Resource)this.cumulativeCapacity.floorEntry(endKey).getValue(), (Resource)totCap));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean addCompositeInterval(ReservationInterval reservationInterval, List<ReservationRequest> ReservationRequests, Resource clusterResource) {
        ReservationRequest aggregateReservationRequest = (ReservationRequest)Records.newRecord(ReservationRequest.class);
        Resource capacity = Resource.newInstance((int)0, (int)0);
        for (ReservationRequest ReservationRequest2 : ReservationRequests) {
            Resources.addTo((Resource)capacity, (Resource)Resources.multiply((Resource)ReservationRequest2.getCapability(), (double)ReservationRequest2.getNumContainers()));
        }
        aggregateReservationRequest.setNumContainers((int)Math.ceil(Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)capacity, (Resource)this.minAlloc)));
        aggregateReservationRequest.setCapability(this.minAlloc);
        return this.addInterval(reservationInterval, aggregateReservationRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInterval(ReservationInterval reservationInterval, ReservationRequest capacity) {
        Resource totCap = Resources.multiply((Resource)capacity.getCapability(), (double)capacity.getNumContainers());
        if (totCap.equals((Object)ZERO_RESOURCE)) {
            return true;
        }
        this.writeLock.lock();
        try {
            long startKey = reservationInterval.getStartTime();
            long endKey = reservationInterval.getEndTime();
            NavigableMap<Long, Resource> ticks = this.cumulativeCapacity.headMap(endKey, false);
            SortedMap<Long, Resource> overlapSet = ticks.tailMap(startKey);
            if (overlapSet != null && !overlapSet.isEmpty()) {
                Resource updatedCapacity = Resource.newInstance((int)0, (int)0);
                long currentKey = -1L;
                for (Map.Entry<Long, Resource> entry : overlapSet.entrySet()) {
                    currentKey = entry.getKey();
                    updatedCapacity = Resources.subtract((Resource)entry.getValue(), (Resource)totCap);
                    this.cumulativeCapacity.put(currentKey, updatedCapacity);
                }
                Long firstKey = overlapSet.firstKey();
                if (this.isSameAsPrevious(firstKey, (Resource)overlapSet.get(firstKey))) {
                    this.cumulativeCapacity.remove(firstKey);
                }
                if (currentKey != -1L && this.isSameAsNext(currentKey, updatedCapacity)) {
                    this.cumulativeCapacity.remove(this.cumulativeCapacity.higherKey(currentKey));
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getCapacityAtTime(long tick) {
        this.readLock.lock();
        try {
            Map.Entry<Long, Resource> closestStep = this.cumulativeCapacity.floorEntry(tick);
            if (closestStep != null) {
                Resource resource = Resources.clone((Resource)closestStep.getValue());
                return resource;
            }
            Resource resource = Resources.clone((Resource)ZERO_RESOURCE);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEarliestStartTime() {
        this.readLock.lock();
        try {
            if (this.cumulativeCapacity.isEmpty()) {
                long l = -1L;
                return l;
            }
            long l = this.cumulativeCapacity.firstKey();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestEndTime() {
        this.readLock.lock();
        try {
            if (this.cumulativeCapacity.isEmpty()) {
                long l = -1L;
                return l;
            }
            long l = this.cumulativeCapacity.lastKey();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            if (this.cumulativeCapacity.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (this.cumulativeCapacity.size() == 1) {
                boolean bl = this.cumulativeCapacity.firstEntry().getValue().equals((Object)ZERO_RESOURCE);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder ret = new StringBuilder();
        this.readLock.lock();
        try {
            if (this.cumulativeCapacity.size() > 100) {
                ret.append("Number of steps: ").append(this.cumulativeCapacity.size()).append(" earliest entry: ").append(this.cumulativeCapacity.firstKey()).append(" latest entry: ").append(this.cumulativeCapacity.lastKey());
            } else {
                for (Map.Entry<Long, Resource> r : this.cumulativeCapacity.entrySet()) {
                    ret.append(r.getKey()).append(": ").append(r.getValue()).append("\n ");
                }
            }
            String string = ret.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toMemJSONString() {
        StringWriter json = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)json);
        this.readLock.lock();
        try {
            jsonWriter.beginObject();
            for (Map.Entry<Long, Resource> r : this.cumulativeCapacity.entrySet()) {
                jsonWriter.name(r.getKey().toString()).value(r.getValue().toString());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String i$ = json.toString();
            return i$;
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

